/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.commons.eclipse.messagingsystem.ui;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.Hashtable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.api.MessagingSystem;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.ui.Activator;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.ui.ConsoleLogLevel;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.ui.internal.EclipseReporter;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.ui.internal.console.ConsoleIO;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.ui.internal.console.EclipseConsoleIO;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.ui.internal.console.EclipseConsoleIOFactory;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.ui.internal.console.message.ConsoleMessage;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.ui.internal.console.message.DebugErrorMessage;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.ui.internal.console.message.DebugMessage;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.ui.internal.console.message.DebugWarningMessage;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.ui.internal.console.message.ErrorMessage;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.ui.internal.console.message.ImportantMessage;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.ui.internal.console.message.InfoMessage;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.ui.internal.console.message.WarningMessage;
import org.eclipse.gemoc.commons.messagingsystem.api.impl.StdioSimpleMessagingSystem;
import org.eclipse.gemoc.commons.messagingsystem.api.reference.Reference;
import org.eclipse.ui.PlatformUI;

public class EclipseMessagingSystem
extends MessagingSystem {
    EclipseReporter eclipseReporter;
    protected ConsoleIO consoleIO;
    protected int progressBarMaxDepth = 1;
    protected long progressBarIdleTime = 100L;
    protected int progressBarScale = 1000;
    protected Hashtable<String, Long> progressStartTimeTable = new Hashtable();
    protected Hashtable<String, IProgressMonitor> progressMonitorTable = new Hashtable();
    protected Integer consoleLogLevel = 1;
    protected StdioSimpleMessagingSystem fallbackMessagingSystem = null;

    public ConsoleIO getConsoleIO() {
        if (this.consoleIO == null) {
            this.consoleIO = this.baseMessageGroup == null || this.baseMessageGroup.isEmpty() ? Activator.getDefault().getConsoleIO() : EclipseConsoleIOFactory.getInstance().getConsoleIO(this.baseMessageGroup, this.userFriendlyName);
        }
        return this.consoleIO;
    }

    public Integer getConsoleLogLevel() {
        return this.consoleLogLevel;
    }

    public void setConsoleLogLevel(Integer consoleLogLevel) {
        this.consoleLogLevel = consoleLogLevel;
    }

    public EclipseMessagingSystem() {
        this.eclipseReporter = new EclipseReporter(this);
    }

    public void doneProgress(String progressGroup, String msg, String msgGroup) {
        boolean mustLog = false;
        IProgressMonitor progressMonitor = this.getProgressMonitor(progressGroup);
        if (progressMonitor != null) {
            progressMonitor.subTask(msg);
            progressMonitor.done();
            if (progressMonitor != null) {
                this.releaseProgressMonitor(progressGroup);
            }
        } else {
            mustLog = true;
        }
        MessagingSystem.Kind logLevel = mustLog ? MessagingSystem.Kind.UserINFO : MessagingSystem.Kind.DevINFO;
        this.log(logLevel, "[" + progressGroup + "]" + msg + this.getElapsedTime(progressGroup), msgGroup);
    }

    private String getIntermediateElapsedTime(String progressGroup) {
        Long startTime;
        String elapsedTime = "";
        if (progressGroup != null && (startTime = this.progressStartTimeTable.get(progressGroup)) != null) {
            long endTime = System.currentTimeMillis() - startTime;
            elapsedTime = " (T0 + " + endTime + "ms)";
        }
        return elapsedTime;
    }

    private String getElapsedTime(String progressGroup) {
        Long startTime;
        String elapsedTime = "";
        if (progressGroup != null && (startTime = this.progressStartTimeTable.get(progressGroup)) != null) {
            long endTime = System.currentTimeMillis() - startTime;
            elapsedTime = " (done in " + endTime + "ms)";
            this.progressStartTimeTable.remove(progressGroup);
        }
        return elapsedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IProgressMonitor releaseProgressMonitor(String progressGroup) {
        EclipseMessagingSystem eclipseMessagingSystem = this;
        synchronized (eclipseMessagingSystem) {
            return this.progressMonitorTable.remove(progressGroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IProgressMonitor getProgressMonitor(String progressGroup) {
        EclipseMessagingSystem eclipseMessagingSystem = this;
        synchronized (eclipseMessagingSystem) {
            return this.progressMonitorTable.get(progressGroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProgressMonitor(String progressGroup, IProgressMonitor progressMonitor) {
        EclipseMessagingSystem eclipseMessagingSystem = this;
        synchronized (eclipseMessagingSystem) {
            this.progressMonitorTable.put(progressGroup, progressMonitor);
        }
    }

    private IProgressMonitor getParentProgressMonitor(String progressGroup) {
        if (progressGroup.contains(".")) {
            String parentProgressGroup = progressGroup.substring(0, progressGroup.lastIndexOf("."));
            IProgressMonitor result = this.progressMonitorTable.get(parentProgressGroup);
            if (result != null) {
                return result;
            }
            return this.getParentProgressMonitor(parentProgressGroup);
        }
        return null;
    }

    public void initProgress(String progressGroup, String msg, String msgGroup, int unitToWork) {
        boolean mustLog = false;
        if (this.progressBarMaxDepth > 0) {
            IProgressMonitor progressMonitor = this.getProgressMonitor(progressGroup);
            if (progressMonitor != null) {
                progressMonitor.beginTask(msg, unitToWork * this.progressBarScale);
            } else {
                IProgressMonitor parentProgressMonitor = this.getParentProgressMonitor(progressGroup);
                if (parentProgressMonitor != null) {
                    progressMonitor = new SubProgressMonitor(parentProgressMonitor, 1 * this.progressBarScale);
                    this.addProgressMonitor(progressGroup, progressMonitor);
                    progressMonitor.beginTask(msg, unitToWork * this.progressBarScale);
                } else {
                    mustLog = true;
                }
            }
        } else {
            mustLog = true;
        }
        if (mustLog) {
            this.log(MessagingSystem.Kind.DevINFO, "[" + progressGroup + "]" + msg, msgGroup);
        }
        if (progressGroup != null) {
            this.progressStartTimeTable.put(progressGroup, System.currentTimeMillis());
        }
    }

    public void clearLog() {
        this.getConsoleIO().clear();
    }

    public void log(MessagingSystem.Kind msgKind, String message, String messageGroup) {
        switch (msgKind) {
            case DevWARNING: {
                if (messageGroup != null && messageGroup.isEmpty()) break;
                Activator.getDefault().getLog().log((IStatus)new Status(2, messageGroup, 2, message != null ? message : "<null>", null));
                break;
            }
            case DevERROR: {
                if (messageGroup != null && messageGroup.isEmpty()) break;
                Activator.getDefault().getLog().log((IStatus)new Status(4, messageGroup, 4, message != null ? message : "<null>", null));
                break;
            }
        }
        if (ConsoleLogLevel.isLevelEnoughToLog(ConsoleLogLevel.kind2Level(msgKind), this.getConsoleLogLevel())) {
            if (PlatformUI.isWorkbenchRunning()) {
                this.getConsoleIO().print(this.getConsoleMessageFor(msgKind, message));
            } else {
                this.getFallbackMessagingSystem().log(msgKind, message, messageGroup);
            }
        }
    }

    public void log(MessagingSystem.Kind msgKind, String message, String messageGroup, Throwable throwable) {
        switch (msgKind) {
            case DevWARNING: {
                if (messageGroup != null && messageGroup.isEmpty()) break;
                Activator.getDefault().getLog().log((IStatus)new Status(2, messageGroup, 2, message != null ? message : "<null>", throwable));
                break;
            }
            case DevERROR: {
                if (messageGroup != null && messageGroup.isEmpty()) break;
                Activator.getDefault().getLog().log((IStatus)new Status(4, messageGroup, 4, message != null ? message : "<null>", throwable));
                break;
            }
        }
        if (ConsoleLogLevel.isLevelEnoughToLog(ConsoleLogLevel.kind2Level(msgKind), this.getConsoleLogLevel())) {
            String stackTrace = "";
            if (throwable != null) {
                StringWriter sw = new StringWriter();
                throwable.printStackTrace(new PrintWriter(sw));
                stackTrace = "\n" + sw.toString();
            }
            if (PlatformUI.isWorkbenchRunning()) {
                this.getConsoleIO().print(this.getConsoleMessageFor(msgKind, String.valueOf(message) + stackTrace));
            } else {
                this.getFallbackMessagingSystem().log(msgKind, String.valueOf(message) + stackTrace, messageGroup);
            }
        }
    }

    public void logProblem(MessagingSystem.Kind kind, String msg, String msgGroup, Reference ref) {
        switch (kind) {
            case UserWARNING: {
                this.eclipseReporter.addMarker(1, ref, msg, msgGroup);
                break;
            }
            case UserERROR: {
                this.eclipseReporter.addMarker(2, ref, msg, msgGroup);
                break;
            }
            default: {
                this.eclipseReporter.addMarker(0, ref, msg, msgGroup);
            }
        }
    }

    public void logProblem(MessagingSystem.Kind kind, String msg, String msgGroup, Throwable exception, Reference ref) {
        switch (kind) {
            case UserWARNING: {
                this.eclipseReporter.addMarker(1, ref, msg, msgGroup);
                break;
            }
            case UserERROR: {
                this.eclipseReporter.addMarker(2, ref, msg, msgGroup);
                break;
            }
            default: {
                this.eclipseReporter.addMarker(0, ref, msg, msgGroup);
            }
        }
    }

    public void progress(String progressGroup, String msg, String msgGroup, int workedUnit) {
        boolean mustLog = false;
        IProgressMonitor progressMonitor = this.getProgressMonitor(progressGroup);
        if (progressMonitor != null) {
            progressMonitor.subTask(msg);
            progressMonitor.worked(workedUnit * this.progressBarScale);
        } else {
            mustLog = true;
        }
        MessagingSystem.Kind logLevel = mustLog ? MessagingSystem.Kind.UserINFO : MessagingSystem.Kind.DevINFO;
        this.log(logLevel, "[" + progressGroup + "]" + msg + this.getIntermediateElapsedTime(progressGroup), msgGroup);
    }

    public void flushAllProblems(URL uri) {
        this.eclipseReporter.flushAllProblems(uri);
    }

    public void flushProblem(String messageGroup, URL uri) {
        this.eclipseReporter.flushProblem(messageGroup, uri);
    }

    protected ConsoleMessage getConsoleMessageFor(MessagingSystem.Kind msgKind, String message) {
        switch (msgKind) {
            case DevDEBUG: {
                return new DebugMessage(String.valueOf(message) + "\n");
            }
            case UserINFO: {
                return new InfoMessage(String.valueOf(message) + "\n");
            }
            case UserImportantINFO: {
                return new ImportantMessage(String.valueOf(message) + "\n");
            }
            case DevINFO: {
                return new DebugMessage(String.valueOf(message) + "\n");
            }
            case UserWARNING: {
                return new WarningMessage(String.valueOf(message) + "\n");
            }
            case DevWARNING: {
                return new DebugWarningMessage(String.valueOf(message) + "\n");
            }
            case UserERROR: {
                return new ErrorMessage(String.valueOf(message) + "\n");
            }
            case DevERROR: {
                return new DebugErrorMessage(String.valueOf(message) + "\n");
            }
        }
        return new DebugMessage(String.valueOf(message) + "\n");
    }

    public String readLine() {
        return this.getConsoleIO().read();
    }

    public String readLine(String prompt) {
        this.info(prompt, "");
        Thread.yield();
        return this.readLine();
    }

    public BufferedReader getReader() {
        return this.getConsoleIO().getReader();
    }

    public int getProgressBarMaxDepth() {
        return this.progressBarMaxDepth;
    }

    public void setProgressBarMaxDepth(int progressBarMaxDepth) {
        this.progressBarMaxDepth = progressBarMaxDepth;
    }

    public void showConsole() {
        if (this.getConsoleIO() instanceof EclipseConsoleIO) {
            ((EclipseConsoleIO)this.getConsoleIO()).showConsole();
        }
    }

    public void focus() {
        this.showConsole();
    }

    protected MessagingSystem getFallbackMessagingSystem() {
        if (this.fallbackMessagingSystem == null) {
            this.fallbackMessagingSystem = new StdioSimpleMessagingSystem();
        }
        return this.fallbackMessagingSystem;
    }
}

