/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.gef.ui.internal.editparts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.editparts.ZoomListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.internal.figures.AnimationModel;
import org.eclipse.gmf.runtime.gef.ui.internal.editparts.AnimatedZoomListener;

public class AnimatableZoomManager
extends ZoomManager {
    private int zoomAnimationStyle = 0;
    private List animationListeners = new ArrayList();
    private static final int DURATION_INCREMENT = 400;

    public int getZoomAnimationStyle() {
        return this.zoomAnimationStyle;
    }

    public AnimatableZoomManager(ScalableFigure pane, Viewport viewport) {
        super(pane, viewport);
    }

    public void setZoomAnimationStyle(int style) {
        this.zoomAnimationStyle = style;
    }

    public void addZoomListener(ZoomListener listener) {
        super.addZoomListener(listener);
        if (listener instanceof AnimatedZoomListener) {
            this.animationListeners.add(listener);
        }
    }

    protected void fireAnimatedZoomStarted() {
        Iterator iter = this.animationListeners.iterator();
        while (iter.hasNext()) {
            ((AnimatedZoomListener)iter.next()).animatedZoomStarted();
        }
    }

    protected void fireAnimatedZoomEnded() {
        Iterator iter = this.animationListeners.iterator();
        while (iter.hasNext()) {
            ((AnimatedZoomListener)iter.next()).animatedZoomEnded();
        }
    }

    public void zoomTo(double zoom, Point center) {
        Point centerRel = center.getCopy();
        this.getScalableFigure().translateToRelative((Translatable)centerRel);
        this.primSetZoom(zoom, centerRel);
    }

    public void zoomTo(Rectangle rect) {
        Dimension available = this.getViewport().getClientArea().getSize();
        Dimension desired = rect.getSize();
        double scaleX = (double)available.width * this.getZoom() / (double)desired.width;
        double scaleY = (double)available.height * this.getZoom() / (double)desired.height;
        double zoom = Math.min(this.getMaxZoom(), Math.max(this.getMinZoom(), Math.min(scaleX, scaleY)));
        this.zoomTo(zoom, rect.getCenter());
    }

    protected void primSetZoom(double zoom) {
        Point center = this.getViewport().getClientArea().getCenter();
        this.primSetZoom(zoom, center);
    }

    private AnimationModel calculateAnimationModel(double zoom) {
        double dmod = Math.pow(zoom / this.getZoom(), 0.125);
        int steps = (int)Math.round(dmod > 1.0 ? dmod : 1.0 / dmod);
        int duration = Math.max(400, steps * 400);
        AnimationModel animationModel = new AnimationModel((long)duration, true);
        animationModel.animationStarted();
        return animationModel;
    }

    private void primSetZoom(double zoom, Point finalCenterAbs) {
        this.primAnimateSetZoom(zoom, finalCenterAbs, this.getZoomAnimationStyle() == 1 ? this.calculateAnimationModel(zoom) : null);
    }

    private void primAnimateSetZoom(double zoom, Point finalCenter, AnimationModel animationModel) {
        double initialZoom = this.getZoom();
        double finalZoom = zoom;
        Point finalCenterRel = finalCenter.getCopy();
        Point originalViewLocation = this.getViewport().getViewLocation();
        Dimension centerDiff = originalViewLocation.getDifference(this.getViewport().getClientArea().getCenter());
        Point finalViewLocation = finalCenterRel.scale(finalZoom / initialZoom).getTranslated(centerDiff);
        LineSeg scrollVector = new LineSeg(originalViewLocation, finalViewLocation);
        float progress = 1.0f;
        if (animationModel != null) {
            animationModel.animationStarted();
            progress = animationModel.getProgress();
        }
        boolean finished = false;
        this.fireAnimatedZoomStarted();
        while (!finished) {
            if (animationModel == null || animationModel.isFinished()) {
                finished = true;
            }
            double currentZoom = initialZoom + (finalZoom - initialZoom) * (double)progress;
            super.primSetZoom(currentZoom);
            Point currentViewLocation = scrollVector.locatePoint((double)progress, 0L, LineSeg.Sign.POSITIVE);
            this.setViewLocation(currentViewLocation);
            this.getViewport().getUpdateManager().performUpdate();
            if (animationModel == null) continue;
            progress = animationModel.getProgress();
        }
        this.fireAnimatedZoomEnded();
    }
}

