/*******************************************************************************
 * Copyright (c) 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Inria - initial API and implementation
 *******************************************************************************/
package fr.inria.diverse.melange.processors

import fr.inria.diverse.melange.ast.LanguageExtensions
import fr.inria.diverse.melange.eclipse.EclipseProjectHelper
import fr.inria.diverse.melange.metamodel.melange.Language
import javax.inject.Inject

/**
 * For each {@link Language} in the current Melange file, if its runtime is
 * generated by Melange, set its #ecoreUri to the Ecore file generated in
 * the external project by the compiler.
 */
class EcoreUriInferrer extends DispatchMelangeProcessor
{
	@Inject extension LanguageExtensions
	@Inject extension EclipseProjectHelper

	def dispatch void preProcess(Language l, boolean preLinkingPhase) {
		val project = l.eResource.project

		if (l.isGeneratedByMelange && project !== null)
			if (project.getFile(l.externalEcorePath).exists)
				l.syntax.ecoreUri = l.externalEcoreUri
	}
}
