/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.dialect;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.dialect.DialectServices;
import org.eclipse.sirius.business.api.dialect.RepresentationNotification;
import org.eclipse.sirius.business.api.helper.SiriusUtil;
import org.eclipse.sirius.business.api.helper.task.AbstractCommandTask;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.query.RepresentationDescriptionQuery;
import org.eclipse.sirius.business.api.query.ViewpointQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.internal.query.DRepresentationDescriptorInternalHelper;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.tools.api.command.CommandContext;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.tools.internal.SiriusCopierHelper;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.Messages;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.description.tool.ModelOperation;

public abstract class AbstractRepresentationDialectServices
implements DialectServices {
    protected static final Set<EReference> REPRESENTATION_ELEMENTS_INVERSE_REFERENCES = new HashSet<EReference>();

    static {
        REPRESENTATION_ELEMENTS_INVERSE_REFERENCES.add(ViewpointPackage.eINSTANCE.getDSemanticDecorator_Target());
        REPRESENTATION_ELEMENTS_INVERSE_REFERENCES.add(ViewpointPackage.eINSTANCE.getDRepresentationElement_SemanticElements());
    }

    protected abstract boolean isSupported(DRepresentation var1);

    protected abstract boolean isSupported(DRepresentationDescriptor var1);

    protected abstract boolean isSupported(RepresentationDescription var1);

    @Override
    public void notify(RepresentationNotification notification) {
    }

    @Override
    public void updateRepresentationsExtendedBy(Session session, Viewpoint viewpoint, boolean activated) {
    }

    @Override
    public void refresh(DRepresentation representation, IProgressMonitor monitor) {
        this.refresh(representation, false, monitor);
    }

    @Override
    public void refreshImpactedElements(DRepresentation representation, Collection<Notification> notifications, IProgressMonitor monitor) {
    }

    @Override
    public boolean canRefresh(DRepresentation representation) {
        return this.isSupported(representation) && this.areRequiredViewpointsSelected(representation);
    }

    private boolean areRequiredViewpointsSelected(DRepresentation representation) {
        Set<Viewpoint> requiredViewpoints;
        boolean areRequiredViewpointsSelected = false;
        if (representation != null && !(requiredViewpoints = this.getRequiredViewpoints(representation)).isEmpty()) {
            Session session = new EObjectQuery(representation).getSession();
            if (session == null) {
                EObject target = ((DSemanticDecorator)((Object)representation)).getTarget();
                session = new EObjectQuery(target).getSession();
            }
            if (session != null) {
                areRequiredViewpointsSelected = session.getSelectedViewpoints(false).containsAll(requiredViewpoints);
            }
        }
        return areRequiredViewpointsSelected;
    }

    protected boolean isRelatedViewpointSelected(Session session, RepresentationDescription representationDescription) {
        boolean isRelatedViewpointSelected = false;
        Viewpoint parentViewpoint = new RepresentationDescriptionQuery(representationDescription).getParentViewpoint();
        isRelatedViewpointSelected = session != null && parentViewpoint != null && session.getSelectedViewpoints(false).contains(parentViewpoint);
        return isRelatedViewpointSelected;
    }

    @Override
    public Set<Viewpoint> getRequiredViewpoints(DRepresentation representation) {
        Viewpoint parentViewpoint;
        LinkedHashSet<Viewpoint> requiredViewpoints = new LinkedHashSet<Viewpoint>();
        RepresentationDescription representationDescription = this.getDescription(representation);
        if (representationDescription != null && (parentViewpoint = new RepresentationDescriptionQuery(representationDescription).getParentViewpoint()) != null) {
            requiredViewpoints.add(parentViewpoint);
        }
        return requiredViewpoints;
    }

    @Override
    public DRepresentation copyRepresentation(DRepresentationDescriptor representationDescriptor, String name, Session session, IProgressMonitor monitor) {
        DRepresentation newRepresentation = SiriusCopierHelper.copyWithNoUidDuplication(representationDescriptor.getRepresentation());
        DRepresentationDescriptorInternalHelper.createDRepresentationDescriptor(newRepresentation, (DAnalysisSessionImpl)session, ((DSemanticDecorator)((Object)representationDescriptor.getRepresentation())).getTarget().eResource(), name, representationDescriptor.getDocumentation());
        return newRepresentation;
    }

    @Override
    public boolean deleteRepresentation(DRepresentationDescriptor representationDescriptor, Session session) {
        if (this.isSupported(representationDescriptor)) {
            DRepresentation representation = representationDescriptor.getRepresentation();
            Optional<Resource> resOpt = Optional.ofNullable(representation).map(EObject::eResource);
            EcoreUtil.remove((EObject)representationDescriptor);
            if (representation != null) {
                SiriusUtil.delete(representation, session);
            }
            resOpt.filter(res -> res.getContents().isEmpty()).ifPresent(res -> {
                try {
                    res.delete(Collections.emptyMap());
                }
                catch (IOException e) {
                    SiriusPlugin.getDefault().error(Messages.SiriusUncontrolCommand_resourceDeletionFailedMsg, e);
                }
            });
            return true;
        }
        return false;
    }

    @Override
    public DRepresentation createRepresentation(String name, EObject semantic, RepresentationDescription description, Session session, IProgressMonitor monitor) {
        DRepresentation representation = null;
        try {
            monitor.beginTask(MessageFormat.format(Messages.AbstractRepresentationDialectServices_createRepresentationMsg, name), 2);
            representation = this.createRepresentation(name, semantic, description, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (representation != null) {
                DRepresentationDescriptorInternalHelper.createDRepresentationDescriptor(representation, (DAnalysisSessionImpl)session, semantic.eResource(), name, "");
            }
            monitor.worked(1);
        }
        finally {
            monitor.done();
        }
        return representation;
    }

    protected abstract DRepresentation createRepresentation(String var1, EObject var2, RepresentationDescription var3, IProgressMonitor var4);

    @Override
    public Collection<RepresentationDescription> getAvailableRepresentationDescriptions(Collection<Viewpoint> vps, EObject semantic) {
        ArrayList<RepresentationDescription> result = new ArrayList<RepresentationDescription>();
        for (Viewpoint vp : vps) {
            Iterables.addAll(result, this.getAvailableRepresentationDescriptions(vp, semantic));
        }
        return result;
    }

    protected Iterable<RepresentationDescription> getAvailableRepresentationDescriptions(Viewpoint vp, final EObject semantic) {
        Iterable<RepresentationDescription> candidates = new ViewpointQuery(vp).getAllRepresentationDescriptions();
        return Iterables.filter(candidates, (Predicate)new Predicate<RepresentationDescription>(){

            public boolean apply(RepresentationDescription input) {
                return AbstractRepresentationDialectServices.this.canCreate(semantic, input);
            }
        });
    }

    protected boolean checkPrecondition(EObject semantic, String condition) {
        boolean canCreate;
        if (StringUtil.isEmpty((String)condition)) {
            canCreate = true;
        } else {
            try {
                IInterpreter interpreter = InterpreterUtil.getInterpreter(semantic);
                canCreate = interpreter.evaluateBoolean(semantic, condition);
            }
            catch (EvaluationException evaluationException) {
                canCreate = false;
            }
        }
        return canCreate;
    }

    protected boolean checkDomainClass(ModelAccessor accessor, EObject semantic, String domainClass) {
        return !StringUtil.isEmpty((String)domainClass) && accessor.eInstanceOf(semantic, domainClass);
    }

    protected boolean checkSemanticElementCanBeFilled(ModelAccessor accessor, EObject semantic) {
        return accessor.getPermissionAuthority().canCreateIn(semantic);
    }

    protected void initRepresentations(EObject semantic, Viewpoint vp, Class<? extends RepresentationDescription> representationDescriptionType) {
        this.initRepresentations(semantic, vp, representationDescriptionType, (IProgressMonitor)new NullProgressMonitor());
    }

    protected void initRepresentations(EObject semantic, Viewpoint vp, Class<? extends RepresentationDescription> representationDescriptionType, IProgressMonitor monitor) {
        Collection<? extends RepresentationDescription> descriptions = this.collectRepresentationDescriptions(vp, representationDescriptionType);
        this.initRepresentations(descriptions, semantic, monitor);
    }

    private <T extends RepresentationDescription> Collection<T> collectRepresentationDescriptions(Viewpoint viewpoint, Class<T> expectedRepresentationDescriptionType) {
        ArrayList<RepresentationDescription> descriptions = new ArrayList<RepresentationDescription>();
        for (RepresentationDescription representationDescription : new ViewpointQuery(viewpoint).getAllRepresentationDescriptions()) {
            if (!expectedRepresentationDescriptionType.isAssignableFrom(representationDescription.getClass()) || !representationDescription.isInitialisation()) continue;
            descriptions.add(representationDescription);
        }
        return descriptions;
    }

    private void initRepresentations(Collection<? extends RepresentationDescription> descriptions, EObject rootSemanticElement, IProgressMonitor monitor) {
        if (descriptions.isEmpty()) {
            return;
        }
        try {
            monitor.beginTask(Messages.AbstractRepresentationDialectServices_initRepresentationMsg, descriptions.size());
            for (RepresentationDescription representationDescription : descriptions) {
                this.initRepresentationForElement(representationDescription, rootSemanticElement, monitor);
            }
            TreeIterator treeIterator = rootSemanticElement.eAllContents();
            while (treeIterator.hasNext()) {
                EObject currentSemanticElement = (EObject)treeIterator.next();
                for (RepresentationDescription representationDescription : descriptions) {
                    this.initRepresentationForElement(representationDescription, currentSemanticElement, monitor);
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    protected abstract <T extends RepresentationDescription> void initRepresentationForElement(T var1, EObject var2, IProgressMonitor var3);

    protected boolean shouldInitializeRepresentation(EObject semanticElement, RepresentationDescription description, String domainClass) {
        boolean shouldInitializeRepresentation = !StringUtil.isEmpty((String)domainClass) && description.isInitialisation();
        return shouldInitializeRepresentation;
    }

    @Override
    public void invalidateMappingCache() {
    }

    @Override
    public Option<? extends AbstractCommandTask> createTask(CommandContext context, ModelAccessor extPackage, ModelOperation op, Session session, UICallBack uiCallback) {
        return Options.newNone();
    }

    @Override
    public boolean allowsEStructuralFeatureCustomization(EObject choice) {
        return false;
    }
}

