/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.builders;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.builders.CompilerFlags;
import org.eclipse.pde.internal.core.builders.IncrementalErrorReporter;

public abstract class ErrorReporter {
    protected static final String[] BOOLEAN_VALUES = new String[]{"true", "false"};
    protected final IFile fFile;
    protected IProject fProject;
    private final IncrementalErrorReporter fErrorReporter;

    public ErrorReporter(IFile file) {
        this.fFile = file;
        this.fErrorReporter = new IncrementalErrorReporter((IResource)file);
        this.fProject = file.getProject();
    }

    protected IncrementalErrorReporter.VirtualMarker addMarker(String message, int lineNumber, int severity, int problemID, String category) {
        return this.fErrorReporter.addMarker(message, lineNumber, severity, problemID, category);
    }

    protected IDocument createDocument(IFile file) {
        if (!file.exists()) {
            return null;
        }
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        if (manager == null) {
            return null;
        }
        try {
            manager.connect(file.getFullPath(), LocationKind.NORMALIZE, null);
            ITextFileBuffer textBuf = manager.getTextFileBuffer(file.getFullPath(), LocationKind.NORMALIZE);
            IDocument document = textBuf.getDocument();
            manager.disconnect(file.getFullPath(), LocationKind.NORMALIZE, null);
            return document;
        }
        catch (CoreException e) {
            PDECore.log(e);
            return null;
        }
    }

    public int getErrorCount() {
        return this.fErrorReporter.getErrorCount();
    }

    public IncrementalErrorReporter.VirtualMarker report(String message, int line, int severity, int problemID, String category) {
        if (severity == 0) {
            return this.addMarker(message, line, 2, problemID, category);
        }
        if (severity == 1) {
            return this.addMarker(message, line, 1, problemID, category);
        }
        if (severity == 3) {
            return this.addMarker(message, line, 0, problemID, category);
        }
        return null;
    }

    public IncrementalErrorReporter.VirtualMarker report(String message, int line, int severity, String category) {
        return this.report(message, line, severity, 4135, category);
    }

    protected IncrementalErrorReporter.VirtualMarker report(String message, int line, String compilerFlag, int problemID, String category) {
        int severity = CompilerFlags.getFlag(this.fProject, compilerFlag);
        if (severity != 2) {
            return this.report(message, line, severity, problemID, category);
        }
        return null;
    }

    protected IncrementalErrorReporter.VirtualMarker report(String message, int line, String compilerFlag, String category) {
        return this.report(message, line, compilerFlag, 4135, category);
    }

    public final void validateContent(IProgressMonitor monitor) {
        this.validate(monitor);
        this.fErrorReporter.applyMarkers();
    }

    protected abstract void validate(IProgressMonitor var1);
}

