/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.trace.gemoc.traceaddon;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gemoc.executionframework.debugger.IDynamicPartAccessor;
import org.eclipse.gemoc.executionframework.debugger.MutableField;
import org.eclipse.gemoc.executionframework.engine.core.CommandExecution;
import org.eclipse.gemoc.trace.commons.model.generictrace.BooleanAttributeValue;
import org.eclipse.gemoc.trace.commons.model.generictrace.DoubleAttributeValue;
import org.eclipse.gemoc.trace.commons.model.generictrace.DoubleObjectAttributeValue;
import org.eclipse.gemoc.trace.commons.model.generictrace.GenericAttributeValue;
import org.eclipse.gemoc.trace.commons.model.generictrace.GenericDimension;
import org.eclipse.gemoc.trace.commons.model.generictrace.GenericState;
import org.eclipse.gemoc.trace.commons.model.generictrace.GenericTracedObject;
import org.eclipse.gemoc.trace.commons.model.generictrace.IntegerAttributeValue;
import org.eclipse.gemoc.trace.commons.model.generictrace.IntegerObjectAttributeValue;
import org.eclipse.gemoc.trace.commons.model.generictrace.LongAttributeValue;
import org.eclipse.gemoc.trace.commons.model.generictrace.LongObjectAttributeValue;
import org.eclipse.gemoc.trace.commons.model.generictrace.ManyReferenceValue;
import org.eclipse.gemoc.trace.commons.model.generictrace.SingleReferenceValue;
import org.eclipse.gemoc.trace.commons.model.generictrace.StringAttributeValue;
import org.eclipse.gemoc.trace.commons.model.trace.State;
import org.eclipse.gemoc.trace.commons.model.trace.TracedObject;
import org.eclipse.gemoc.trace.gemoc.Activator;
import org.eclipse.gemoc.trace.gemoc.api.IStateManager;

public class GenericStateManager
implements IStateManager<State<?, ?>> {
    private final Resource modelResource;
    private final Map<TracedObject<?>, EObject> tracedToExe;
    IDynamicPartAccessor dynamicPartAccessor;

    public GenericStateManager(Resource modelResource, Map<TracedObject<?>, EObject> tracedToExe, IDynamicPartAccessor dynamicPartAccessor) {
        this.modelResource = modelResource;
        this.tracedToExe = tracedToExe;
        this.dynamicPartAccessor = dynamicPartAccessor;
    }

    public void restoreState(final State<?, ?> state) {
        if (this.modelResource != null && state instanceof GenericState) {
            TransactionalEditingDomain ed = TransactionUtil.getEditingDomain((Resource)this.modelResource);
            if (ed != null) {
                RecordingCommand command = new RecordingCommand(ed, ""){

                    protected void doExecute() {
                        GenericStateManager.this.restoreStateExecute((GenericState)state);
                    }
                };
                CommandExecution.execute((TransactionalEditingDomain)ed, (RecordingCommand)command);
            }
        }
    }

    public void restoreStateExecute(GenericState state) {
        state.getValues().forEach(v -> {
            GenericDimension dimension = (GenericDimension)v.eContainer();
            GenericTracedObject tracedObject = (GenericTracedObject)dimension.eContainer();
            EObject originalObject = tracedObject.getOriginalObject();
            List fields = this.dynamicPartAccessor.extractMutableField(originalObject);
            Optional<MutableField> dynamicProperty = fields.stream().filter(field -> field.getMutableProperty().getName().equals(dimension.getDynamicProperty().getName())).findFirst();
            if (originalObject == null) {
                originalObject = this.tracedToExe.get(tracedObject);
            }
            if (dynamicProperty.isPresent()) {
                if (v instanceof GenericAttributeValue) {
                    if (v instanceof IntegerAttributeValue) {
                        dynamicProperty.get().setValue((Object)((IntegerAttributeValue)v).getAttributeValue());
                    } else if (v instanceof BooleanAttributeValue) {
                        dynamicProperty.get().setValue((Object)((BooleanAttributeValue)v).isAttributeValue());
                    } else if (v instanceof StringAttributeValue) {
                        dynamicProperty.get().setValue((Object)((StringAttributeValue)v).getAttributeValue());
                    } else if (v instanceof DoubleAttributeValue) {
                        dynamicProperty.get().setValue((Object)((DoubleAttributeValue)v).getAttributeValue());
                    } else if (v instanceof LongAttributeValue) {
                        dynamicProperty.get().setValue((Object)((LongAttributeValue)v).getAttributeValue());
                    } else if (v instanceof IntegerObjectAttributeValue) {
                        dynamicProperty.get().setValue((Object)((IntegerObjectAttributeValue)v).getAttributeValue());
                    } else if (v instanceof DoubleObjectAttributeValue) {
                        dynamicProperty.get().setValue((Object)((DoubleObjectAttributeValue)v).getAttributeValue());
                    } else if (v instanceof LongObjectAttributeValue) {
                        dynamicProperty.get().setValue((Object)((LongObjectAttributeValue)v).getAttributeValue());
                    } else {
                        Activator.error("eType " + v.eClass().getName() + " not supported yet (used by " + v.eContainingFeature().getName() + " of " + v.eContainingFeature().eContainer() + ");\n " + "Please use another type in your RTD or consider to contribute to GEMOC framework", new UnsupportedOperationException("eType " + v.eClass().getName() + " not supported yet (used by " + v.eContainingFeature().getName() + " of " + v.eContainingFeature().eContainer() + ")"));
                    }
                } else if (v instanceof SingleReferenceValue) {
                    EObject refVal2 = ((SingleReferenceValue)v).getReferenceValue();
                    if (refVal2 instanceof GenericTracedObject) {
                        EObject exe = this.tracedToExe.get(refVal2);
                        dynamicProperty.get().setValue((Object)exe);
                    } else {
                        dynamicProperty.get().setValue((Object)refVal2);
                    }
                } else {
                    BasicEList values = new BasicEList();
                    values.addAll(((ManyReferenceValue)v).getReferenceValues().stream().map(refVal -> {
                        if (refVal instanceof GenericTracedObject) {
                            return this.tracedToExe.get(refVal);
                        }
                        return refVal;
                    }).collect(Collectors.toList()));
                    dynamicProperty.get().setValue((Object)values);
                }
            }
        });
    }
}

