/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.helper.task.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.internal.helper.task.operations.AbstractOperationTask;
import org.eclipse.sirius.business.internal.helper.task.operations.InterpretedExpressionVariableTask;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.RefreshIdsHolder;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.ArrangeConstraint;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.Messages;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManager;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManagerRegistry;
import org.eclipse.sirius.diagram.business.api.helper.display.DisplayMode;
import org.eclipse.sirius.diagram.business.api.helper.display.DisplayService;
import org.eclipse.sirius.diagram.business.api.helper.display.DisplayServiceManager;
import org.eclipse.sirius.diagram.business.api.helper.graphicalfilters.HideFilterHelper;
import org.eclipse.sirius.diagram.business.api.query.DDiagramQuery;
import org.eclipse.sirius.diagram.business.api.query.DiagramElementMappingQuery;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.business.internal.helper.decoration.DecorationHelperInternal;
import org.eclipse.sirius.diagram.business.internal.metamodel.description.operations.AbstractNodeMappingSpecOperations;
import org.eclipse.sirius.diagram.business.internal.sync.DDiagramElementSynchronizer;
import org.eclipse.sirius.diagram.business.internal.sync.DDiagramSynchronizer;
import org.eclipse.sirius.diagram.business.internal.sync.DEdgeCandidate;
import org.eclipse.sirius.diagram.business.internal.sync.DNodeCandidate;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.MappingBasedDecoration;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.tool.CreateEdgeView;
import org.eclipse.sirius.diagram.description.tool.CreateView;
import org.eclipse.sirius.diagram.description.tool.ToolPackage;
import org.eclipse.sirius.diagram.tools.api.preferences.SiriusDiagramPreferencesKeys;
import org.eclipse.sirius.diagram.tools.api.refresh.BestMappingGetter;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.FeatureNotFoundException;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.MetaClassNotFoundException;
import org.eclipse.sirius.tools.api.command.CommandContext;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.SemanticBasedDecoration;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;

public class CreateViewTask
extends AbstractOperationTask {
    private final CreateView createViewOp;

    public CreateViewTask(CommandContext context, ModelAccessor extPackage, CreateView createViewOp, IInterpreter interpreter) {
        super(context, extPackage, interpreter);
        this.createViewOp = createViewOp;
    }

    public String getLabel() {
        return Messages.CreateViewTask_label;
    }

    public void execute() throws MetaClassNotFoundException, FeatureNotFoundException {
        Session session;
        DSemanticDecorator containerView = this.evaluateContainerViewExpression();
        DSemanticDiagram parentDDiagram = this.getDSemanticDiagram(containerView);
        DDiagramElement createView = this.createView(parentDDiagram, containerView, session = new EObjectQuery((EObject)parentDDiagram).getSession());
        if (createView != null) {
            this.initCreatedViewVariable(createView);
            this.setInitialVisibility(parentDDiagram, createView);
        }
    }

    private DSemanticDecorator evaluateContainerViewExpression() {
        DSemanticDecorator containerView = null;
        EObject evaluation = this.evalueExpression(ToolPackage.eINSTANCE.getCreateView_ContainerViewExpression());
        if (evaluation instanceof DSemanticDecorator) {
            containerView = (DSemanticDecorator)evaluation;
        }
        return containerView;
    }

    private EObject evalueExpression(EAttribute expressionEAttribute) {
        EObject evaluation = RuntimeLoggerManager.INSTANCE.decorate(this.interpreter).evaluateEObject(this.context.getCurrentTarget(), (EObject)this.createViewOp, (EStructuralFeature)expressionEAttribute);
        return evaluation;
    }

    private DSemanticDiagram getDSemanticDiagram(DSemanticDecorator containerView) {
        DSemanticDiagram dSemanticDiagram = null;
        if (containerView instanceof DSemanticDiagram) {
            dSemanticDiagram = (DSemanticDiagram)containerView;
        } else if (containerView instanceof DDiagramElement) {
            dSemanticDiagram = (DSemanticDiagram)((DDiagramElement)containerView).getParentDiagram();
        }
        return dSemanticDiagram;
    }

    private DDiagramElement createView(DSemanticDiagram parentDDiagram, DSemanticDecorator containerView, Session session) {
        DDiagramElement createdView = null;
        EObject semanticElt = this.context.getCurrentTarget();
        if (this.createViewOp instanceof CreateEdgeView) {
            CreateEdgeView createEdgeView = (CreateEdgeView)this.createViewOp;
            createdView = this.createEdgeView(parentDDiagram, createEdgeView, session);
        } else if (containerView != null) {
            AbstractNodeMapping abstractNodeMapping;
            BestMappingGetter bestMappingGetter = new BestMappingGetter(containerView, semanticElt);
            DiagramElementMapping bestMapping = this.createViewOp.getMapping();
            if (bestMapping instanceof NodeMapping) {
                bestMapping = bestMappingGetter.getBestNodeMapping(Collections.singletonList((NodeMapping)this.createViewOp.getMapping()));
            } else if (bestMapping instanceof ContainerMapping) {
                bestMapping = bestMappingGetter.getBestContainerMapping(Collections.singletonList((ContainerMapping)this.createViewOp.getMapping()));
            }
            if (bestMapping == null) {
                bestMapping = this.createViewOp.getMapping();
            }
            if (bestMapping instanceof AbstractNodeMapping && this.extPackage.eInstanceOf(semanticElt, (abstractNodeMapping = (AbstractNodeMapping)bestMapping).getDomainClass())) {
                DNodeCandidate abstractDNodeCandidate = new DNodeCandidate(abstractNodeMapping, semanticElt, (DragAndDropTarget)containerView, RefreshIdsHolder.getOrCreateHolder((EObject)parentDDiagram));
                DDiagramElementSynchronizer dDiagramElementSynchronizer = new DDiagramElementSynchronizer(parentDDiagram, this.interpreter, this.extPackage);
                DiagramMappingsManager mappingManager = DiagramMappingsManagerRegistry.INSTANCE.getDiagramMappingsManager(session, parentDDiagram);
                AbstractDNode createdAbstractDNode = dDiagramElementSynchronizer.createNewNode(mappingManager, abstractDNodeCandidate, abstractNodeMapping.eContainingFeature() == DescriptionPackage.Literals.ABSTRACT_NODE_MAPPING__BORDERED_NODE_MAPPINGS);
                AbstractNodeMappingSpecOperations.createBorderingNodes(abstractNodeMapping, semanticElt, createdAbstractDNode, Collections.emptyList(), parentDDiagram);
                createdView = createdAbstractDNode;
                if (this.isAutoPinOnCreateEnabled()) {
                    createdAbstractDNode.getArrangeConstraints().add((Object)ArrangeConstraint.KEEP_LOCATION);
                    createdAbstractDNode.getArrangeConstraints().add((Object)ArrangeConstraint.KEEP_RATIO);
                    createdAbstractDNode.getArrangeConstraints().add((Object)ArrangeConstraint.KEEP_SIZE);
                }
            }
        }
        return createdView;
    }

    private void initCreatedViewVariable(DDiagramElement createView) throws MetaClassNotFoundException, FeatureNotFoundException {
        if (!StringUtil.isEmpty((String)this.createViewOp.getVariableName())) {
            InterpretedExpressionVariableTask childTask = new InterpretedExpressionVariableTask(this.context, this.extPackage, 0, this.createViewOp.getVariableName(), (Object)createView, this.interpreter);
            childTask.execute();
        }
    }

    private void setInitialVisibility(DDiagram diagram, DDiagramElement diagramElement) {
        DisplayService service = DisplayServiceManager.INSTANCE.getDisplayService(DisplayMode.CREATION);
        if (service != null && diagramElement != null && diagram != null) {
            Session session = SessionManager.INSTANCE.getSession(diagramElement.getTarget());
            DiagramMappingsManager mappingManager = DiagramMappingsManagerRegistry.INSTANCE.getDiagramMappingsManager(session, diagram);
            diagramElement.setVisible(service.computeVisibility(mappingManager, diagram, diagramElement));
            if (!service.computeLabelVisibility(diagram, diagramElement)) {
                HideFilterHelper.INSTANCE.hideLabel(diagramElement);
            }
        }
    }

    private DEdge createEdgeView(DSemanticDiagram parentDDiagram, CreateEdgeView createEdgeView, Session session) {
        EObject target;
        DEdge createdDEdge = null;
        DDiagramSynchronizer dDiagramSynchronizer = new DDiagramSynchronizer(this.interpreter, parentDDiagram.getDescription(), this.extPackage);
        dDiagramSynchronizer.setDiagram(parentDDiagram);
        dDiagramSynchronizer.setTool(true);
        DDiagramElementSynchronizer dDiagramElementSynchronizer = dDiagramSynchronizer.getElementSynchronizer();
        HashMap<EdgeMapping, Collection<MappingBasedDecoration>> edgeToMappingBasedDecoration = new HashMap<EdgeMapping, Collection<MappingBasedDecoration>>();
        HashMap<String, Collection<SemanticBasedDecoration>> edgeToSemanticBasedDecoration = new HashMap<String, Collection<SemanticBasedDecoration>>();
        Map<DiagramElementMapping, Collection<EdgeTarget>> mappingsToEdgeTargets = dDiagramElementSynchronizer.computeMappingsToEdgeTargets(session.getSelectedViewpoints(false));
        new DecorationHelperInternal(parentDDiagram, this.interpreter, this.extPackage).computeDecorations(mappingsToEdgeTargets, edgeToSemanticBasedDecoration, edgeToMappingBasedDecoration);
        EObject source = this.evalueExpression(ToolPackage.eINSTANCE.getCreateEdgeView_SourceExpression());
        if (source == null) {
            source = this.context.getCurrentTarget();
        }
        if ((target = this.evalueExpression(ToolPackage.eINSTANCE.getCreateEdgeView_TargetExpression())) == null) {
            target = this.context.getCurrentTarget();
        }
        AbstractToolDescription tool = this.getAbstractToolDescription();
        EdgeMapping bestEdgeMapping = (EdgeMapping)createEdgeView.getMapping();
        boolean needsPathUpdate = this.needsPathUpdate(bestEdgeMapping, tool);
        DiagramMappingsManager diagramMappingsManager = DiagramMappingsManagerRegistry.INSTANCE.getDiagramMappingsManager(session, parentDDiagram);
        Collection<DiagramElementMapping> sourceMappingAndTheirMappingImports = this.getAbstractNodeMappingImports(diagramMappingsManager, (Collection<DiagramElementMapping>)bestEdgeMapping.getSourceMapping());
        sourceMappingAndTheirMappingImports.addAll((Collection<DiagramElementMapping>)bestEdgeMapping.getSourceMapping());
        Collection<DiagramElementMapping> targetMappingAndTheirMappingImports = this.getAbstractNodeMappingImports(diagramMappingsManager, (Collection<DiagramElementMapping>)bestEdgeMapping.getTargetMapping());
        targetMappingAndTheirMappingImports.addAll((Collection<DiagramElementMapping>)bestEdgeMapping.getTargetMapping());
        Collection<DDiagramElement> sourceViews = this.getNodes(source, parentDDiagram, sourceMappingAndTheirMappingImports);
        Collection<DDiagramElement> targetViews = this.getNodes(target, parentDDiagram, targetMappingAndTheirMappingImports);
        for (DDiagramElement sourceView : sourceViews) {
            if (!(sourceView instanceof EdgeTarget)) continue;
            EdgeTarget sourceEdgeTarget = (EdgeTarget)((Object)sourceView);
            for (DDiagramElement targetView : targetViews) {
                if (!(targetView instanceof EdgeTarget)) continue;
                EdgeTarget targetEdgeTarget = (EdgeTarget)((Object)targetView);
                BestMappingGetter bestMappingGetter = new BestMappingGetter(sourceEdgeTarget, targetEdgeTarget, this.context.getCurrentTarget());
                EdgeMapping edgeMapping = bestMappingGetter.getBestEdgeMapping(Collections.singletonList((EdgeMapping)this.createViewOp.getMapping()));
                if (edgeMapping == null && createEdgeView.getMapping() instanceof EdgeMapping) {
                    edgeMapping = (EdgeMapping)createEdgeView.getMapping();
                }
                DEdgeCandidate dEdgeCandidate = new DEdgeCandidate(edgeMapping, this.context.getCurrentTarget(), sourceEdgeTarget, targetEdgeTarget, RefreshIdsHolder.getOrCreateHolder((EObject)parentDDiagram));
                DiagramMappingsManager mappingManager = DiagramMappingsManagerRegistry.INSTANCE.getDiagramMappingsManager(session, parentDDiagram);
                createdDEdge = dDiagramElementSynchronizer.createNewEdge(mappingManager, dEdgeCandidate, mappingsToEdgeTargets, edgeToMappingBasedDecoration, edgeToSemanticBasedDecoration);
                if (!needsPathUpdate) continue;
                dDiagramElementSynchronizer.updatePath(createdDEdge, edgeMapping, mappingsToEdgeTargets);
            }
        }
        return createdDEdge;
    }

    private Collection<DiagramElementMapping> getAbstractNodeMappingImports(DiagramMappingsManager diagramMappingsManager, Collection<DiagramElementMapping> mappings) {
        ArrayList<DiagramElementMapping> mappingImports = new ArrayList<DiagramElementMapping>();
        block0: for (DiagramElementMapping mapping : mappings) {
            ArrayList<NodeMapping> allAbstractNodeMappings = new ArrayList<NodeMapping>(diagramMappingsManager.getNodeMappings());
            allAbstractNodeMappings.addAll(diagramMappingsManager.getContainerMappings());
            for (DiagramElementMapping diagramElementMapping : allAbstractNodeMappings) {
                if (!new DiagramElementMappingQuery(diagramElementMapping).areInSameHiearchy(mapping)) continue;
                mappingImports.add(diagramElementMapping);
                continue block0;
            }
        }
        return mappingImports;
    }

    private boolean needsPathUpdate(EdgeMapping edgeMapping, AbstractToolDescription tool) {
        if (edgeMapping != null && tool != null) {
            return !tool.isForceRefresh() && edgeMapping.getPathExpression() != null && !StringUtil.isEmpty((String)edgeMapping.getPathExpression()) && edgeMapping.getPathNodeMapping() != null;
        }
        return false;
    }

    private AbstractToolDescription getAbstractToolDescription() {
        if (this.createViewOp != null) {
            CreateView tmp = this.createViewOp;
            while (tmp.eContainer() != null) {
                if (tmp instanceof AbstractToolDescription) {
                    return (AbstractToolDescription)tmp;
                }
                tmp = tmp.eContainer();
            }
        }
        return null;
    }

    private Collection<DDiagramElement> getNodes(EObject semanticElement, DSemanticDiagram dSemanticDiagram, Collection<DiagramElementMapping> mappings) {
        HashSet<DDiagramElement> result = new HashSet<DDiagramElement>();
        if (semanticElement != null) {
            for (DDiagramElement dDiagramElement : new DDiagramQuery(dSemanticDiagram).getAllDiagramElements()) {
                if (!mappings.contains(dDiagramElement.getMapping()) || !semanticElement.equals(dDiagramElement.getTarget())) continue;
                result.add(dDiagramElement);
            }
        }
        return result;
    }

    private boolean isAutoPinOnCreateEnabled() {
        return Platform.getPreferencesService().getBoolean("org.eclipse.sirius.diagram", SiriusDiagramPreferencesKeys.PREF_AUTO_PIN_ON_CREATE.name(), false, null);
    }
}

