/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.metamodel.helper;

import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.ContainerMappingHelper;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.EdgeMappingImport;
import org.eclipse.sirius.diagram.description.IEdgeMapping;
import org.eclipse.sirius.diagram.description.NodeMapping;

public final class MappingHelper {
    private MappingHelper() {
    }

    public static EList<DiagramElementMapping> getAllMappings(DiagramElementMapping mapping) {
        BasicEList.UnmodifiableEList diagramElementMappings = new BasicEList();
        if (mapping instanceof ContainerMapping) {
            diagramElementMappings = ContainerMappingHelper.getAllMappings((ContainerMapping)mapping);
        } else if (mapping instanceof EdgeMappingImport) {
            EdgeMapping edgeMapping = MappingHelper.getEdgeMapping((EdgeMappingImport)((Object)mapping));
            if (edgeMapping != null) {
                diagramElementMappings = MappingHelper.getAllMappings(edgeMapping);
            }
        } else if (mapping instanceof NodeMapping) {
            BasicEList allMappings = new BasicEList();
            allMappings.addAll(MappingHelper.getAllBorderedNodeMappings((NodeMapping)mapping));
            diagramElementMappings = new BasicEList.UnmodifiableEList(allMappings.size(), allMappings.toArray());
        } else {
            diagramElementMappings = new BasicEList.UnmodifiableEList(0, new Object[0]);
        }
        return diagramElementMappings;
    }

    public static EList<NodeMapping> getAllBorderedNodeMappings(AbstractNodeMapping nodeMapping) {
        BasicEList result = new BasicEList();
        result.addAll(nodeMapping.getBorderedNodeMappings());
        result.addAll(nodeMapping.getReusedBorderedNodeMappings());
        return result;
    }

    public static EList<NodeMapping> getAllNodeMappings(ContainerMapping containerMapping) {
        Collection<NodeMapping> result = ContainerMappingHelper.getAllNodeMappings(containerMapping);
        return new BasicEList.UnmodifiableEList(result.size(), result.toArray());
    }

    public static EList<ContainerMapping> getAllContainerMappings(ContainerMapping containerMapping) {
        Collection<ContainerMapping> result = ContainerMappingHelper.getAllContainerMappings(containerMapping);
        return new BasicEList.UnmodifiableEList(result.size(), result.toArray());
    }

    public static EdgeMapping getEdgeMapping(EdgeMappingImport edgeMappingImport) {
        EdgeMapping result = null;
        IEdgeMapping iEdgeMapping = edgeMappingImport.getImportedMapping();
        if (iEdgeMapping instanceof EdgeMapping) {
            result = (EdgeMapping)iEdgeMapping;
        } else if (iEdgeMapping instanceof EdgeMappingImport) {
            result = MappingHelper.getEdgeMapping((EdgeMappingImport)iEdgeMapping);
        }
        return result;
    }
}

