/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionImpl;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DiagramPlugin;
import org.eclipse.sirius.diagram.tools.api.management.ToolFilter;
import org.eclipse.sirius.diagram.tools.api.management.ToolManagement;
import org.eclipse.sirius.diagram.tools.internal.management.UpdateToolRecordingCommand;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.palette.PaletteManager;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.DDiagramEditorImpl;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.LockStatus;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.ui.business.api.descriptor.ComposedImageDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;

public class DDiagramEditorSessionListenerDelegate
implements Runnable {
    private static final ImageDescriptor LOCK_BY_ME_IMAGE_DESCRIPTOR = SiriusEditPlugin.Implementation.getBundledImageDescriptor((String)"icons/full/decorator/permission_granted_to_current_user_exclusively.gif");
    private static final ImageDescriptor LOCK_BY_OTHER_IMAGE_DESCRIPTOR = SiriusEditPlugin.Implementation.getBundledImageDescriptor((String)"icons/full/decorator/permission_denied.gif");
    private static final ImageDescriptor NO_WRITE_PERMISSION_IMAGE_DESCRIPTOR = SiriusEditPlugin.Implementation.getBundledImageDescriptor((String)"icons/full/decorator/permission_no_write.gif");
    private static final List<Integer> UNMANAGED_EVENTS = Arrays.asList(8, 9, 7, 6, 10, 11);
    private DDiagramEditorImpl dDiagramEditorImpl;
    private Image initialTitleImage;
    private Image lockByMeImage;
    private Image lockByOtherImage;
    private Image frozenRepresentationImage;
    private ToolFilter toolFilterWhenRepresentationIsLocked;
    private int changeKind;
    private Image noWritePermissionImage;

    public DDiagramEditorSessionListenerDelegate(DDiagramEditorImpl dDiagramEditorImpl, ToolFilter toolFilterWhenRepresentationIsLocked, int changeKind) {
        this.dDiagramEditorImpl = dDiagramEditorImpl;
        this.toolFilterWhenRepresentationIsLocked = toolFilterWhenRepresentationIsLocked;
        this.changeKind = changeKind;
    }

    @Override
    public void run() {
        if (UNMANAGED_EVENTS.contains(this.changeKind)) {
            return;
        }
        Diagram gmfDiagram = this.dDiagramEditorImpl.getDiagram();
        if (gmfDiagram == null || gmfDiagram.getElement() instanceof DSemanticDecorator && SessionManager.INSTANCE.getSession(((DSemanticDecorator)gmfDiagram.getElement()).getTarget()) == null) {
            return;
        }
        PaletteManager paletteManager = this.dDiagramEditorImpl.getPaletteManager();
        ToolManagement toolManagement = DiagramPlugin.getPlugin().getToolManagement(gmfDiagram);
        switch (this.changeKind) {
            case 2: 
            case 3: {
                this.dDiagramEditorImpl.firePropertyChangeInUIThread(257);
                break;
            }
            case 1: {
                this.dDiagramEditorImpl.firePropertyChangeInUIThread(1);
                break;
            }
            case 0: {
                this.reloadPalette(paletteManager, gmfDiagram, false);
                break;
            }
            case 16: {
                this.reloadPalette(paletteManager, gmfDiagram, true);
                break;
            }
            case 4: {
                if (this.dDiagramEditorImpl.getDiagramGraphicalViewer().getContents() == null) break;
                this.dDiagramEditorImpl.getDiagramGraphicalViewer().getContents().deactivate();
                break;
            }
            case 5: {
                if (this.dDiagramEditorImpl.getDocumentProvider() == null) break;
                IEditorInput input = this.dDiagramEditorImpl.getEditorInput();
                this.dDiagramEditorImpl.setInput(input);
                this.reloadPalette(paletteManager, this.dDiagramEditorImpl.getDiagram(), false);
                break;
            }
            case 13: {
                if (paletteManager != null && toolManagement != null) {
                    toolManagement.removeToolFilter(this.toolFilterWhenRepresentationIsLocked);
                    if (this.dDiagramEditorImpl.getTabbar() != null) {
                        this.dDiagramEditorImpl.getTabbar().reinitToolBar(this.dDiagramEditorImpl.getDiagramGraphicalViewer().getSelection());
                    }
                }
                this.updateTitleImage(this.getInitialImage());
                IPermissionAuthority permissionAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority((EObject)this.dDiagramEditorImpl.getRepresentation());
                if (permissionAuthority == null || permissionAuthority.canEditInstance((EObject)this.dDiagramEditorImpl.getRepresentation())) {
                    this.updateTitleImage(this.getInitialImage());
                } else {
                    this.updateTitleImage(this.getNoWritePermissionImage());
                }
                this.reloadPalette(paletteManager, gmfDiagram, false);
                break;
            }
            case 12: {
                if (paletteManager != null && toolManagement != null) {
                    toolManagement.removeToolFilter(this.toolFilterWhenRepresentationIsLocked);
                    if (this.dDiagramEditorImpl.getTabbar() != null) {
                        this.dDiagramEditorImpl.getTabbar().reinitToolBar(this.dDiagramEditorImpl.getDiagramGraphicalViewer().getSelection());
                    }
                }
                this.updateTitleImage(this.getLockByMeImage());
                IPermissionAuthority permissionAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority((EObject)this.dDiagramEditorImpl.getRepresentation());
                if (permissionAuthority == null || permissionAuthority.canEditInstance((EObject)this.dDiagramEditorImpl.getRepresentation())) {
                    this.updateTitleImage(this.getLockByMeImage());
                }
                this.reloadPalette(paletteManager, gmfDiagram, false);
                break;
            }
            case 14: {
                if (paletteManager != null && toolManagement != null) {
                    toolManagement.addToolFilter(this.toolFilterWhenRepresentationIsLocked);
                    if (this.dDiagramEditorImpl.getTabbar() != null) {
                        this.dDiagramEditorImpl.getTabbar().reinitToolBar(this.dDiagramEditorImpl.getDiagramGraphicalViewer().getSelection());
                    }
                }
                this.updateTitleImage(this.getLockByOtherImage());
                IPermissionAuthority permissionAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority((EObject)this.dDiagramEditorImpl.getRepresentation());
                if (permissionAuthority == null || LockStatus.LOCKED_BY_OTHER.equals((Object)permissionAuthority.getLockStatus((EObject)this.dDiagramEditorImpl.getRepresentation()))) {
                    this.updateTitleImage(this.getLockByOtherImage());
                } else {
                    this.updateTitleImage(this.getNoWritePermissionImage());
                }
                this.reloadPalette(paletteManager, gmfDiagram, false);
                break;
            }
            case 15: {
                if (paletteManager != null) {
                    toolManagement.addToolFilter(this.toolFilterWhenRepresentationIsLocked);
                    this.reloadPalette(paletteManager, gmfDiagram, false);
                    if (this.dDiagramEditorImpl.getTabbar() != null) {
                        this.dDiagramEditorImpl.getTabbar().reinitToolBar(this.dDiagramEditorImpl.getDiagramGraphicalViewer().getSelection());
                    }
                }
                this.updateTitleImage(this.getFrozenRepresentationImage());
                break;
            }
        }
    }

    private void updateTitleImage(Image newTitleImage) {
        if (newTitleImage != null && !newTitleImage.equals((Object)this.dDiagramEditorImpl.getTitleImage())) {
            this.dDiagramEditorImpl.setTitleImage(newTitleImage);
        }
    }

    private void reloadPalette(PaletteManager paletteManager, Diagram gmfDiagram, boolean clean) {
        TransactionalEditingDomain editingDomain = this.dDiagramEditorImpl.getEditingDomain();
        if (editingDomain != null && gmfDiagram != null && gmfDiagram.getElement() instanceof DDiagram) {
            TransactionImpl t = new TransactionImpl(editingDomain, false, Collections.EMPTY_MAP);
            try {
                t.start();
                UpdateToolRecordingCommand updateToolRecordingCommand = new UpdateToolRecordingCommand(editingDomain, (DDiagram)gmfDiagram.getElement(), true);
                if (updateToolRecordingCommand.canExecute()) {
                    updateToolRecordingCommand.execute();
                }
                t.commit();
                ToolManagement toolManagement = DiagramPlugin.getDefault().getToolManagement(gmfDiagram);
                if (toolManagement != null) {
                    if (clean) {
                        toolManagement.notifyToolChangeAfterVSMReload();
                    } else {
                        toolManagement.notifyToolChange();
                    }
                }
            }
            catch (InterruptedException | RollbackException e) {
                DiagramPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.sirius.diagram", Messages.DDiagramEditorImpl_updateToolFailure, e));
            }
        }
    }

    private Image getInitialImage() {
        IEditorRegistry editorRegistry;
        IEditorDescriptor editorDesc;
        if ((this.initialTitleImage == null || this.initialTitleImage.isDisposed()) && (editorDesc = (editorRegistry = PlatformUI.getWorkbench().getEditorRegistry()).findEditor(this.dDiagramEditorImpl.getSite().getId())) != null) {
            this.initialTitleImage = DiagramUIPlugin.getPlugin().getImage(editorDesc.getImageDescriptor());
        }
        return this.initialTitleImage;
    }

    private Image getLockByMeImage() {
        if (this.lockByMeImage == null || this.lockByMeImage.isDisposed()) {
            this.lockByMeImage = DiagramUIPlugin.getPlugin().getImage(LOCK_BY_ME_IMAGE_DESCRIPTOR);
        }
        return this.lockByMeImage;
    }

    private Image getLockByOtherImage() {
        if (this.lockByOtherImage == null || this.lockByOtherImage.isDisposed()) {
            this.lockByOtherImage = DiagramUIPlugin.getPlugin().getImage(LOCK_BY_OTHER_IMAGE_DESCRIPTOR);
        }
        return this.lockByOtherImage;
    }

    private Image getFrozenRepresentationImage() {
        if (this.frozenRepresentationImage == null || this.frozenRepresentationImage.isDisposed()) {
            Image refreshImage = DiagramUIPlugin.getPlugin().getImage(DiagramUIPlugin.Implementation.getBundledImageDescriptor("images/refresh.gif"));
            ArrayList<Image> images = new ArrayList<Image>(2);
            images.add(refreshImage);
            Image lockByOtherOverlayImage = SiriusEditPlugin.getPlugin().getImage(SiriusEditPlugin.Implementation.getBundledImageDescriptor((String)"icons/full/decorator/permission_denied_overlay.gif"));
            images.add(lockByOtherOverlayImage);
            ComposedImageDescriptor composedImageDescriptor = new ComposedImageDescriptor(new ComposedImage(images));
            this.frozenRepresentationImage = DiagramUIPlugin.getPlugin().getImage((ImageDescriptor)composedImageDescriptor);
        }
        return this.frozenRepresentationImage;
    }

    private Image getNoWritePermissionImage() {
        if (this.noWritePermissionImage == null || this.noWritePermissionImage.isDisposed()) {
            this.noWritePermissionImage = DiagramUIPlugin.getPlugin().getImage(NO_WRITE_PERMISSION_IMAGE_DESCRIPTOR);
        }
        return this.noWritePermissionImage;
    }
}

