/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.event.manager;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gemoc.executionframework.event.manager.IMetalanguageRuleExecutor;
import org.eclipse.gemoc.executionframework.event.manager.SimpleCallRequest;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionEngine;

public class IntegrationFacade {
    private final Map<String, IMetalanguageRuleExecutor> metalanguageIntegrations = new HashMap<String, IMetalanguageRuleExecutor>();
    private final IExecutionEngine<?> executionEngine;

    public IntegrationFacade(IExecutionEngine<?> executionEngine) {
        this.executionEngine = executionEngine;
    }

    public void handleCallRequest(SimpleCallRequest callRequest) throws IllegalArgumentException {
        IMetalanguageRuleExecutor ruleExecutor = this.metalanguageIntegrations.computeIfAbsent(callRequest.getMetalanguage(), m -> this.findMetalanguageRuleExecutor((String)m));
        if (ruleExecutor == null) {
            throw new IllegalArgumentException("No metalanguage rule executor was found for metalanguage " + callRequest.getMetalanguage());
        }
        ruleExecutor.handleCallRequest(callRequest);
    }

    private IMetalanguageRuleExecutor findMetalanguageRuleExecutor(String metalanguage) {
        return Arrays.asList(Platform.getExtensionRegistry().getExtension(metalanguage).getConfigurationElements()).stream().findFirst().map(c -> {
            IMetalanguageRuleExecutor result = null;
            try {
                result = (IMetalanguageRuleExecutor)c.createExecutableExtension("class");
                result.setExecutionEngine(this.executionEngine);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            return result;
        }).orElse(null);
    }
}

