/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.views.dependencies;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.views.dependencies.DependenciesView;
import org.eclipse.pde.internal.ui.views.dependencies.HistoryListDialog;
import org.eclipse.ui.PlatformUI;

public class HistoryListAction
extends Action {
    private DependenciesView fView;

    public HistoryListAction(DependenciesView view) {
        this.fView = view;
        this.setText(PDEUIMessages.HistoryListAction_label);
        this.setImageDescriptor(PDEPluginImages.DESC_HISTORY_LIST);
        this.setDisabledImageDescriptor(PDEPluginImages.DESC_HISTORY_LIST_DISABLED);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.pde.doc.user.history_list_action");
    }

    public void run() {
        String[] historyEntries = this.fView.getHistoryEntries();
        HistoryListDialog dialog = new HistoryListDialog(PDEPlugin.getActiveWorkbenchShell(), historyEntries);
        if (dialog.open() == 0) {
            this.fView.setHistoryEntries(dialog.getRemaining());
            String id = dialog.getResult();
            if (id == null) {
                this.fView.openTo(null);
            } else {
                this.fView.openTo(PluginRegistry.findModel((String)id));
            }
        }
    }
}

