/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.runtime.simulation;

import fr.inria.aoste.timesquare.ccslkernel.runtime.AbstractRuntimeModel;
import fr.inria.aoste.timesquare.ccslkernel.runtime.elements.RuntimeClock;
import fr.inria.aoste.timesquare.ccslkernel.runtime.exceptions.SimulationException;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.BDDHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.relations.AbstractRuntimeRelation;
import fr.inria.aoste.timesquare.ccslkernel.runtime.simulation.AbstractStepExecutionEngine;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractCCSLSimulationEngine {
    protected AbstractRuntimeModel model;
    protected HashMap<RuntimeClock, Integer> clockToIndexInSolution;
    protected HashMap<Integer, Integer> bddVarToIndexInSolution;
    protected HashMap<Integer, AbstractRuntimeRelation> bddAssertVarToRelation;
    protected ArrayList<AbstractRuntimeRelation> assertions;
    protected HashMap<AbstractRuntimeRelation, Integer> assertionsToIndexInSolution;
    private int solutionIndexCounter = 0;
    private Set<RuntimeClock> deadClocks = new HashSet<RuntimeClock>();

    public AbstractCCSLSimulationEngine() {
        this.init();
    }

    public AbstractCCSLSimulationEngine(AbstractRuntimeModel model) {
        this.model = model;
        this.init();
    }

    private void init() {
        this.bddAssertVarToRelation = new HashMap();
        this.assertions = new ArrayList();
        this.assertionsToIndexInSolution = new HashMap();
        this.clockToIndexInSolution = new HashMap();
        this.bddVarToIndexInSolution = new HashMap();
        this.initializeBDDIndexes();
        this.initializeAssertions();
    }

    protected int newSolutionIndexNumber() {
        int res = this.solutionIndexCounter++;
        return res;
    }

    protected void initializeBDDIndexes() {
        List<RuntimeClock> allClocks = this.getAllDiscreteClocks();
        for (RuntimeClock clock : allClocks) {
            Integer recordedIndex = this.bddVarToIndexInSolution.get(clock.bddVariableNumber);
            int index = recordedIndex != null ? recordedIndex.intValue() : this.newSolutionIndexNumber();
            this.clockToIndexInSolution.put(clock, index);
            this.bddVarToIndexInSolution.put(clock.bddVariableNumber, index);
        }
    }

    protected abstract List<RuntimeClock> getAllDiscreteClocks();

    protected void initializeAssertions() {
        for (AbstractRuntimeRelation assertion : this.getAllAssertions()) {
            assertion.setAssertionVariable(BDDHelper.newBDDVariableNumber());
            this.bddAssertVarToRelation.put(assertion.getAssertionVariable(), assertion);
            int index = this.newSolutionIndexNumber();
            this.assertionsToIndexInSolution.put(assertion, index);
            this.bddVarToIndexInSolution.put(assertion.getAssertionVariable(), index);
        }
    }

    protected abstract List<AbstractRuntimeRelation> getAllAssertions();

    public abstract void initSimulation() throws SimulationException;

    public abstract void endSimulation() throws SimulationException;

    public AbstractRuntimeModel getModel() {
        return this.model;
    }

    public abstract AbstractStepExecutionEngine createStepExecutionEngine();

    public HashMap<Integer, Integer> getBddVarToIndexInSolution() {
        return this.bddVarToIndexInSolution;
    }

    public Integer getIndexInSolution(RuntimeClock clock) {
        return this.bddVarToIndexInSolution.get(clock);
    }

    public Integer getIndexInSolution(AbstractRuntimeRelation assertion) {
        if (!assertion.isAssertion()) {
            return null;
        }
        return this.assertionsToIndexInSolution.get(assertion);
    }

    public Set<RuntimeClock> getDeadClocks() {
        return this.deadClocks;
    }

    public void addDeadClock(RuntimeClock clock) {
        this.deadClocks.add(clock);
    }
}

