/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.execution;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.runner.Description;
import org.junit.vintage.engine.descriptor.RunnerTestDescriptor;
import org.junit.vintage.engine.descriptor.VintageTestDescriptor;
import org.junit.vintage.engine.execution.EventType;
import org.opentest4j.MultipleFailuresError;

class TestRun {
    private final RunnerTestDescriptor runnerTestDescriptor;
    private final Set<TestDescriptor> runnerDescendants;
    private final Map<Description, VintageDescriptors> descriptionToDescriptors;
    private final Map<TestDescriptor, List<TestExecutionResult>> executionResults = new LinkedHashMap<TestDescriptor, List<TestExecutionResult>>();
    private final Set<TestDescriptor> skippedDescriptors = new LinkedHashSet<TestDescriptor>();
    private final Set<TestDescriptor> startedDescriptors = new HashSet<TestDescriptor>();
    private final Map<TestDescriptor, EventType> inProgressDescriptors = new LinkedHashMap<TestDescriptor, EventType>();
    private final Set<TestDescriptor> finishedDescriptors = new LinkedHashSet<TestDescriptor>();
    private final ThreadLocal<Deque<VintageTestDescriptor>> inProgressDescriptorsByStartingThread = ThreadLocal.withInitial(ArrayDeque::new);

    TestRun(RunnerTestDescriptor runnerTestDescriptor) {
        this.runnerTestDescriptor = runnerTestDescriptor;
        this.runnerDescendants = new LinkedHashSet<TestDescriptor>(runnerTestDescriptor.getDescendants());
        this.descriptionToDescriptors = Stream.concat(Stream.of(runnerTestDescriptor), this.runnerDescendants.stream()).map(VintageTestDescriptor.class::cast).collect(Collectors.toMap(VintageTestDescriptor::getDescription, VintageDescriptors::new, VintageDescriptors::merge, HashMap::new));
    }

    void registerDynamicTest(VintageTestDescriptor testDescriptor) {
        this.descriptionToDescriptors.computeIfAbsent(testDescriptor.getDescription(), __ -> new VintageDescriptors()).add(testDescriptor);
        this.runnerDescendants.add((TestDescriptor)testDescriptor);
    }

    RunnerTestDescriptor getRunnerTestDescriptor() {
        return this.runnerTestDescriptor;
    }

    Collection<TestDescriptor> getInProgressTestDescriptorsWithSyntheticStartEvents() {
        List result = this.inProgressDescriptors.entrySet().stream().filter(entry -> ((EventType)((Object)((Object)entry.getValue()))).equals((Object)EventType.SYNTHETIC)).map(Map.Entry::getKey).collect(Collectors.toCollection(ArrayList::new));
        Collections.reverse(result);
        return result;
    }

    boolean isDescendantOfRunnerTestDescriptor(TestDescriptor testDescriptor) {
        return this.runnerDescendants.contains(testDescriptor);
    }

    Optional<VintageTestDescriptor> lookupNextTestDescriptor(Description description) {
        return this.lookupUnambiguouslyOrApplyFallback(description, VintageDescriptors::getNextUnstarted);
    }

    Optional<VintageTestDescriptor> lookupCurrentTestDescriptor(Description description) {
        return this.lookupUnambiguouslyOrApplyFallback(description, __ -> {
            VintageTestDescriptor lastStarted = this.inProgressDescriptorsByStartingThread.get().peekLast();
            if (lastStarted != null && description.equals((Object)lastStarted.getDescription())) {
                return Optional.of(lastStarted);
            }
            return Optional.empty();
        });
    }

    private Optional<VintageTestDescriptor> lookupUnambiguouslyOrApplyFallback(Description description, Function<VintageDescriptors, Optional<VintageTestDescriptor>> fallback) {
        VintageDescriptors vintageDescriptors = this.descriptionToDescriptors.getOrDefault(description, VintageDescriptors.NONE);
        Optional<VintageTestDescriptor> result = vintageDescriptors.getUnambiguously(description);
        if (!result.isPresent()) {
            result = fallback.apply(vintageDescriptors);
        }
        return result;
    }

    void markSkipped(TestDescriptor testDescriptor) {
        this.skippedDescriptors.add(testDescriptor);
        if (testDescriptor instanceof VintageTestDescriptor) {
            VintageTestDescriptor vintageDescriptor = (VintageTestDescriptor)testDescriptor;
            this.descriptionToDescriptors.get(vintageDescriptor.getDescription()).incrementSkippedOrStarted();
        }
    }

    boolean isNotSkipped(TestDescriptor testDescriptor) {
        return !this.isSkipped(testDescriptor);
    }

    boolean isSkipped(TestDescriptor testDescriptor) {
        return this.skippedDescriptors.contains(testDescriptor);
    }

    void markStarted(TestDescriptor testDescriptor, EventType eventType) {
        this.inProgressDescriptors.put(testDescriptor, eventType);
        this.startedDescriptors.add(testDescriptor);
        if (testDescriptor instanceof VintageTestDescriptor) {
            VintageTestDescriptor vintageDescriptor = (VintageTestDescriptor)testDescriptor;
            this.inProgressDescriptorsByStartingThread.get().addLast(vintageDescriptor);
            this.descriptionToDescriptors.get(vintageDescriptor.getDescription()).incrementSkippedOrStarted();
        }
    }

    boolean isNotStarted(TestDescriptor testDescriptor) {
        return !this.startedDescriptors.contains(testDescriptor);
    }

    void markFinished(TestDescriptor testDescriptor) {
        this.inProgressDescriptors.remove(testDescriptor);
        this.finishedDescriptors.add(testDescriptor);
        if (testDescriptor instanceof VintageTestDescriptor) {
            VintageTestDescriptor descriptor = (VintageTestDescriptor)testDescriptor;
            this.inProgressDescriptorsByStartingThread.get().removeLastOccurrence((Object)descriptor);
        }
    }

    boolean isNotFinished(TestDescriptor testDescriptor) {
        return !this.isFinished(testDescriptor);
    }

    boolean isFinished(TestDescriptor testDescriptor) {
        return this.finishedDescriptors.contains(testDescriptor);
    }

    boolean areAllFinishedOrSkipped(Set<? extends TestDescriptor> testDescriptors) {
        return testDescriptors.stream().allMatch(this::isFinishedOrSkipped);
    }

    boolean isFinishedOrSkipped(TestDescriptor testDescriptor) {
        return this.isFinished(testDescriptor) || this.isSkipped(testDescriptor);
    }

    void storeResult(TestDescriptor testDescriptor, TestExecutionResult result) {
        List testExecutionResults = this.executionResults.computeIfAbsent(testDescriptor, key -> new ArrayList());
        testExecutionResults.add(result);
    }

    TestExecutionResult getStoredResultOrSuccessful(TestDescriptor testDescriptor) {
        List<TestExecutionResult> testExecutionResults = this.executionResults.get(testDescriptor);
        if (testExecutionResults == null) {
            return TestExecutionResult.successful();
        }
        if (testExecutionResults.size() == 1) {
            return testExecutionResults.get(0);
        }
        List<Throwable> failures = testExecutionResults.stream().map(TestExecutionResult::getThrowable).map(Optional::get).collect(Collectors.toList());
        MultipleFailuresError multipleFailuresError = new MultipleFailuresError("", failures);
        failures.forEach(arg_0 -> multipleFailuresError.addSuppressed(arg_0));
        return TestExecutionResult.failed((Throwable)multipleFailuresError);
    }

    private static class VintageDescriptors {
        private static final VintageDescriptors NONE = new VintageDescriptors(Collections.emptyList());
        private final List<VintageTestDescriptor> descriptors;
        private int skippedOrStartedCount;

        static VintageDescriptors merge(VintageDescriptors a, VintageDescriptors b) {
            ArrayList<VintageTestDescriptor> mergedDescriptors = new ArrayList<VintageTestDescriptor>(a.descriptors.size() + b.descriptors.size());
            mergedDescriptors.addAll(a.descriptors);
            mergedDescriptors.addAll(b.descriptors);
            return new VintageDescriptors(mergedDescriptors);
        }

        VintageDescriptors(VintageTestDescriptor vintageTestDescriptor) {
            this();
            this.add(vintageTestDescriptor);
        }

        VintageDescriptors() {
            this(new ArrayList<VintageTestDescriptor>(1));
        }

        VintageDescriptors(List<VintageTestDescriptor> descriptors) {
            this.descriptors = descriptors;
        }

        void add(VintageTestDescriptor descriptor) {
            this.descriptors.add(descriptor);
        }

        Optional<VintageTestDescriptor> getUnambiguously(Description description) {
            if (this.descriptors.isEmpty()) {
                return Optional.empty();
            }
            if (this.descriptors.size() == 1) {
                return Optional.of(this.descriptors.get(0));
            }
            return this.descriptors.stream().filter(testDescriptor -> description == testDescriptor.getDescription()).findFirst();
        }

        public void incrementSkippedOrStarted() {
            ++this.skippedOrStartedCount;
        }

        public Optional<VintageTestDescriptor> getNextUnstarted() {
            if (this.skippedOrStartedCount < this.descriptors.size()) {
                return Optional.of(this.descriptors.get(this.skippedOrStartedCount));
            }
            return Optional.empty();
        }
    }
}

