/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser.markerImpl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.contribution.visualiser.core.Stripe;
import org.eclipse.contribution.visualiser.interfaces.IGroup;
import org.eclipse.contribution.visualiser.interfaces.IMarkupKind;
import org.eclipse.contribution.visualiser.interfaces.IMember;
import org.eclipse.contribution.visualiser.markerImpl.ResourceMember;
import org.eclipse.contribution.visualiser.simpleImpl.SimpleMarkupKind;
import org.eclipse.contribution.visualiser.simpleImpl.SimpleMarkupProvider;
import org.eclipse.contribution.visualiser.utils.JDTUtils;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class MarkerMarkupProvider
extends SimpleMarkupProvider {
    Map namesToKinds = new HashMap();
    List images = new ArrayList();
    static /* synthetic */ Class class$0;

    protected void updateMarkups(List groups) {
        this.namesToKinds = new HashMap();
        this.resetColours();
        this.resetMarkupsAndKinds();
        if (groups != null) {
            Iterator iter = groups.iterator();
            while (iter.hasNext()) {
                IGroup group = (IGroup)iter.next();
                Iterator iter2 = group.getMembers().iterator();
                while (iter2.hasNext()) {
                    IMember member = (IMember)iter2.next();
                    if (!(member instanceof ResourceMember)) continue;
                    IResource res = ((ResourceMember)member).getResource();
                    try {
                        IMarker[] markers = res.findMarkers(null, true, 2);
                        int i = 0;
                        while (i < markers.length) {
                            IMarker marker = markers[i];
                            Integer lineNum = (Integer)marker.getAttribute("lineNumber");
                            if (lineNum != null) {
                                IMarkupKind kind;
                                int lineNumber = lineNum;
                                String name = this.getLabel(marker);
                                if (name == null) {
                                    name = marker.getType();
                                }
                                if (this.namesToKinds.get(name) instanceof IMarkupKind) {
                                    kind = (IMarkupKind)this.namesToKinds.get(name);
                                } else {
                                    Image image = this.getImage(marker);
                                    this.images.add(image);
                                    kind = new SimpleMarkupKind(name, image);
                                    this.namesToKinds.put(name, kind);
                                    this.addMarkupKind(kind);
                                    Color color = this.getColor(marker);
                                    if (color != null) {
                                        this.setColorFor(kind, color);
                                    }
                                }
                                boolean stripeOnLineAlready = false;
                                List stripes = this.getMemberMarkups(member);
                                if (stripes != null) {
                                    Iterator iter3 = stripes.iterator();
                                    while (iter3.hasNext()) {
                                        Stripe stripe = (Stripe)iter3.next();
                                        if (stripe.getOffset() != lineNumber) continue;
                                        List<Object> kindList = Arrays.asList(kind);
                                        stripe.addKinds(kindList);
                                        stripeOnLineAlready = true;
                                    }
                                }
                                if (!stripeOnLineAlready) {
                                    StripeWithMarker stripe = new StripeWithMarker(kind, lineNumber, marker);
                                    this.addMarkup(member.getFullname(), stripe);
                                }
                            }
                            ++i;
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private Image getImage(IMarker marker) {
        AnnotationPreferenceLookup lookup;
        AnnotationPreference preference;
        ImageDescriptor descriptor;
        IWorkbenchAdapter adapter;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (IWorkbenchAdapter)marker.getAdapter((Class)clazz)) != null && (descriptor = adapter.getImageDescriptor((Object)marker)) != null) {
            return descriptor.createImage();
        }
        MarkerAnnotation annotation = new MarkerAnnotation(marker);
        if (annotation != null && (preference = (lookup = EditorsPlugin.getDefault().getAnnotationPreferenceLookup()).getAnnotationPreference((Annotation)annotation)) != null) {
            ImageDescriptor id = preference.getImageDescriptor();
            if (id != null) {
                return id.createImage();
            }
            if (preference.getSymbolicImageName().equals("bookmark")) {
                return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_BKMRK_TSK").createImage();
            }
        }
        return null;
    }

    private String getLabel(IMarker marker) {
        String id;
        AnnotationPreferenceLookup lookup;
        AnnotationPreference preference;
        MarkerAnnotation annotation = new MarkerAnnotation(marker);
        if (annotation != null && (preference = (lookup = EditorsPlugin.getDefault().getAnnotationPreferenceLookup()).getAnnotationPreference((Annotation)annotation)) != null && (id = preference.getPreferenceLabel()) != null && !id.trim().equals("")) {
            return id;
        }
        return null;
    }

    private Color getColor(IMarker marker) {
        RGB rgb;
        AnnotationPreferenceLookup lookup;
        AnnotationPreference preference;
        MarkerAnnotation annotation = new MarkerAnnotation(marker);
        if (annotation != null && (preference = (lookup = EditorsPlugin.getDefault().getAnnotationPreferenceLookup()).getAnnotationPreference((Annotation)annotation)) != null && (rgb = preference.getColorPreferenceValue()) != null) {
            return new Color(null, rgb);
        }
        return null;
    }

    public boolean processMouseclick(IMember member, Stripe stripe, int buttonClicked) {
        IMarker marker;
        if (stripe instanceof StripeWithMarker && (marker = ((StripeWithMarker)stripe).getMarker()) != null) {
            JDTUtils.openInEditor(marker);
        }
        return false;
    }

    public void deactivate() {
        super.deactivate();
        Iterator iter = this.images.iterator();
        while (iter.hasNext()) {
            Image element = (Image)iter.next();
            if (element != null && !element.isDisposed()) {
                element.dispose();
            }
            iter.remove();
        }
        this.namesToKinds = new HashMap();
        this.resetMarkupsAndKinds();
    }

    public class StripeWithMarker
    extends Stripe {
        IMarker marker;

        public StripeWithMarker(IMarkupKind k, int i, IMarker marker) {
            super(k, i);
            this.marker = marker;
        }

        public IMarker getMarker() {
            return this.marker;
        }
    }
}

