/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.utils.ui.idialog;

import fr.inria.aoste.timesquare.utils.pluginhelpers.PluginHelpers;
import fr.inria.aoste.timesquare.utils.ui.widgets.ElementList;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class BasedDialog<T>
extends Dialog {
    protected String possibleText = "Choose Element";
    protected String selectedText = "Selected Element(s)";
    protected String title = "Windows";
    private Button addButton;
    private Button removeButton;
    private Button upButton;
    private Button downButton;
    protected Table tableSource;
    protected Table tableSelect;
    protected MyTableViewer<T> tvselect;
    protected MyTableViewer<T> tvsource;
    protected LabelProvider labelProvider;
    private DecoratedContentProposalProvider decoratedContentProposalProvider;
    protected ElementList<T> elselect = new ElementList();
    protected ElementList<T> elsource = new ElementList();
    protected Label labelSource;
    protected Label labelSelect;
    private static final Image IMG_UP = PluginHelpers.getImage((String)"fr.inria.aoste.timesquare.utils.ui", (String)"icons/ArrowUp.gif");
    private static final Image IMG_DOWN = PluginHelpers.getImage((String)"fr.inria.aoste.timesquare.utils.ui", (String)"icons/ArrowDown.gif");
    private static final Image IMG_LEFT = PluginHelpers.getImage((String)"fr.inria.aoste.timesquare.utils.ui", (String)"icons/ArrowLeft.gif");
    private static final Image IMG_RIGHT = PluginHelpers.getImage((String)"fr.inria.aoste.timesquare.utils.ui", (String)"icons/ArrowRight.gif");
    protected Object value = null;
    BasedDialog<T> ob = this;
    private boolean updown = true;

    public BasedDialog(Shell parentShell, String possibleTextin, String selectedTextin, String titlein) {
        super(parentShell);
        this.setShellStyle(0x10 | super.getShellStyle());
        this.title = titlein;
        if (possibleTextin != null) {
            this.possibleText = possibleTextin;
        }
        if (selectedTextin != null) {
            this.selectedText = selectedTextin;
        }
        this.decoratedContentProposalProvider = new DecoratedContentProposalProvider();
        this.labelProvider = new LabelProvider();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setMinimumSize(300, 250);
        this.getShell().setText(this.title);
        Composite comp = (Composite)super.createDialogArea(parent);
        comp.setLayout((Layout)new FormLayout());
        this.createElements(comp);
        this.setLayoutData();
        this.setTableViewers();
        return comp;
    }

    protected final void setUpdown(boolean updownin) {
        this.updown = updownin;
    }

    private void setTableViewers() {
        this.tvsource = new MyTableViewer(this.tableSource);
        this.tvselect = new MyTableViewer(this.tableSelect);
        this.tvsource.setInput(this.elsource);
        this.tvselect.setInput(this.elselect);
        this.tableSource.addMouseListener((MouseListener)new AddRemoveItemListener(this.tvsource, this.tvselect));
        this.tableSelect.addMouseListener((MouseListener)new AddRemoveItemListener(this.tvselect, this.tvsource));
        this.addButton.addMouseListener((MouseListener)new AddRemoveButtonListener(this.tvsource, this.tvselect));
        this.removeButton.addMouseListener((MouseListener)new AddRemoveButtonListener(this.tvselect, this.tvsource));
        if (this.updown) {
            this.upButton.addMouseListener((MouseListener)new UpButtonListener());
            this.downButton.addMouseListener((MouseListener)new DownButtonListener());
        }
    }

    private void createElements(Composite comp) {
        this.addButton = new Button(comp, 0x1000000);
        this.addButton.setImage(IMG_RIGHT);
        this.removeButton = new Button(comp, 0x1000000);
        this.removeButton.setImage(IMG_LEFT);
        if (this.updown) {
            this.upButton = new Button(comp, 0x1000000);
            this.upButton.setImage(IMG_UP);
            this.downButton = new Button(comp, 0x1000000);
            this.downButton.setImage(IMG_DOWN);
        }
        this.labelSource = new Label(comp, 0x1000000);
        this.labelSource.setText(this.possibleText);
        this.labelSelect = new Label(comp, 0x1000000);
        this.labelSelect.setText(this.selectedText);
        this.tableSource = new Table(comp, 2562);
        this.tableSelect = new Table(comp, 2562);
    }

    private void setLayoutData() {
        FormData data = new FormData();
        data.top = new FormAttachment(0, 4);
        data.left = new FormAttachment(0, 5);
        this.labelSource.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(40, 0);
        data.right = new FormAttachment(50, -2);
        this.addButton.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.addButton, 4, 1024);
        data.right = new FormAttachment(50, -2);
        this.removeButton.setLayoutData((Object)data);
        data = new FormData();
        data.height = 200;
        data.width = 300;
        data.top = new FormAttachment((Control)this.labelSource, 4);
        data.left = new FormAttachment(0, 5);
        data.bottom = new FormAttachment(100, -4);
        data.right = new FormAttachment((Control)this.addButton, -5);
        this.tableSource.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment((Control)this.addButton, 5);
        this.labelSelect.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this.addButton, 5);
        data.top = new FormAttachment((Control)this.labelSelect, 4);
        data.right = this.updown ? new FormAttachment((Control)this.upButton, -5) : new FormAttachment(100, -5);
        data.width = 300;
        data.bottom = new FormAttachment(100, -4);
        this.tableSelect.setLayoutData((Object)data);
        if (this.updown) {
            data = new FormData();
            data.top = new FormAttachment(40, 0);
            data.right = new FormAttachment(100, -5);
            this.upButton.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment((Control)this.upButton, 5, 1024);
            data.right = new FormAttachment(100, -5);
            this.downButton.setLayoutData((Object)data);
        }
    }

    public void setFocus() {
        this.tableSource.setFocus();
    }

    public Object getValue() {
        return this.value;
    }

    protected ILabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new LabelProvider();
        }
        return this.labelProvider;
    }

    protected IContentProposalProvider getContentProposalProvider() {
        return this.decoratedContentProposalProvider;
    }

    protected boolean isSelectableElement(String text) {
        return false;
    }

    public ArrayList<T> getSelectedElements() {
        return this.elselect.getElements();
    }

    protected TableItem getItem(MouseEvent event) {
        TableItem[] items = ((Table)event.getSource()).getSelection();
        if (items.length > 0) {
            return items[0];
        }
        return null;
    }

    protected class AddRemoveButtonListener
    implements MouseListener {
        MyTableViewer<T> tvin;
        MyTableViewer<T> tvout;

        public AddRemoveButtonListener(MyTableViewer<T> _tvin, MyTableViewer<T> _tvout) {
            this.tvin = _tvin;
            this.tvout = _tvout;
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
            IStructuredSelection selection = (IStructuredSelection)this.tvin.getSelection();
            for (Object t : selection) {
                this.tvin.removeE(t);
                this.tvout.addE(t);
            }
        }
    }

    protected class AddRemoveItemListener
    implements MouseListener {
        MyTableViewer<T> t1;
        MyTableViewer<T> t2;

        public AddRemoveItemListener(MyTableViewer<T> t1i, MyTableViewer<T> t2i) {
            this.t1 = t1i;
            this.t2 = t2i;
        }

        public void mouseDoubleClick(MouseEvent e) {
            Object o;
            if (BasedDialog.this.getItem(e) == null) {
                return;
            }
            Object element = o = BasedDialog.this.getItem(e).getData();
            this.t1.removeE(element);
            this.t2.addE(element);
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
        }
    }

    public final class DecoratedContentProposalProvider
    implements IContentProposalProvider {
        public IContentProposal[] getProposals(String contents, int position) {
            return new IContentProposal[0];
        }
    }

    protected class DownButtonListener
    implements MouseListener {
        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
            BasedDialog.this.tvselect.downsel();
        }
    }

    class MyTableViewer<T>
    extends TableViewer {
        ElementList<T> el;

        public MyTableViewer(Table table) {
            super(table);
            this.setLabelProvider((IBaseLabelProvider)BasedDialog.this.ob.getLabelProvider());
        }

        public void setInput(ElementList<T> elin) {
            this.el = elin;
            this.setContentProvider((IContentProvider)this.el);
            super.setInput(this.el);
        }

        public void down(T element) {
            this.el.moveElementDown(element);
            this.refresh();
        }

        public void up(T element) {
            this.el.moveElementUp(element);
            this.refresh();
        }

        public void addE(T element) {
            this.el.addElement(element);
            this.refresh();
        }

        public void removeE(T element) {
            this.el.removeElement(element);
            this.refresh();
        }

        protected final ElementList<T> getEl() {
            return this.el;
        }

        public void upsel() {
            IStructuredSelection selection = (IStructuredSelection)this.getSelection();
            for (Object element : selection) {
                this.up(element);
            }
        }

        public void downsel() {
            IStructuredSelection selection = (IStructuredSelection)this.getSelection();
            for (Object element : selection) {
                this.down(element);
            }
        }
    }

    protected class UpButtonListener
    implements MouseListener {
        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
            BasedDialog.this.tvselect.upsel();
        }
    }
}

