/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.utils.ui.widgets;

import fr.inria.aoste.timesquare.utils.ui.listeners.FileExtensionFilter;
import fr.inria.aoste.timesquare.utils.ui.listeners.SelectionFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class FileSelectionControl
implements SelectionListener,
ModifyListener {
    private IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
    private String[] extensions;
    private Group group;
    private Text textField;
    private Button browseButton;
    private IFile value;
    private String titleLabel;

    public FileSelectionControl(Composite parent, String label, String[] extensions) {
        int buttonWidthHint;
        this.extensions = (String[])extensions.clone();
        this.titleLabel = label;
        Font font = parent.getFont();
        this.group = new Group(parent, 0);
        this.group.setText(label);
        this.group.setFont(font);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        this.group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        this.group.setLayoutData((Object)gd);
        this.textField = new Text((Composite)this.group, 2052);
        GridData gd2 = new GridData();
        gd2.horizontalAlignment = 4;
        gd2.grabExcessHorizontalSpace = true;
        this.textField.setLayoutData((Object)gd2);
        this.browseButton = new Button((Composite)this.group, 8);
        this.browseButton.setFont(parent.getFont());
        this.browseButton.setText("Browse...");
        GridData gd1 = new GridData();
        this.browseButton.setLayoutData((Object)gd1);
        PixelConverter converter = new PixelConverter((Control)this.browseButton);
        int buttonWidth = converter.convertHorizontalDLUsToPixels(61);
        gd1.widthHint = buttonWidthHint = Math.max(buttonWidth, this.browseButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        gd1.horizontalAlignment = 4;
        this.textField.addModifyListener((ModifyListener)this);
        this.browseButton.addSelectionListener((SelectionListener)this);
    }

    public void modifyText(ModifyEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        this.handleBrowseButtonSelected();
    }

    private void handleBrowseButtonSelected() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(new Shell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setInput((Object)this.workspaceRoot);
        dialog.setAllowMultiple(false);
        dialog.setDoubleClickSelects(false);
        dialog.setTitle(this.titleLabel);
        dialog.setMessage("message");
        dialog.setInitialSelection((Object)this.value);
        dialog.addFilter((ViewerFilter)new FileExtensionFilter(this.extensions));
        dialog.setValidator((ISelectionStatusValidator)new SelectionFile());
        if (dialog.open() == 1) {
            return;
        }
        Object[] results = dialog.getResult();
        if (results != null && results.length != 0 && results[0] instanceof IFile) {
            this.setSelectedFile((IFile)results[0]);
        }
    }

    private void setSelectedFile(IFile file) {
        if (file == null) {
            this.textField.setText("");
        } else {
            String fileName = file.getFullPath().toOSString();
            this.textField.setText(fileName);
        }
    }

    public void setSelectedFile(String fileName) {
        this.textField.setText(fileName);
    }

    public String getSelectedFile() {
        return this.textField.getText();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }
}

