/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.gexpressions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum GMultiplicationOperator implements Enumerator
{
    MULTIPLICATION(0, "MULTIPLICATION", "*"),
    DIVISION(1, "DIVISION", "/");

    public static final int MULTIPLICATION_VALUE = 0;
    public static final int DIVISION_VALUE = 1;
    private static final GMultiplicationOperator[] VALUES_ARRAY;
    public static final List<GMultiplicationOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new GMultiplicationOperator[]{MULTIPLICATION, DIVISION};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static GMultiplicationOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GMultiplicationOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GMultiplicationOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GMultiplicationOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GMultiplicationOperator get(int value) {
        switch (value) {
            case 0: {
                return MULTIPLICATION;
            }
            case 1: {
                return DIVISION;
            }
        }
        return null;
    }

    private GMultiplicationOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

