/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.interpreter.notapi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.acceleo.query.runtime.AcceleoQueryEvaluationException;
import org.eclipse.acceleo.query.runtime.EvaluationResult;
import org.eclipse.acceleo.query.runtime.IQueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.IQueryEvaluationEngine;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationWrapper;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecoretools.ale.core.interpreter.notapi.RuntimeInstanceHelper;
import org.eclipse.emf.ecoretools.ale.implementation.Attribute;
import org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;

public class DynamicFeatureRegistry {
    private List<ModelUnit> allImplemModels;
    private Map<EClass, EClass> baseToRuntime;
    private Map<EObject, EObject> instanceToRuntime;
    private Map<EObject, EObject> runtimeToInstance;

    public DynamicFeatureRegistry(List<ModelUnit> allImplemModels, List<EClass> domain) {
        this.allImplemModels = allImplemModels;
        this.baseToRuntime = RuntimeInstanceHelper.getBaseToRuntime(allImplemModels, domain);
        this.instanceToRuntime = new HashMap<EObject, EObject>();
        this.runtimeToInstance = new HashMap<EObject, EObject>();
    }

    public Object aqlFeatureAccess(EObject context, String featureName) {
        if (context == null) {
            String message = String.format("Attempt to access feature (%s) on a non ModelObject value (%s).", featureName, "null");
            throw new AcceleoQueryEvaluationException(message);
        }
        EStructuralFeature feature = context.eClass().getEStructuralFeature(featureName);
        if (feature == null) {
            return this.getDynamicFeatureValue(context, featureName);
        }
        return context.eGet(feature);
    }

    private Object getDynamicFeatureValue(EObject instance, String featureName) {
        EStructuralFeature feature;
        EObject extendedInstance = this.getOrCreateRuntimeExtension(instance);
        if (extendedInstance != null && (feature = extendedInstance.eClass().getEStructuralFeature(featureName)) != null) {
            return extendedInstance.eGet(feature);
        }
        String message = String.format("Feature %s not found in EClass %s", featureName, instance.eClass().getName());
        throw new AcceleoQueryEvaluationException(message);
    }

    public void setDynamicFeatureValue(EObject instance, String featureName, Object newValue) {
        EStructuralFeature feature;
        EObject extendedInstance = this.getOrCreateRuntimeExtension(instance);
        if (extendedInstance != null && (feature = extendedInstance.eClass().getEStructuralFeature(featureName)) != null) {
            if (newValue instanceof List) {
                BasicEList newList = new BasicEList((Collection)((List)newValue));
                extendedInstance.eSet(feature, (Object)newList);
            } else {
                extendedInstance.eSet(feature, newValue);
            }
        }
    }

    public void insertDynamicFeatureValue(EObject instance, String featureName, Object inserted) {
        EStructuralFeature feature;
        EObject extendedInstance = this.getOrCreateRuntimeExtension(instance);
        if (extendedInstance != null && (feature = extendedInstance.eClass().getEStructuralFeature(featureName)) != null) {
            Object featureValue = extendedInstance.eGet(feature);
            if (featureValue instanceof Collection) {
                if (inserted instanceof Collection) {
                    ((Collection)featureValue).addAll((Collection)inserted);
                } else {
                    ((Collection)featureValue).add(inserted);
                }
            } else if (featureValue instanceof String) {
                String concat = "" + featureValue + inserted;
                extendedInstance.eSet(feature, (Object)concat);
            } else if (featureValue instanceof Integer && inserted instanceof Number) {
                Integer sum = (Integer)featureValue + ((Number)inserted).intValue();
                instance.eSet(feature, (Object)sum);
            } else if (featureValue instanceof Double && inserted instanceof Number) {
                Double sum = (Double)featureValue + ((Number)inserted).doubleValue();
                instance.eSet(feature, (Object)sum);
            }
        }
    }

    public void removeDynamicFeatureValue(EObject instance, String featureName, Object removed) {
        EStructuralFeature feature;
        EObject extendedInstance = this.getOrCreateRuntimeExtension(instance);
        if (extendedInstance != null && (feature = extendedInstance.eClass().getEStructuralFeature(featureName)) != null) {
            Object featureValue = extendedInstance.eGet(feature);
            if (featureValue instanceof Collection) {
                if (removed instanceof Collection) {
                    ((Collection)featureValue).removeAll((Collection)removed);
                } else {
                    ((Collection)featureValue).remove(removed);
                }
            } else if (featureValue instanceof Integer && removed instanceof Number) {
                Integer substraction = (Integer)featureValue - ((Number)removed).intValue();
                instance.eSet(feature, (Object)substraction);
            } else if (featureValue instanceof Double && removed instanceof Number) {
                Double substraction = (Double)featureValue - ((Number)removed).doubleValue();
                instance.eSet(feature, (Object)substraction);
            }
        }
    }

    public Optional<Attribute> findFeature(EClass type, String featureName) {
        List extendedClasses = this.allImplemModels.stream().flatMap(m -> m.getClassExtensions().stream()).filter(cls -> cls.getBaseClass() != null).filter(cls -> cls.getBaseClass().isSuperTypeOf(type)).collect(Collectors.toList());
        for (ExtendedClass extendedClass : extendedClasses) {
            Optional<Attribute> featureDeclaration = extendedClass.getAttributes().stream().filter(attr -> attr.getFeatureRef().getName().equals(featureName)).findFirst();
            if (!featureDeclaration.isPresent()) continue;
            return featureDeclaration;
        }
        return Optional.empty();
    }

    private Optional<Attribute> findOpposite(Attribute feature) {
        if (feature.getFeatureRef() instanceof EReference) {
            EReference eReference = (EReference)feature.getFeatureRef();
        }
        return Optional.empty();
    }

    private EObject getOrCreateRuntimeExtension(final EObject instance) {
        EClass runtimeExtensionClass;
        EObject extendedInstance = this.instanceToRuntime.get(instance);
        if (extendedInstance == null && (runtimeExtensionClass = this.baseToRuntime.get(instance.eClass())) != null) {
            extendedInstance = EcoreUtil.create((EClass)runtimeExtensionClass);
            this.instanceToRuntime.put(instance, extendedInstance);
            this.runtimeToInstance.put(extendedInstance, instance);
            for (Adapter adapter : instance.eAdapters()) {
                if (!(adapter instanceof EContentAdapter)) continue;
                Adapter runtimeAdapter = new Adapter(adapter){
                    final Adapter originalAdapter;
                    {
                        this.originalAdapter = adapter;
                    }

                    public void notifyChanged(Notification notification) {
                        this.originalAdapter.notifyChanged((Notification)new NotificationWrapper((Object)instance, notification));
                    }

                    public Notifier getTarget() {
                        return this.originalAdapter.getTarget();
                    }

                    public void setTarget(Notifier newTarget) {
                    }

                    public boolean isAdapterForType(Object type) {
                        return this.originalAdapter.isAdapterForType(type);
                    }
                };
                extendedInstance.eAdapters().add((Object)runtimeAdapter);
            }
        }
        return extendedInstance;
    }

    public Optional<EObject> getRuntimeExtension(EObject instance) {
        EObject extendedInstance = this.instanceToRuntime.get(instance);
        return Optional.ofNullable(extendedInstance);
    }

    public EObject getInstanceOrSelf(EObject eObject) {
        EObject res = this.runtimeToInstance.get(eObject);
        if (res != null) {
            return res;
        }
        return eObject;
    }

    public void dynamicModelConstructor(Set<EObject> model, IQueryEvaluationEngine aqlEngine) {
        model.forEach(obj -> {
            List<ExtendedClass> extensions = this.findExtensionFor((EObject)obj);
            this.init((EObject)obj, extensions, aqlEngine);
        });
    }

    private List<ExtendedClass> findExtensionFor(EObject instance) {
        return this.allImplemModels.stream().flatMap(mb -> mb.getClassExtensions().stream()).filter(xtdCls -> xtdCls.getBaseClass().isSuperTypeOf(instance.eClass())).collect(Collectors.toList());
    }

    private void init(EObject instance, List<ExtendedClass> extensions, IQueryEvaluationEngine aqlEngine) {
        EObject extendedInstance = this.getOrCreateRuntimeExtension(instance);
        HashMap<String, EObject> scope = new HashMap<String, EObject>();
        scope.put("self", instance);
        extensions.stream().flatMap(xtdCls -> xtdCls.getAttributes().stream()).filter(attr -> attr.getInitialValue() != null).forEach(attr -> {
            IQueryBuilderEngine.AstResult dummyAstResult = new IQueryBuilderEngine.AstResult(attr.getInitialValue(), new HashMap(), new HashMap(), new ArrayList(), (Diagnostic)new BasicDiagnostic());
            EvaluationResult result = aqlEngine.eval(dummyAstResult, scope);
            Object value = result.getResult();
            EStructuralFeature feature = extendedInstance.eClass().getEStructuralFeature(attr.getFeatureRef().getName());
            if (feature != null) {
                if (feature.isMany()) {
                    List featureValue = (List)extendedInstance.eGet(feature);
                    if (value instanceof Collection) {
                        featureValue.addAll((Collection)value);
                    } else {
                        featureValue.add(value);
                    }
                } else {
                    extendedInstance.eSet(feature, value);
                }
            }
        });
    }
}

