/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.addon.stategraph.logic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class DirectedGraph<T> {
    private final List<T> vertice = new ArrayList<T>();
    private final List<Edge<T>> edges = new ArrayList<Edge<T>>();
    private final Map<T, List<Edge<T>>> outgoingEdges = new HashMap<T, List<Edge<T>>>();
    private final Map<T, List<Edge<T>>> incomingEdges = new HashMap<T, List<Edge<T>>>();

    public Edge<T> addEdge(T source, T target) {
        boolean add;
        List<Edge<T>> sEdges = this.outgoingEdges.get(source);
        boolean bl = add = sEdges == null || sEdges.stream().filter(e -> e.target == target).count() == 0L;
        if (add) {
            List<Edge<T>> tEdges;
            Edge<T> edge = new Edge<T>(source, target);
            if (sEdges == null) {
                sEdges = new ArrayList<Edge<T>>();
                this.outgoingEdges.put(source, sEdges);
            }
            if ((tEdges = this.incomingEdges.get(target)) == null) {
                tEdges = new ArrayList<Edge<T>>();
                this.incomingEdges.put(target, tEdges);
            }
            sEdges.add(edge);
            tEdges.add(edge);
            this.edges.add(edge);
            return edge;
        }
        return null;
    }

    public Edge<T> addEdge(Edge<T> edge) {
        return this.addEdge(edge.source, edge.target);
    }

    public void removeEdge(T source, T target) {
        Optional.ofNullable(this.outgoingEdges.get(source)).ifPresent(l -> l.stream().filter(e -> e.target == target).findFirst().ifPresent(e -> this.removeEdge((Edge<T>)e)));
    }

    public void removeEdge(Edge<T> edge) {
        this.edges.remove(edge);
        Optional.ofNullable(this.outgoingEdges.get(edge.source)).ifPresent(l -> {
            boolean bl = l.remove(edge);
        });
        Optional.ofNullable(this.incomingEdges.get(edge.target)).ifPresent(l -> {
            boolean bl = l.remove(edge);
        });
    }

    public T addVertex(T vertex) {
        if (this.vertice.contains(vertex)) {
            return null;
        }
        this.vertice.add(vertex);
        return vertex;
    }

    public void removeVertex(T vertex) {
        HashSet toRemove = new HashSet();
        Optional.ofNullable(this.incomingEdges.get(vertex)).ifPresent(l -> l.forEach(e -> {
            boolean bl = toRemove.add(e);
        }));
        Optional.ofNullable(this.outgoingEdges.get(vertex)).ifPresent(l -> l.forEach(e -> {
            boolean bl = toRemove.add(e);
        }));
        toRemove.forEach(e -> this.removeEdge((Edge<T>)e));
        this.vertice.remove(vertex);
    }

    public List<T> getVertice() {
        return Collections.unmodifiableList(this.vertice);
    }

    public List<Edge<T>> getEdges() {
        return Collections.unmodifiableList(this.edges);
    }

    public boolean containsEdge(T source, T target) {
        List<Edge<T>> sEdges = this.outgoingEdges.get(source);
        if (sEdges == null) {
            return false;
        }
        return sEdges.stream().filter(e -> e.target == target).count() == 1L;
    }

    public Edge<T> getEdge(T source, T target) {
        List<Edge<T>> sEdges = this.outgoingEdges.get(source);
        if (sEdges == null) {
            return null;
        }
        return sEdges.stream().filter(e -> e.target == target).findFirst().orElse(null);
    }

    public List<Edge<T>> getIncomingEdges(T vertex) {
        List<Edge<T>> vEdges = this.incomingEdges.get(vertex);
        if (vEdges == null) {
            return Collections.emptyList();
        }
        return vEdges;
    }

    public List<Edge<T>> getOutgoingEdges(T vertex) {
        List<Edge<T>> vEdges = this.outgoingEdges.get(vertex);
        if (vEdges == null) {
            return Collections.emptyList();
        }
        return vEdges;
    }

    public List<T> getPredecessors(T vertex) {
        List<Edge<T>> vEdges = this.incomingEdges.get(vertex);
        if (vEdges == null) {
            return Collections.emptyList();
        }
        return vEdges.stream().map(e -> e.source).collect(Collectors.toList());
    }

    public List<T> getSuccessors(T vertex) {
        List<Edge<T>> vEdges = this.outgoingEdges.get(vertex);
        if (vEdges == null) {
            return Collections.emptyList();
        }
        return vEdges.stream().map(e -> e.target).collect(Collectors.toList());
    }

    public static class Edge<T> {
        private final T source;
        private final T target;

        protected Edge(T source, T target) {
            this.source = source;
            this.target = target;
        }

        public T getSource() {
            return this.source;
        }

        public T getTarget() {
            return this.target;
        }
    }
}

