/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.addon.stategraph.views;

import javafx.application.Platform;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.OverrunStyle;
import javafx.scene.control.Tooltip;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import org.eclipse.gemoc.addon.stategraph.logic.StateVertex;

public class VertexView
extends Group {
    private double mouseX;
    private double mouseY;
    private boolean currentState = false;
    private int stateIndex;
    private static final double RADIUS = 12.0;
    private static final DropShadow GLOW = new DropShadow(2.5, Color.BLACK);
    private static final Font STATE_INDEX_FONT = Font.font((String)"Arial", (FontWeight)FontWeight.BOLD, (double)9.0);
    private final Circle circle = new Circle(12.0);
    private final Label label;

    public VertexView(int stateIndex, StateVertex vertex) {
        this.circle.setFill((Paint)Color.SLATEBLUE);
        this.stateIndex = stateIndex;
        String s = vertex.getTooltip();
        Tooltip t = new Tooltip(s);
        Tooltip.install((Node)this, (Tooltip)t);
        vertex.setOnTooltipUpdateCommand(text -> Platform.runLater(() -> t.setText(text)));
        this.label = new Label(this.computeStateLabel(this.stateIndex));
        this.label.setTextOverrun(OverrunStyle.ELLIPSIS);
        this.label.setAlignment(Pos.CENTER);
        this.label.setMouseTransparent(true);
        this.label.setTextFill((Paint)Color.WHITE);
        this.label.setFont(STATE_INDEX_FONT);
        this.label.setMaxWidth(24.0);
        StackPane layout = new StackPane();
        layout.getChildren().addAll((Object[])new Node[]{this.circle, this.label});
        layout.setTranslateX(-12.0);
        layout.setTranslateY(-12.0);
        this.getChildren().add((Object)layout);
        this.setOnMousePressed(event -> {
            this.circle.setCursor(Cursor.MOVE);
            this.mouseX = event.getX();
            this.mouseY = event.getY();
            event.consume();
        });
        this.setOnMouseReleased(event -> this.setCursor(Cursor.DEFAULT));
        this.setOnMouseDragged(event -> {
            double deltaX = event.getX() - this.mouseX;
            double deltaY = event.getY() - this.mouseY;
            this.setTranslateX(this.getTranslateX() + deltaX);
            this.setTranslateY(this.getTranslateY() + deltaY);
            event.consume();
        });
        this.setOnMouseEntered(event -> this.circle.setEffect((Effect)GLOW));
        this.setOnMouseExited(event -> this.circle.setEffect(null));
    }

    private String computeStateLabel(int stateNumber) {
        if (stateNumber > 999) {
            return String.valueOf(stateNumber / 1000) + "k" + stateNumber % 1000 / 10;
        }
        return "" + stateNumber;
    }

    public void setCurrentState(boolean currentState) {
        if (this.currentState != currentState) {
            this.currentState = currentState;
            if (this.currentState) {
                this.circle.setFill((Paint)Color.CORAL);
            } else {
                this.circle.setFill((Paint)Color.SLATEBLUE);
            }
        }
    }

    public void setStateIndex(int stateIndex) {
        if (this.stateIndex != stateIndex) {
            this.stateIndex = stateIndex;
            this.label.setText(this.computeStateLabel(this.stateIndex));
        }
    }
}

