/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.instantrelation.generator.metier;

import fr.inria.aoste.timesquare.instantrelation.CCSLRelationModel.CCSLConstraintRef;
import fr.inria.aoste.timesquare.instantrelation.CCSLRelationModel.OccurrenceRelation;
import fr.inria.aoste.timesquare.instantrelation.exceptions.ResolveClockConstraintException;
import fr.inria.aoste.timesquare.instantrelation.generator.metier.Description;
import fr.inria.aoste.timesquare.instantrelation.generator.metier.activation.ActivationCreator;
import fr.inria.aoste.timesquare.instantrelation.listener.IRelationModelListener;
import fr.inria.aoste.timesquare.trace.util.HelperFactory;
import fr.inria.aoste.trace.EventOccurrence;
import fr.inria.aoste.trace.FiredStateKind;
import fr.inria.aoste.trace.LogicalStep;
import fr.inria.aoste.trace.ModelElementReference;
import fr.inria.aoste.trace.Reference;

public abstract class AbstractCreator {
    protected CCSLConstraintRef ccslConstraintRef = null;
    protected IRelationModelListener irml = null;
    protected ActivationCreator activationCreator = new ActivationCreator();
    LogicalStep currentstep = null;
    Description d = null;

    public AbstractCreator(CCSLConstraintRef cref) {
        if (cref == null) {
            throw new NullPointerException("CCSLConstraintRef is null");
        }
        this.ccslConstraintRef = cref;
    }

    public final boolean clockTick(EventOccurrence cs) {
        if (cs != null) {
            return cs.getFState() == FiredStateKind.TICK;
        }
        return false;
    }

    public boolean addChecking() {
        return true;
    }

    public void finish() throws ResolveClockConstraintException {
    }

    public final CCSLConstraintRef getCcslConstraintRef() {
        return this.ccslConstraintRef;
    }

    public final ActivationCreator getActivationCreator() {
        return this.activationCreator;
    }

    public final void setActivationCreator(ActivationCreator _activationCreator) {
        this.activationCreator = _activationCreator;
        if (this.activationCreator == null) {
            this.activationCreator = new ActivationCreator();
        }
    }

    public final EventOccurrence getEventOccurrenceOnStepTrace(ModelElementReference clk) {
        return HelperFactory.getEventOccurence((LogicalStep)this.currentstep, (Reference)clk);
    }

    public final IRelationModelListener getIrml() {
        return this.irml;
    }

    public final void resolve(LogicalStep stepTrace) throws ResolveClockConstraintException {
        this.currentstep = stepTrace;
        this.activationCreator.updateStep(stepTrace);
        if (this.activationCreator.mustInit()) {
            this.init();
        }
        if (this.activationCreator.isActive()) {
            this.resolve();
        }
        if (this.activationCreator.mustFinish()) {
            this.finish();
        }
        this.currentstep = null;
    }

    protected abstract void init();

    protected abstract void resolve() throws ResolveClockConstraintException;

    public final void setConstraint(ModelElementReference newSource) {
        if (this.ccslConstraintRef != null) {
            this.ccslConstraintRef.setCcslConstraint((Reference)newSource);
        }
    }

    public final void setIrml(IRelationModelListener irml) {
        this.irml = irml;
    }

    public String toString() {
        if (this.ccslConstraintRef.getCcslConstraint() != null) {
            Reference eo = this.ccslConstraintRef.getCcslConstraint();
            return eo.toString();
        }
        return super.toString();
    }

    protected final void addRelation(OccurrenceRelation r) {
        if (r != null) {
            if (this.getDescription().checkOccurrenceRelation(r)) {
                this.ccslConstraintRef.getRelatedOccurrenceRelations().add((Object)r);
                if (this.irml != null) {
                    this.irml.aNewRelation(r);
                }
            } else {
                System.err.println("*************************************************************");
            }
        }
    }

    public final synchronized Description getDescription() {
        if (this.d == null) {
            this.d = this.createDescription();
        }
        return this.d;
    }

    protected abstract Description createDescription();

    public boolean clockwasBorn(ModelElementReference clock) {
        return this.clockwasBorn(this.getEventOccurrenceOnStepTrace(clock));
    }

    public boolean clockwasBorn(EventOccurrence cs) {
        if (cs != null) {
            return cs.isWasBorn();
        }
        return false;
    }
}

