/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.vcdgenerator.behaviors;

import fr.inria.aoste.timesquare.backend.manager.visible.ClockEntity;
import fr.inria.aoste.timesquare.backend.manager.visible.TraceHelper;
import fr.inria.aoste.timesquare.backend.vcdgenerator.behaviors.DurationClockBehavior;
import fr.inria.aoste.timesquare.trace.util.ReferenceNameBuilder;
import fr.inria.aoste.timesquare.vcd.model.BinaryVectorValueChange;
import fr.inria.aoste.timesquare.vcd.model.ICommentCommand;
import fr.inria.aoste.timesquare.vcd.model.ValueChange;
import fr.inria.aoste.timesquare.vcd.model.keyword.VarType;
import fr.inria.aoste.trace.EventOccurrence;
import fr.inria.aoste.trace.FiredStateKind;
import fr.inria.aoste.trace.ModelElementReference;

public class GenericDurationClockBehavior
extends DurationClockBehavior {
    public static final int MODE_START_FINISH = 0;
    public static final int MODE_SEND_RECEIVE = 1;
    private ClockEntity startClock;
    private ClockEntity endClock;
    private ClockEntity refClock;
    private int mode;
    private boolean displayedOverlap;

    public boolean isRef() {
        return this.refClock != null;
    }

    public GenericDurationClockBehavior(int mode, ClockEntity beginClockEntity, ClockEntity endClockEntity, ClockEntity refClockEntity, boolean displayedOverlap) {
        this(mode, beginClockEntity, endClockEntity, displayedOverlap);
        this.refClock = refClockEntity;
    }

    public GenericDurationClockBehavior(int mode, ClockEntity beginClockEntity, ClockEntity endClockEntity, boolean displayedOverlap) {
        if (mode != 0 && mode != 1) {
            return;
        }
        this.startClock = beginClockEntity;
        this.endClock = endClockEntity;
        this.mode = mode;
        this.refClock = null;
        this.displayedOverlap = displayedOverlap;
    }

    public void run(TraceHelper helper) {
        EventOccurrence eventOccurrence = helper.getClockState();
        if (eventOccurrence.isIsClockDead()) {
            this._scoreBoard.add((ValueChange)new BinaryVectorValueChange("Z", this._pCode));
            return;
        }
        if (helper.getClockEntity().getName().compareTo(this.startClock.getName()) == 0) {
            if (eventOccurrence.getFState() == FiredStateKind.TICK) {
                this._scoreBoard.add((ValueChange)new BinaryVectorValueChange("X", this._pCode));
            }
            return;
        }
        if (helper.getClockEntity().getName().compareTo(this.endClock.getName()) == 0) {
            if (eventOccurrence.getFState() == FiredStateKind.TICK) {
                this._scoreBoard.add((ValueChange)new BinaryVectorValueChange("Z", this._pCode));
            }
            return;
        }
        if (this.refClock != null && helper.getClockEntity().getName().compareTo(this.refClock.getName()) == 0) {
            return;
        }
    }

    public void runWithWrongActivationState(TraceHelper helper) {
    }

    public String getDescription() {
        String modeDesc = "";
        if (this.mode == 1) {
            modeDesc = "send/receive";
        } else if (this.mode == 0) {
            modeDesc = "start/finish";
        }
        return String.valueOf(this.startClock.getName()) + " and " + this.endClock.getName() + " define a " + modeDesc + " relation.";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        GenericDurationClockBehavior other = (GenericDurationClockBehavior)o;
        return this.startClock == other.startClock && this.endClock == other.endClock && this.refClock == other.refClock && this.displayedOverlap == other.displayedOverlap;
    }

    @Override
    public void initialize() {
        this._scoreBoard.addVar("Duration" + this._pCode, VarType.tri, this._pCode);
        ICommentCommand icc = this._scoreBoard.getVcdModel().createCommentClock("alias", "Duration" + this._pCode);
        if (icc != null) {
            String startName = ReferenceNameBuilder.buildQualifiedName((ModelElementReference)this.startClock.getModelElementReference());
            String endName = ReferenceNameBuilder.buildQualifiedName((ModelElementReference)this.endClock.getModelElementReference());
            icc.setString(2, "\"" + startName + " to " + endName + "\"");
        }
        this.setInitialized(true);
    }

    public ClockEntity getStartClock() {
        return this.startClock;
    }

    public ClockEntity getEndClock() {
        return this.endClock;
    }

    public ClockEntity getRefClock() {
        return this.refClock;
    }
}

