/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.sequential.modeling.wb.sample.deployer.wizards;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.gemoc.sequential.modeling.wb.sample.deployer.Activator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;

public abstract class AbstractExampleWizard
extends Wizard
implements INewWizard {
    public boolean performFinish() {
        final Collection<ProjectDescriptor> projectDescriptors = this.getProjectDescriptors();
        WorkspaceJob job = new WorkspaceJob("Unzipping Projects"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask("Unzipping Projects", projectDescriptors.size());
                for (ProjectDescriptor desc : projectDescriptors) {
                    AbstractExampleWizard.this.unzipProject(desc, monitor);
                    monitor.worked(1);
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.schedule();
        return true;
    }

    protected abstract Collection<ProjectDescriptor> getProjectDescriptors();

    private void unzipProject(ProjectDescriptor descriptor, IProgressMonitor monitor) {
        String bundleName = descriptor.getBundleName();
        String zipLocation = descriptor.getZipLocation();
        String projectName = descriptor.getProjectName();
        URL interpreterZipUrl = FileLocator.find((Bundle)Platform.getBundle((String)bundleName), (IPath)new Path(zipLocation), null);
        if (interpreterZipUrl == null) {
            String message = "cannot find " + zipLocation + " in plugin " + bundleName + ". Project " + projectName + " will not be created";
            Activator.getDefault().error(message, new Exception(message));
            return;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project.exists()) {
            return;
        }
        try {
            project.create(monitor);
            ZipInputStream zipFileStream = new ZipInputStream(interpreterZipUrl.openStream());
            ZipEntry zipEntry = zipFileStream.getNextEntry();
            String regexedProjectName = projectName.replaceAll("\\.", "\\.");
            while (zipEntry != null) {
                File file = new File(project.getLocation().toString(), zipEntry.getName().replaceFirst("^" + regexedProjectName + "/", ""));
                if (!zipEntry.isDirectory()) {
                    File parentFile = file.getParentFile();
                    if (parentFile != null && !parentFile.exists()) {
                        parentFile.mkdirs();
                    }
                    try (FileOutputStream os = null;){
                        os = new FileOutputStream(file);
                        byte[] buffer = new byte[102400];
                        while (true) {
                            int len = zipFileStream.read(buffer);
                            if (zipFileStream.available() == 0) {
                                break;
                            }
                            ((OutputStream)os).write(buffer, 0, len);
                        }
                    }
                }
                zipFileStream.closeEntry();
                zipEntry = zipFileStream.getNextEntry();
            }
            project.open(monitor);
            project.close(monitor);
            project.open(monitor);
            project.refreshLocal(2, monitor);
        }
        catch (IOException e) {
            this.getContainerPlugin().getLog().log((IStatus)new Status(4, this.getContainerPlugin().getBundle().getSymbolicName(), 4, e.getMessage(), (Throwable)e));
        }
        catch (CoreException e) {
            this.getContainerPlugin().getLog().log(e.getStatus());
        }
    }

    protected abstract AbstractUIPlugin getContainerPlugin();

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public static class ProjectDescriptor {
        private String bundleName;
        private String zipLocation;
        private String projectName;

        public ProjectDescriptor(String bundleName, String zipLocation, String projectName) {
            this.bundleName = bundleName;
            this.zipLocation = zipLocation;
            this.projectName = projectName;
        }

        public String getBundleName() {
            return this.bundleName;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public String getZipLocation() {
            return this.zipLocation;
        }
    }
}

