/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.solver.launch;

import fr.inria.aoste.timesquare.ccslkernel.model.utils.ResourceLoader;
import fr.inria.aoste.timesquare.ccslkernel.solver.launch.CCSLKernelSolverWrapper;
import fr.inria.aoste.timesquare.launcher.core.PropertySimulation;
import fr.inria.aoste.timesquare.launcher.core.inter.IBuildSolver;
import fr.inria.aoste.timesquare.launcher.core.inter.ICCSLProxy;
import fr.inria.aoste.timesquare.launcher.core.inter.ISolver;
import fr.inria.aoste.timesquare.simulationpolicy.SimulationPolicyBase;
import fr.inria.aoste.timesquare.simulationpolicy.SimulationPolicyManager;
import org.eclipse.core.resources.IFile;

public class CCSLKernelSolverBuilder
implements IBuildSolver {
    private CCSLKernelSolverWrapper solverWrapper;
    private Throwable exception;

    public ISolver buildSolver(ICCSLProxy iccslproxy) {
        this.buildSolverWrapper(iccslproxy);
        if (this.solverWrapper.getSolver().getModel() == null) {
            try {
                IFile ccslFile = iccslproxy.get_SourceIFile();
                this.solverWrapper.getSolver().loadModel(ResourceLoader.INSTANCE.loadResource(ccslFile.getFullPath()));
                IFile prioFile = iccslproxy.get_PrioritySourceIFile();
                if (prioFile != null) {
                    this.solverWrapper.getSolver().loadPriorityModel(ResourceLoader.INSTANCE.loadResource(prioFile.getFullPath()));
                }
            }
            catch (Throwable e) {
                this.exception = e;
                return null;
            }
        }
        return this.solverWrapper;
    }

    private void buildSolverWrapper(ICCSLProxy iccslproxy) {
        this.solverWrapper = new CCSLKernelSolverWrapper();
        int policyId = iccslproxy.getPolicyId();
        SimulationPolicyBase policy = SimulationPolicyManager.getDefault().getNewInstance(policyId);
        this.solverWrapper.getSolver().setPolicy(policy);
    }

    public Throwable getException() {
        return this.exception;
    }

    public void clearCache(int level) {
    }

    public int getDefaultValue() {
        return 100;
    }

    public PropertySimulation[] getSupportPropertySimulation() {
        return null;
    }

    public boolean validateSolver(ICCSLProxy iccslproxy) {
        if (this.solverWrapper == null) {
            this.exception = new Exception("Internal Error: NULL solver object in validateSolver()");
            return false;
        }
        IFile ccslFile = iccslproxy.get_SourceIFile();
        if (ccslFile.getFileExtension().compareTo("extendedCCSL") != 0 && ccslFile.getFileExtension().compareTo("timemodel") != 0) {
            return false;
        }
        if (this.solverWrapper.getSolver().getModel() == null) {
            try {
                this.solverWrapper.getSolver().loadModel(ResourceLoader.INSTANCE.loadResource(ccslFile.getFullPath()));
                return true;
            }
            catch (Throwable e) {
                this.exception = e;
                return false;
            }
        }
        return true;
    }
}

