/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.launcher.ui;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut2;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.part.FileEditorInput;

public class CCSLLaunchSimulationShortcut
implements ILaunchShortcut2 {
    public IFile getLaunchableResource(IEditorPart editorpart) {
        try {
            IFile file = ((FileEditorInput)editorpart.getEditorInput().getPersistable()).getFile();
            return file;
        }
        catch (Exception e) {
            return null;
        }
    }

    public IResource getLaunchableResource(ISelection selection) {
        Object element;
        IStructuredSelection ss;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() >= 1 && (element = ss.getFirstElement()) instanceof IResource) {
            return (IResource)element;
        }
        return null;
    }

    public ILaunchConfiguration[] getLaunchConfigurations(IEditorPart editorpart) {
        try {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            manager.getLaunchConfigurationType("fr.inria.aoste.timesquare.launcher.core.launchConfigurationType");
            return new ILaunchConfiguration[0];
        }
        catch (Throwable throwable) {
            return new ILaunchConfiguration[0];
        }
    }

    public ILaunchConfiguration[] getLaunchConfigurations(ISelection selection) {
        try {
            DebugPlugin.getDefault().getLaunchManager();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new ILaunchConfiguration[0];
    }

    public void launch(IEditorPart editor, String mode) {
        System.err.println();
        IFile file = ((FileEditorInput)editor.getEditorInput().getPersistable()).getFile();
        System.out.println(file);
        this.launch(file, mode);
    }

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            this.searchAndLaunch(((IStructuredSelection)selection).toArray(), mode);
        }
    }

    private void launch(IFile selection, String mode) {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType lcType = manager.getLaunchConfigurationType("fr.inria.aoste.timesquare.launcher.core.launchConfigurationType");
        try {
            ILaunchConfiguration conf;
            ILaunchConfiguration[] lConfs = manager.getLaunchConfigurations(lcType);
            ArrayList<ILaunchConfiguration> conflist = new ArrayList<ILaunchConfiguration>();
            ILaunchConfiguration[] iLaunchConfigurationArray = lConfs;
            int n = lConfs.length;
            int n2 = 0;
            while (n2 < n) {
                conf = iLaunchConfigurationArray[n2];
                if (conf.getAttribute("Source", "").equals(selection.getFullPath().toString())) {
                    conflist.add(conf);
                }
                ++n2;
            }
            if (conflist.size() != 0) {
                this.launch(this.chooseConfiguration(conflist), mode);
                return;
            }
            conf = lcType.newInstance(selection.getParent(), "default");
            ILaunchConfigurationWorkingCopy workingCopy = conf.getWorkingCopy();
            workingCopy.setAttribute("Source", selection.getFullPath().toString());
            workingCopy.doSave();
            this.launch(conf, mode);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void launch(ILaunchConfiguration conf, String mode) throws CoreException {
        if (conf != null) {
            conf.launch(mode, null);
        }
    }

    private void searchAndLaunch(Object[] selections, String mode) {
        Object[] objectArray = selections;
        int n = selections.length;
        int n2 = 0;
        while (n2 < n) {
            Object sel = objectArray[n2];
            if (sel instanceof IFile) {
                this.launch((IFile)sel, mode);
            }
            ++n2;
        }
    }

    protected ILaunchConfiguration chooseConfiguration(ArrayList<ILaunchConfiguration> configList) {
        if (configList.size() == 1) {
            return configList.get(0);
        }
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(new Shell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle("CCSL Simulation");
        dialog.setMessage("Choose a CCSL Simulation");
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }
}

