/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.addon.vcdgenerator.manager;

import fr.inria.aoste.timesquare.backend.manager.visible.TraceHelper;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ConcreteEntity;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.Clock;
import fr.inria.aoste.timesquare.trace.util.HelperFactory;
import fr.inria.aoste.timesquare.trace.util.TimeBase;
import fr.inria.aoste.timesquare.trace.util.adapter.AdapterRegistry;
import fr.inria.aoste.timesquare.utils.pluginhelpers.PluginHelpers;
import fr.inria.aoste.timesquare.vcd.antlr.editors.VcdMultiPageEditor;
import fr.inria.aoste.timesquare.vcd.menu.Mode;
import fr.inria.aoste.timesquare.vcd.model.IDeclarationCommand;
import fr.inria.aoste.timesquare.vcd.model.VCDDefinitions;
import fr.inria.aoste.timesquare.vcd.model.command.DateCommand;
import fr.inria.aoste.timesquare.vcd.model.command.SimulationCommand;
import fr.inria.aoste.timesquare.vcd.model.command.TimeScaleCommand;
import fr.inria.aoste.timesquare.vcd.model.command.VersionCommand;
import fr.inria.aoste.timesquare.vcd.model.comment.ScaleCommand;
import fr.inria.aoste.timesquare.vcd.model.keyword.TimeUnit;
import fr.inria.aoste.timesquare.vcd.preferences.VcdColorPreferences;
import fr.inria.aoste.trace.EventOccurrence;
import fr.inria.aoste.trace.FiredStateKind;
import fr.inria.aoste.trace.ModelElementReference;
import fr.inria.aoste.trace.PhysicalBase;
import fr.inria.aoste.trace.Reference;
import fr.inria.aoste.trace.TraceFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gemoc.addon.vcdgenerator.ScoreBoard;
import org.eclipse.gemoc.addon.vcdgenerator.behaviors.AbstractVCDClockBehavior;
import org.eclipse.gemoc.addon.vcdgenerator.behaviors.VCDGeneratorClockBehavior;
import org.eclipse.gemoc.addon.vcdgenerator.manager.GemocClockEntity;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.concurrentmse.FeedbackMSE;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.engine.MoccmlExecutionEngine;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.moc.ICCSLSolver;
import org.eclipse.gemoc.trace.commons.model.helper.StepHelper;
import org.eclipse.gemoc.trace.commons.model.trace.MSEOccurrence;
import org.eclipse.gemoc.trace.commons.model.trace.SmallStep;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionEngine;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.IEngineAddon;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;

public class VCDGeneratorManager
implements IEngineAddon {
    private static final String PLUGIN_NAME = "VCD Generation";
    private static final String VERSION_NAME = "2.1.0";
    private Vector<AbstractVCDClockBehavior> _behaviorList;
    private ScoreBoard _scoreBoard;
    private VcdMultiPageEditor _vcdEditor;
    private IPath _outputFilePath;
    private String _outputFileName;
    private VcdColorPreferences _myColorAPI;
    private boolean _pulses = false;
    private boolean _ghosts = false;
    private int previousSize = 0;
    private boolean _launchVCDViewer = true;
    private int _currentStep = 0;
    private String _durationModelFilename;
    private PhysicalBase pb = null;
    private TimeBase physical = null;
    private HashMap<Integer, StepManager> hmism = new HashMap();
    private List<StepManager> lsstep = new ArrayList<StepManager>();
    private ICCSLSolver _solver = null;
    private ScaleCommand scaleCommand;
    TimeScaleCommand tc;

    public String getPluginName() {
        return PLUGIN_NAME;
    }

    public String get_durationModelFilename() {
        return this._durationModelFilename;
    }

    public void set_durationModelFilename(String _durationModelFilename) {
        this._durationModelFilename = _durationModelFilename;
    }

    public void engineAboutToStart(IExecutionEngine<?> engine) {
        if (engine instanceof MoccmlExecutionEngine) {
            this._solver = (ICCSLSolver)((MoccmlExecutionEngine)engine).getSolver();
        }
        this._behaviorList = null;
        this._behaviorList = new Vector();
        for (ModelElementReference mer : this._solver.getAllDiscreteClocks()) {
            GemocClockEntity ced = new GemocClockEntity(mer);
            this.addVCDGeneratorBehavior(ced, true, false, null);
        }
    }

    public void addVCDGeneratorBehavior(GemocClockEntity clockEntity, boolean pulses, boolean ghosts, GemocClockEntity discretize) {
        this.addVCDGeneratorBehavior(new VCDGeneratorClockBehavior(pulses, ghosts, clockEntity.getName(), discretize != null ? AdapterRegistry.getAdapter((EObject)discretize.getModelElementReference()).getUID((EObject)discretize.getModelElementReference()) : ""), clockEntity, discretize);
    }

    private void addVCDGeneratorBehavior(VCDGeneratorClockBehavior behavior, GemocClockEntity clockEntity, GemocClockEntity discretize) {
        this.addVCDGeneratorBehavior(behavior);
    }

    private void addVCDGeneratorBehavior(VCDGeneratorClockBehavior behavior) {
        this._behaviorList.add(behavior);
        if (behavior.isPulses()) {
            this._pulses = true;
        }
        if (behavior.isGhosts()) {
            this._ghosts = true;
        }
        behavior.getDiscretize();
    }

    private GemocClockEntity getClock(VCDGeneratorClockBehavior behavior) {
        ArrayList<GemocClockEntity> allClocksEntities = new ArrayList<GemocClockEntity>();
        for (ModelElementReference mer : this._solver.getAllDiscreteClocks()) {
            allClocksEntities.add(new GemocClockEntity(mer));
        }
        for (GemocClockEntity clock : allClocksEntities) {
            if (clock.getName().compareTo(behavior.getName()) != 0) continue;
            return clock;
        }
        return null;
    }

    public void clear() {
        this._behaviorList.clear();
    }

    public void engineStarted(IExecutionEngine<?> executionEngine) {
        IPath fin = executionEngine.getExecutionContext().getWorkspace().getExecutionPath();
        IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(fin);
        this.setOutputFile(folder.getLocation(), "vcdFromSimu");
        this._myColorAPI = VcdColorPreferences.createColor();
        this._scoreBoard = ScoreBoard.getScoreboard(this._outputFileName, this._myColorAPI);
        this.fileHeader();
        int i = 0;
        for (AbstractVCDClockBehavior behavior : this._behaviorList) {
            if (behavior instanceof VCDGeneratorClockBehavior) {
                ((VCDGeneratorClockBehavior)behavior).setClock(this.getClock((VCDGeneratorClockBehavior)behavior));
                ((VCDGeneratorClockBehavior)behavior).setPulses(this._pulses);
                ((VCDGeneratorClockBehavior)behavior).setGhosts(this._ghosts);
            }
            behavior.setScoreBoard(this._scoreBoard);
            if (behavior.getPCode() == null) {
                behavior.setPCode("!" + ++i);
            }
            if (behavior.isInitialized()) continue;
            behavior.initialize();
        }
        this.scaleCommand = this.pb == null ? new ScaleCommand(0.1) : new ScaleCommand(this.physical.getBase(), this.physical.getUnitname());
        this._scoreBoard.getVcdModel().addDefinition((IDeclarationCommand)this.scaleCommand);
        this.createFileCreationThread();
    }

    public void engineAboutToStop(IExecutionEngine<?> engine) {
        ++this._currentStep;
        if (this._scoreBoard != null) {
            int instant = this._currentStep * 10;
            SimulationCommand sc = this._scoreBoard.tick(instant);
            for (AbstractVCDClockBehavior behavior : this._behaviorList) {
                behavior.end();
            }
            StepManager sm = new StepManager();
            sm.simCommand = sc;
            sm.fixed = false;
            if (this.hmism != null) {
                this.hmism.put(this._currentStep, sm);
            }
            this.lsstep.add(sm);
            if (this.pb != null) {
                this.updateDate(this.pb);
            }
            this.createEndThread();
            this._myColorAPI = null;
            if (this._scoreBoard != null) {
                ScoreBoard.removeScoreboard(this._scoreBoard);
            }
            this._scoreBoard = null;
            for (AbstractVCDClockBehavior b : this._behaviorList) {
                b.setScoreBoard(null);
            }
            this._behaviorList.clear();
            this._behaviorList = null;
            this.hmism.clear();
            this.lsstep.clear();
            this.hmism = null;
            this.lsstep = null;
        }
    }

    public void stepExecuted(IExecutionEngine<?> engine, Step<?> logicalStepExecuted) {
        SimulationCommand sc;
        if (this._scoreBoard == null || logicalStepExecuted == null) {
            return;
        }
        if (logicalStepExecuted instanceof SmallStep) {
            return;
        }
        ++this._currentStep;
        int instant = this._currentStep * 10;
        StepManager sm = new StepManager();
        sm.simCommand = sc = this._scoreBoard.tick(instant);
        sm.fixed = false;
        this.hmism.put(this._currentStep, sm);
        this.lsstep.add(sm);
        ArrayList<AbstractVCDClockBehavior> alreadyDone = new ArrayList<AbstractVCDClockBehavior>();
        for (MSEOccurrence occ : StepHelper.collectAllMSEOccurrences(logicalStepExecuted)) {
            if (!(occ.getMse() instanceof FeedbackMSE)) continue;
            Clock c = (Clock)((FeedbackMSE)occ.getMse()).getFeedbackModelSpecificEvent().getSolverEvent();
            for (AbstractVCDClockBehavior b : this._behaviorList) {
                if (!(b instanceof VCDGeneratorClockBehavior)) continue;
                VCDGeneratorClockBehavior vb = (VCDGeneratorClockBehavior)b;
                ConcreteEntity ce = ((GemocClockEntity)vb.getClock())._ce;
                ModelElementReference mer = ((GemocClockEntity)vb.getClock())._mer;
                if (ce.getName().compareTo(c.getName()) != 0) continue;
                alreadyDone.add(b);
                EventOccurrence eocc = TraceFactory.eINSTANCE.createEventOccurrence();
                eocc.setFState(FiredStateKind.TICK);
                eocc.setReferedElement((Reference)mer);
                TraceHelper th = new TraceHelper(eocc, vb.getClock());
                vb.run(th);
                vb.aPostNewStep();
            }
        }
        for (AbstractVCDClockBehavior b : this._behaviorList) {
            if (alreadyDone.contains(b) || !(b instanceof VCDGeneratorClockBehavior)) continue;
            VCDGeneratorClockBehavior vb = (VCDGeneratorClockBehavior)b;
            EventOccurrence eocc = TraceFactory.eINSTANCE.createEventOccurrence();
            eocc.setFState(FiredStateKind.NO_TICK);
            TraceHelper th = new TraceHelper(eocc, vb.getClock());
            vb.run(th);
            vb.aPostNewStep();
        }
        this.createVCDUpdateThread();
    }

    private void setOutputFile(IPath path, String name) {
        this._outputFilePath = path;
        this._outputFileName = name;
    }

    private void fileHeader() {
        this._scoreBoard.getVcdModel().addDefinition((IDeclarationCommand)new DateCommand(new Date().toString()));
        this._scoreBoard.getVcdModel().addDefinition((IDeclarationCommand)new VersionCommand(PLUGIN_NAME, VERSION_NAME));
        this.tc = new TimeScaleCommand();
        this.tc.set(1, TimeUnit.tick);
        this._scoreBoard.getVcdModel().addDefinition((IDeclarationCommand)this.tc);
    }

    private void createFileCreationThread() {
        try {
            FileCreationThread thread = new FileCreationThread();
            Display.getDefault().syncExec((Runnable)thread);
            thread.join();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createVCDUpdateThread() {
        if (this._scoreBoard != null) {
            try {
                UpdateThread thread = new UpdateThread();
                Display.getDefault().syncExec((Runnable)thread);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void createEndThread() {
        try {
            EndThread thread = new EndThread();
            Display.getDefault().syncExec((Runnable)thread);
            thread.join();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void engineStopped(IExecutionEngine<?> engine) {
        this.engineAboutToStop(engine);
        if (this._scoreBoard != null) {
            ScoreBoard.removeScoreboard(this._scoreBoard);
        }
    }

    public void engineAboutToDispose(IExecutionEngine<?> engine) {
        if (this._vcdEditor != null) {
            this._vcdEditor.getEditorSite().getPage().closeEditor((IEditorPart)this._vcdEditor, true);
            this._vcdEditor = null;
        }
    }

    public int updateDate(PhysicalBase pb) {
        try {
            int intervalLenght;
            this.scaleCommand.setBase(this.physical.getBase() / 100.0);
            Boolean firstSimulationFixed = this.lsstep.get((int)0).fixed;
            int intervalLenghtRef = intervalLenght = HelperFactory.getMaxInterval((PhysicalBase)pb) + 1;
            if (intervalLenght % 10 != 0) {
                intervalLenght = intervalLenght / 10 + 10;
            }
            int scaleUnit = 0;
            scaleUnit = intervalLenghtRef < 6 ? intervalLenght / 5 : intervalLenght / 10;
            int currentSimulationTime = -1;
            int currentIntervalUnit = 0;
            for (StepManager sm : this.lsstep) {
                if (sm == null) continue;
                if (firstSimulationFixed.booleanValue()) {
                    if (currentSimulationTime == -1) {
                        ++currentSimulationTime;
                        sm.simCommand.setTime(0);
                        continue;
                    }
                    if (sm.fixed) {
                        currentSimulationTime = currentIntervalUnit += intervalLenght;
                        sm.simCommand.setTime(currentSimulationTime * 10);
                        continue;
                    }
                    sm.simCommand.setTime((currentSimulationTime += scaleUnit) * 10);
                    continue;
                }
                if (currentSimulationTime == -1) {
                    ++currentSimulationTime;
                    sm.simCommand.setTime(0);
                    continue;
                }
                if (sm.fixed) {
                    currentSimulationTime = currentIntervalUnit += intervalLenght;
                    sm.simCommand.setTime(currentSimulationTime * 10);
                    continue;
                }
                sm.simCommand.setTime((currentSimulationTime += scaleUnit) * 10);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return 0;
    }

    public boolean is_launchVCDViewer() {
        return this._launchVCDViewer;
    }

    public void set_launchVCDViewer(boolean _launchVCDViewer) {
        this._launchVCDViewer = _launchVCDViewer;
    }

    private class EndThread
    extends Thread {
        protected EndThread() {
            super("End VCD Thread");
        }

        @Override
        public void run() {
            try {
                if (VCDGeneratorManager.this._vcdEditor != null) {
                    VCDGeneratorManager.this._vcdEditor.syncModel2Text();
                    VCDGeneratorManager.this._vcdEditor.setFocus();
                    int currentSize = VCDGeneratorManager.this._scoreBoard.getSize();
                    VCDGeneratorManager.this._vcdEditor.update2(VCDGeneratorManager.this.previousSize, currentSize, true);
                    if (VCDGeneratorManager.this._vcdEditor.getTraceCollector() != null) {
                        VCDGeneratorManager.this._vcdEditor.getTraceCollector().setPartial(false);
                    }
                    VCDGeneratorManager.this._vcdEditor.setSimulation(false);
                    VCDGeneratorManager.this._vcdEditor.doSave(null);
                    VCDGeneratorManager.this._vcdEditor.vcdMultiPageEditorRefresh();
                }
                ScoreBoard.removeScoreboard(VCDGeneratorManager.this._scoreBoard);
                VCDGeneratorManager.this._scoreBoard = null;
                VCDGeneratorManager.this._myColorAPI = null;
                if (VCDGeneratorManager.this._vcdEditor != null) {
                    VCDGeneratorManager.this._vcdEditor.setActiveVCDPage();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            VCDGeneratorManager.this._scoreBoard = null;
            VCDGeneratorManager.this._myColorAPI = null;
        }
    }

    private class FileCreationThread
    extends Thread {
        protected FileCreationThread() {
            super("File Creation Thread");
        }

        @Override
        public void run() {
            IFile file = PluginHelpers.touchFile((IPath)VCDGeneratorManager.this._outputFilePath, (String)(String.valueOf(VCDGeneratorManager.this._outputFileName) + ".vcd"));
            VCDGeneratorManager.this._vcdEditor = VcdMultiPageEditor.createNewVcdMultiPageEditor((VCDDefinitions)VCDGeneratorManager.this._scoreBoard.getVcdModel(), (IFile)file, (VcdColorPreferences)VCDGeneratorManager.this._myColorAPI);
            if (VCDGeneratorManager.this._vcdEditor != null) {
                VCDGeneratorManager.this._vcdEditor.setSimulation(true);
                VCDGeneratorManager.this._vcdEditor.getTraceCollector().setPartial(true);
                VCDGeneratorManager.this._vcdEditor.setGhostMode(Mode.bool2Mode((boolean)VCDGeneratorManager.this._ghosts));
                VCDGeneratorManager.this._vcdEditor.setSimulationProgress(2);
            }
        }
    }

    private static class StepManager {
        SimulationCommand simCommand;
        boolean fixed;

        private StepManager() {
        }
    }

    private class UpdateThread
    extends Thread {
        protected UpdateThread() {
            super("Update VCD Thread");
        }

        @Override
        public void run() {
            if (VCDGeneratorManager.this._scoreBoard != null) {
                int currentSize = VCDGeneratorManager.this._scoreBoard.getSize();
                try {
                    if (VCDGeneratorManager.this._vcdEditor != null) {
                        VCDGeneratorManager.this._vcdEditor.update2(VCDGeneratorManager.this.previousSize, currentSize, false);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                VCDGeneratorManager.this.previousSize = currentSize;
                VCDGeneratorManager.this._vcdEditor.setSimulationProgress(currentSize / 10);
            }
        }
    }
}

