/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.utils.pluginhelpers;

import fr.inria.aoste.timesquare.utils.console.ErrorConsole;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;
import org.osgi.framework.Bundle;

public class PluginHelpers {
    public static String IDENTIFIER_WIDGET = "fr.inria.aoste.timesquare.widget.identifier";
    private static ImageRegistry imageRegistry = null;
    private static final String DEFAULT_IMAGE = "icons/Default.gif";
    private static ArrayList<String> list = null;
    private static HashMap<String, IConfigurationElement> plugin = null;
    static IWorkspaceRoot iw = null;

    public static Image getImage(String plugin, String key) {
        String rkey;
        Image image;
        if (imageRegistry == null) {
            Display display = Display.getDefault();
            display.syncExec((Runnable)new ImageRegistryInitialization());
        }
        if ((image = imageRegistry.get(rkey = String.valueOf(plugin) + "@" + key)) == null) {
            try {
                ImageDescriptor desc = PluginHelpers.getimageDescriptorFromPlugin(plugin, key);
                imageRegistry.put(rkey, desc);
                image = imageRegistry.get(rkey);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (image == null && !key.equals(DEFAULT_IMAGE)) {
            image = PluginHelpers.getImage("fr.inria.aoste.timesquare.utils.pluginhelpers", DEFAULT_IMAGE);
        }
        return image;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ImageDescriptor getimageDescriptorFromPlugin(String plugin, String key) {
        ImageDescriptor desc = null;
        try {
            desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)plugin, (String)key);
            if (desc != null) return desc;
            if (Platform.getBundle((String)"fr.inria.aoste.timesquare.utils.pluginhelpers") != null) return desc;
            int plulen = plugin.length();
            String f = System.getProperty("java.class.path");
            String[] stringArray = f.split(File.pathSeparator);
            int n = stringArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    System.out.println("+" + plugin);
                    return desc;
                }
                String s = stringArray[n2];
                int n3 = s.lastIndexOf(plugin);
                if (n3 != -1) {
                    if (s.endsWith(".jar")) {
                        int n22 = s.indexOf(String.valueOf(plugin) + ".jar");
                        if (s.charAt(n3 + plulen) != '.' || n22 == n3 + plulen) {
                            System.out.println("read jar");
                            return ImageDescriptor.createFromURL((URL)new URL("jar:file://" + s + "!/" + key));
                        }
                    } else {
                        if (n3 == -1) return null;
                        if (s.length() >= n3 + plulen) {
                            if (s.charAt(n3 + plulen) == '.') return null;
                        }
                        String s2 = s.substring(0, s.indexOf(File.separator, n3 + 1));
                        return ImageDescriptor.createFromURL((URL)new URL("file://" + s2 + "/" + key));
                    }
                }
                ++n2;
            }
        }
        catch (Throwable e) {
            System.err.println("Img " + e);
        }
        return desc;
    }

    public static ImageDescriptor getImageDescriptor(String plugin, String key) {
        String rkey;
        ImageDescriptor desc;
        if (imageRegistry == null) {
            Display display = Display.getDefault();
            display.syncExec((Runnable)new ImageRegistryInitialization());
        }
        if ((desc = imageRegistry.getDescriptor(rkey = String.valueOf(plugin) + "@" + key)) == null) {
            desc = PluginHelpers.getimageDescriptorFromPlugin(plugin, key);
            imageRegistry.put(rkey, desc);
            desc = imageRegistry.getDescriptor(rkey);
        }
        if (desc == null && !key.equals(DEFAULT_IMAGE)) {
            desc = PluginHelpers.getImageDescriptor("fr.inria.aoste.timesquare.utils.pluginhelpers", DEFAULT_IMAGE);
        }
        return desc;
    }

    public static Image getEditorIcon(String name) {
        Image image = null;
        IConfigurationElement ice = plugin.get(name);
        if (ice == null) {
            return null;
        }
        String s = ice.getAttribute("icon");
        String sp = ice.getContributor().getName();
        image = PluginHelpers.getImage(sp, s);
        return image;
    }

    public static synchronized ArrayList<String> listingEditor(boolean refresh) {
        if (list == null || refresh) {
            IExtensionRegistry reg = Platform.getExtensionRegistry();
            IConfigurationElement[] extensions = reg.getConfigurationElementsFor("org.eclipse.ui.editors");
            list = new ArrayList();
            plugin = new HashMap();
            IConfigurationElement[] iConfigurationElementArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement ice = iConfigurationElementArray[n2];
                String editor = ice.getAttribute("class");
                list.add(editor);
                plugin.put(editor, ice);
                ++n2;
            }
        }
        return list;
    }

    public static IFileStore getIFileStore(URL url) throws URISyntaxException {
        return EFS.getLocalFileSystem().getStore(url.toURI());
    }

    public static IFileStore getIFileStore(URI uri) {
        return EFS.getLocalFileSystem().getStore(uri);
    }

    public static IFileStore getIFileStore(IPath ph) {
        return EFS.getLocalFileSystem().getStore(ph);
    }

    public static URL getInstallUrl(Bundle bundle, String path) {
        try {
            URL url = bundle.getEntry(path);
            url = FileLocator.resolve((URL)FileLocator.toFileURL((URL)url));
            String ls = url.toString();
            String nls = ls.replaceAll(" ", "%20");
            if (nls.compareTo(ls) != 0) {
                url = new URL(nls);
            }
            return url;
        }
        catch (Throwable e) {
            ErrorConsole.printError((Throwable)e);
            return null;
        }
    }

    public static IPath getIpath(AbstractUIPlugin plug) {
        return plug.getStateLocation();
    }

    public static IViewPart getShowView(String strid) {
        IWorkbench iw;
        block7: {
            block6: {
                block5: {
                    try {
                        iw = PlatformUI.getWorkbench();
                        if (iw != null) break block5;
                        return null;
                    }
                    catch (Throwable e) {
                        ErrorConsole.printError((Throwable)e);
                        return null;
                    }
                }
                if (iw.getActiveWorkbenchWindow() != null) break block6;
                return null;
            }
            if (iw.getActiveWorkbenchWindow().getActivePage() != null) break block7;
            return null;
        }
        return iw.getActiveWorkbenchWindow().getActivePage().showView(strid);
    }

    public static IViewPart getCreateView(String strid) {
        IWorkbench iw;
        block3: {
            try {
                iw = PlatformUI.getWorkbench();
                if (iw != null) break block3;
                return null;
            }
            catch (Throwable e) {
                ErrorConsole.printError((Throwable)e);
                return null;
            }
        }
        IViewRegistry vr = iw.getViewRegistry();
        IViewDescriptor vd = vr.find(strid);
        return vd.createView();
    }

    public static IViewPart getPackageExplorer() {
        try {
            return PluginHelpers.getShowView("org.eclipse.jdt.ui.PackageExplorer");
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static IFile touchFile(IPath filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException("filePath");
        }
        if (!filePath.toFile().exists()) {
            throw new IllegalArgumentException("filePath " + filePath.toString() + " do not exists");
        }
        IPath folder = filePath.removeLastSegments(1);
        String fileName = filePath.lastSegment();
        return PluginHelpers.touchFile(folder, fileName);
    }

    public static IFile touchFile(IPath folder, String name) {
        try {
            IPath path = folder.append(name);
            IContainer ic = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(folder);
            System.out.println(ic);
            if (!path.toFile().exists()) {
                File f = path.toFile();
                FileOutputStream is = new FileOutputStream(f);
                is.flush();
                ((OutputStream)is).close();
            }
            PluginHelpers.refreshWorkspace();
            IResource ifile = ((IFolder)ic).findMember(name);
            return (IFile)ifile;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int copy(IFileStore src, IFileStore dst, int options, IProgressMonitor monitor) throws CoreException {
        src.copy(dst, options, monitor);
        return 0;
    }

    public static IPath getfolder(String namefile) {
        try {
            IPath p = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(namefile);
            if (p.toFile().isDirectory()) {
                return p;
            }
            return p.append("..");
        }
        catch (Throwable e) {
            ErrorConsole.printError((Throwable)e);
            return null;
        }
    }

    public static IPath createdir(IPath p, String folder) {
        try {
            EFS.getLocalFileSystem().getStore(p.append(folder)).mkdir(2, null);
            return p.append(folder);
        }
        catch (Throwable e) {
            ErrorConsole.printError((Throwable)e);
            return null;
        }
    }

    public static ISelection getSelection() {
        IWorkbenchWindow iww = PluginHelpers.getActiveWorkbench();
        if (iww == null) {
            return null;
        }
        ISelectionService iss = iww.getSelectionService();
        if (iss == null) {
            return null;
        }
        return iss.getSelection();
    }

    public static IWorkspaceRoot getWorkspaceRoot() {
        try {
            iw = ResourcesPlugin.getWorkspace().getRoot();
            return iw;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static void refreshWorkspace() {
        try {
            PluginHelpers.getWorkspaceRoot().refreshLocal(2, null);
            if (PluginHelpers.getWorkspaceRoot().getProject() != null) {
                PluginHelpers.getWorkspaceRoot().getProject().refreshLocal(2, null);
            }
        }
        catch (Throwable e) {
            ErrorConsole.printError((Throwable)e);
        }
    }

    public static IWorkbenchWindow getActiveWorkbench() {
        try {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        catch (Throwable e) {
            ErrorConsole.printError((Throwable)e);
            return null;
        }
    }

    public static IEditorPart getCourantEditor() {
        IWorkbenchWindow iww = PluginHelpers.getActiveWorkbench();
        if (iww == null) {
            return null;
        }
        IWorkbenchPage iwp = iww.getActivePage();
        if (iwp == null) {
            return null;
        }
        IEditorPart editorPart = iwp.getActiveEditor();
        return editorPart;
    }

    public static IEditorPart getActiveEditor() {
        try {
            IWorkbenchWindow iww = PluginHelpers.getActiveWorkbench();
            if (iww == null) {
            }
            IWorkbenchPage iwp = iww.getActivePage();
            if (iwp == null) {
            }
            IEditorPart editorPart = iwp.getActiveEditor();
            if (editorPart == null) {
            }
            if (iwp.getActivePartReference() == null) {
            }
            String s1 = iwp.getActivePartReference().getId();
            if (editorPart.getEditorSite() == null) {
            }
            String s2 = editorPart.getEditorSite().getId();
            if (!s1.equals(s2)) {
            }
            return editorPart;
        }
        finally {
            return null;
        }
    }

    public static ClassLoader getPluginClassLoader(String plug) {
        try {
            String s = PluginHelpers.getPluginData(plug, "Bundle-Activator");
            Bundle bdl = Platform.getBundle((String)plug);
            return bdl.loadClass(s).getClassLoader();
        }
        catch (Throwable e) {
            System.err.println(e);
            return null;
        }
    }

    public static <T> T getNewInstance(String plugin, String object, Class<? extends T> cls) {
        Bundle b;
        block4: {
            b = null;
            b = Platform.getBundle((String)plugin);
            if (b != null) break block4;
            return null;
        }
        try {
            Class c = b.loadClass(object);
            Class<T> c2 = c.asSubclass(cls);
            if (c2 != null) {
                return c2.newInstance();
            }
            System.out.println("Erreur de type");
        }
        catch (Throwable e) {
            System.err.println(e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T getNewInstance(String plugin, String object, Class<? extends T> cls, Class<?>[] lst, Object[] targ) {
        try {
            Bundle b = null;
            b = Platform.getBundle((String)plugin);
            Class c = b.loadClass(object);
            if (cls.isAssignableFrom(c)) {
                int n = lst.length;
                int n2 = targ.length;
                if (n != n2) {
                    return null;
                }
                int i = 0;
                while (true) {
                    if (i >= n) {
                        Class<T> cls2 = c.asSubclass(cls);
                        if (cls2 == null) break;
                        return cls2.getConstructor(lst).newInstance(targ);
                    }
                    if (lst[i] == null) {
                        System.err.println("class " + i + " is null");
                        return null;
                    }
                    if (targ[i] != null && !lst[i].isAssignableFrom(targ[i].getClass())) {
                        System.err.println("qrg " + i + " is not valid");
                        return null;
                    }
                    ++i;
                }
            }
            System.out.println("Erreur de type");
            return null;
        }
        catch (Throwable e) {
            System.err.println(e);
        }
        return null;
    }

    public static String getPluginVersion(String plug) {
        return PluginHelpers.getPluginData(plug, "Bundle-Version");
    }

    public static String getPluginVendor(String plug) {
        return PluginHelpers.getPluginData(plug, "Bundle-Vendor");
    }

    public static String getPluginDescription(String plug) {
        return PluginHelpers.getPluginData(plug, "Bundle-Description");
    }

    public static String getPluginData(String plug, String label) {
        try {
            Bundle bdl = Platform.getBundle((String)plug);
            if (bdl == null) {
            }
            if (bdl.getHeaders() == null) {
            }
            if (bdl.getHeaders().get(label) == null) {
            }
            String s = ((String)bdl.getHeaders().get(label)).toString();
            if (s == null) {
            }
            return s;
        }
        finally {
            return "";
        }
    }

    public static <T> Class<? extends T> getPointExtensionClass(IConfigurationElement ice, String namefield, Class<T> cls) {
        String classname;
        Bundle b;
        block3: {
            try {
                b = null;
                String plugin = ice.getDeclaringExtension().getNamespaceIdentifier();
                b = Platform.getBundle((String)plugin);
                classname = ice.getAttribute(namefield);
                if (classname != null) break block3;
                return null;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return null;
            }
        }
        Class c = b.loadClass(classname);
        return c.asSubclass(cls);
    }

    public static Map<String, Object> getEcoreSaveOption() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CONFIGURATION_CACHE", Boolean.TRUE);
        map.put("USE_FILE_BUFFER", Boolean.TRUE);
        map.put("FORMATTED", Boolean.TRUE);
        map.put("FLUSH_THRESHOLD", 1000000);
        map.put("URI_HANDLER", new URIHandlerImpl.PlatformSchemeAware());
        return map;
    }

    private static final class ImageRegistryInitialization
    implements Runnable {
        private ImageRegistryInitialization() {
        }

        @Override
        public void run() {
            if (imageRegistry == null) {
                PluginHelpers.imageRegistry = new ImageRegistry(Display.getCurrent());
            }
        }
    }
}

