/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.manager.serialization;

import fr.inria.aoste.timesquare.backend.manager.serialization.BehaviorPersistentEntity;
import fr.inria.aoste.timesquare.backend.manager.serialization.OptionsSerializer;
import fr.inria.aoste.timesquare.backend.manager.serialization.PersistentEntity;
import fr.inria.aoste.timesquare.backend.manager.serialization.SpecialObjectInputStream;
import fr.inria.aoste.timesquare.backend.manager.visible.BehaviorManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class BehaviorOptionsSerializer
extends OptionsSerializer {
    private Map<String, List<BehaviorPersistentEntity>> _data = new HashMap<String, List<BehaviorPersistentEntity>>();

    public Map<String, List<BehaviorPersistentEntity>> getData() {
        return this._data;
    }

    public void addPersistentEntity(String pluginName, BehaviorPersistentEntity persistentEntity) {
        if (this._data != null) {
            boolean find = false;
            for (Map.Entry<String, List<BehaviorPersistentEntity>> e : this._data.entrySet()) {
                if (!e.getKey().equals(pluginName)) continue;
                e.getValue().add(persistentEntity);
                find = true;
            }
            if (!find) {
                this._data.put(pluginName, new ArrayList());
                this._data.get(pluginName).add(persistentEntity);
            }
        }
    }

    public void addPersistentEntities(String pluginName, List<BehaviorPersistentEntity> persistentEntities) {
        if (this._data != null && !this._data.containsKey(pluginName)) {
            this._data.put(pluginName, persistentEntities);
        }
    }

    @Override
    public boolean doesPluginNeedSerialization(String pluginName) {
        if (this._data == null) {
            return false;
        }
        return this._data.containsKey(pluginName);
    }

    @Override
    public String getSerializedOptions(String pluginName) {
        String result = "";
        if (this._data == null) {
            return result;
        }
        List<BehaviorPersistentEntity> list = this._data.get(pluginName);
        if (list == null) {
            return result;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            try {
                oos.writeObject(list);
                oos.flush();
            }
            finally {
                try {
                    oos.close();
                }
                finally {
                    result = this.transformByteInString(baos.toByteArray());
                    baos.close();
                }
            }
        }
        catch (Throwable ioe) {
            ioe.printStackTrace();
        }
        return result;
    }

    @Override
    public void deserializeOptions(String options, BehaviorManager behaviorManager) {
        if (options == null || options.length() == 0 || behaviorManager == null || this._data == null) {
            return;
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.transformStringInByte(options));
            SpecialObjectInputStream sois = new SpecialObjectInputStream(bais, behaviorManager.getClass().getClassLoader());
            try {
                List readObject = (List)sois.readObject();
                if (readObject != null) {
                    ArrayList<BehaviorPersistentEntity> list = new ArrayList<BehaviorPersistentEntity>();
                    ListIterator li = readObject.listIterator();
                    while (li.hasNext()) {
                        Object o = li.next();
                        if (!(o instanceof PersistentEntity)) continue;
                        list.add((BehaviorPersistentEntity)o);
                    }
                    this.addPersistentEntities(behaviorManager.getPluginName(), list);
                }
            }
            finally {
                try {
                    sois.close();
                }
                finally {
                    bais.close();
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

