/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.xtext.util;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.InputStream;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.xtext.ui.editor.LanguageSpecificURIEditorOpener;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.XtextReadonlyEditorInput;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;

public class CCSLLanguageSpecificURIEditorOpener
extends LanguageSpecificURIEditorOpener {
    @Inject
    @Named(value="languageName")
    private String editorID2;
    private IWorkbenchPage activePage;

    public IEditorPart open(URI uri, EReference crossReference, int indexInList, boolean select) {
        IEditorPart iep = super.open(uri, crossReference, indexInList, select);
        if (iep == null && PlatformUI.isWorkbenchRunning()) {
            if (uri.isPlatformResource() && "platform:".equals(uri.segment(1))) {
                String s = uri.toString();
                uri = URI.createPlatformPluginURI((String)s.substring("platform:/resource/platform:/plugin".length()), (boolean)false);
            }
            if (uri.isPlatformPlugin()) {
                try {
                    this.activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IEditorInput editorInput = this.getOrCreatePluginStorage(uri);
                    IEditorPart editor = IDE.openEditor((IWorkbenchPage)this.activePage, (IEditorInput)editorInput, (String)this.editorID2);
                    this.selectAndReveal(editor, uri, crossReference, indexInList, select);
                    return EditorUtils.getXtextEditor((IEditorPart)editor);
                }
                catch (Throwable e) {
                    System.err.println(e);
                }
            }
        }
        return iep;
    }

    private IEditorInput getOrCreatePluginStorage(URI uri) {
        URI uri2 = URI.createPlatformPluginURI((String)uri.toPlatformString(true), (boolean)false);
        try {
            IEditorReference[] iert;
            IEditorReference[] iEditorReferenceArray = iert = this.activePage.getEditorReferences();
            int n = iert.length;
            int n2 = 0;
            while (n2 < n) {
                IStorage is;
                IEditorInput ie;
                IEditorReference ier = iEditorReferenceArray[n2];
                IEditorPart iep = ier.getEditor(false);
                if (iep instanceof XtextEditor && (ie = iep.getEditorInput()) instanceof XtextReadonlyEditorInput && (is = ((XtextReadonlyEditorInput)ie).getStorage()) instanceof PluginStorage && uri2.equals(((PluginStorage)is).getUri2())) {
                    return ie;
                }
                ++n2;
            }
        }
        catch (Throwable e) {
            System.err.println(e);
        }
        PluginStorage storage = new PluginStorage(uri2);
        return new XtextReadonlyEditorInput((IStorage)storage);
    }

    public static final class PluginStorage
    extends PlatformObject
    implements IStorage {
        URI uri2;

        public PluginStorage(URI uri) {
            assert (uri.isPlatformPlugin());
            this.uri2 = uri;
        }

        public URI getUri2() {
            return this.uri2;
        }

        public boolean isReadOnly() {
            return true;
        }

        public String getName() {
            return this.uri2.toString();
        }

        public IPath getFullPath() {
            return new Path(this.uri2.toString());
        }

        public InputStream getContents() throws CoreException {
            try {
                ResourceSetImpl rs = new ResourceSetImpl();
                return rs.getURIConverter().createInputStream(this.uri2);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }
}

