/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.parser.builder.event;

import java.util.Objects;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.builder.event.DocumentBuilderEvent;

public class ImageLinkEvent
extends DocumentBuilderEvent {
    private final Attributes linkAttributes;
    private final String href;
    private final Attributes imageAttributes;
    private final String imageUrl;

    public ImageLinkEvent(Attributes linkAttributes, Attributes imageAttributes, String href, String imageUrl) {
        this.linkAttributes = Objects.requireNonNull(linkAttributes, "Must provide linkAttributes").clone();
        this.imageAttributes = Objects.requireNonNull(imageAttributes, "Must provide imageAttributes").clone();
        this.href = Objects.requireNonNull(href, "Must provide link href");
        this.imageUrl = Objects.requireNonNull(imageUrl, "Must provide imageUrl");
    }

    @Override
    public void invoke(DocumentBuilder builder) {
        builder.imageLink(this.linkAttributes, this.imageAttributes, this.href, this.imageUrl);
    }

    public int hashCode() {
        return Objects.hash(this.href, this.imageUrl);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ImageLinkEvent)) {
            return false;
        }
        ImageLinkEvent other = (ImageLinkEvent)obj;
        return Objects.equals(this.href, other.href) && Objects.equals(this.imageUrl, other.imageUrl);
    }

    public String toString() {
        return String.format("imageLink(%s,%s)", this.href, this.imageUrl);
    }
}

