/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.PivotTables;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.ValueSpecification;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.OCLExpressionImpl;
import org.eclipse.ocl.pivot.library.oclany.OclAnyOclAsTypeOperation;
import org.eclipse.ocl.pivot.library.oclany.OclAnyOclIsKindOfOperation;
import org.eclipse.ocl.pivot.library.oclany.OclComparableLessThanEqualOperation;
import org.eclipse.ocl.pivot.library.string.CGStringGetSeverityOperation;
import org.eclipse.ocl.pivot.library.string.CGStringLogDiagnosticOperation;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public abstract class CallExpImpl
extends OCLExpressionImpl
implements CallExp {
    public static final int CALL_EXP_FEATURE_COUNT = 12;
    public static final int CALL_EXP_OPERATION_COUNT = 9;
    protected static final boolean IS_IMPLICIT_EDEFAULT = false;
    protected static final int IS_IMPLICIT_EFLAG = 512;
    protected static final boolean IS_SAFE_EDEFAULT = false;
    protected static final int IS_SAFE_EFLAG = 1024;
    protected OCLExpression ownedSource;

    protected CallExpImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return PivotPackage.Literals.CALL_EXP;
    }

    @Override
    public boolean isIsImplicit() {
        return (this.eFlags & 0x200) != 0;
    }

    @Override
    public OCLExpression getOwnedSource() {
        return this.ownedSource;
    }

    public NotificationChain basicSetOwnedSource(OCLExpression newOwnedSource, NotificationChain msgs) {
        OCLExpression oldOwnedSource = this.ownedSource;
        this.ownedSource = newOwnedSource;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldOwnedSource, (Object)newOwnedSource);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setOwnedSource(OCLExpression newOwnedSource) {
        if (newOwnedSource != this.ownedSource) {
            NotificationChain msgs = null;
            if (this.ownedSource != null) {
                msgs = ((InternalEObject)this.ownedSource).eInverseRemove((InternalEObject)this, -12, null, msgs);
            }
            if (newOwnedSource != null) {
                msgs = ((InternalEObject)newOwnedSource).eInverseAdd((InternalEObject)this, -12, null, msgs);
            }
            if ((msgs = this.basicSetOwnedSource(newOwnedSource, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)newOwnedSource, (Object)newOwnedSource));
        }
    }

    @Override
    public boolean validateSafeSourceCanBeNull(DiagnosticChain diagnostics, Map<Object, Object> context) {
        @NonNull String constraintName = "CallExp::SafeSourceCanBeNull";
        try {
            boolean local_0;
            @NonNull Executor executor = PivotUtil.getExecutor(this, context);
            @NonNull IdResolver idResolver = executor.getIdResolver();
            @NonNull IntegerValue severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(executor, (Object)PivotPackage.Literals.CALL_EXP___VALIDATE_SAFE_SOURCE_CAN_BE_NULL__DIAGNOSTICCHAIN_MAP);
            boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(executor, (Object)severity_0, (Object)PivotTables.INT_0);
            if (le) {
                local_0 = true;
            } else {
                boolean logDiagnostic;
                Serializable CAUGHT_result;
                try {
                    Boolean result;
                    boolean isSafe = this.isIsSafe();
                    if (!isSafe) {
                        result = ValueUtil.TRUE_VALUE;
                    } else {
                        Serializable CAUGHT_not;
                        try {
                            Serializable CAUGHT_isNullFree;
                            try {
                                Type safe_type_source;
                                @NonNull Class TYP_CollectionType = idResolver.getClass(PivotTables.CLSSid_CollectionType, null);
                                @Nullable OCLExpression ownedSource = this.getOwnedSource();
                                @NonNull Boolean type = ownedSource == null;
                                if (type == Boolean.TRUE) {
                                    safe_type_source = null;
                                } else {
                                    Type type_0;
                                    assert (ownedSource != null);
                                    safe_type_source = type_0 = ownedSource.getType();
                                }
                                @NonNull CollectionType oclAsType = (CollectionType)OclAnyOclAsTypeOperation.INSTANCE.evaluate(executor, (Object)safe_type_source, (Object)TYP_CollectionType);
                                boolean isNullFree = oclAsType.isIsNullFree();
                                CAUGHT_isNullFree = Boolean.valueOf(isNullFree);
                            }
                            catch (Exception e) {
                                CAUGHT_isNullFree = ValueUtil.createInvalidValue(e);
                            }
                            if (CAUGHT_isNullFree instanceof InvalidValueException) {
                                throw CAUGHT_isNullFree;
                            }
                            @Nullable Boolean not = CAUGHT_isNullFree == ValueUtil.FALSE_VALUE ? ValueUtil.TRUE_VALUE : (CAUGHT_isNullFree == ValueUtil.TRUE_VALUE ? ValueUtil.FALSE_VALUE : null);
                            CAUGHT_not = not;
                        }
                        catch (Exception e) {
                            CAUGHT_not = ValueUtil.createInvalidValue(e);
                        }
                        if (CAUGHT_not == ValueUtil.TRUE_VALUE) {
                            result = ValueUtil.TRUE_VALUE;
                        } else {
                            if (CAUGHT_not instanceof InvalidValueException) {
                                throw CAUGHT_not;
                            }
                            result = CAUGHT_not == null ? null : ValueUtil.FALSE_VALUE;
                        }
                    }
                    CAUGHT_result = result;
                }
                catch (Exception e) {
                    CAUGHT_result = ValueUtil.createInvalidValue(e);
                }
                local_0 = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(executor, TypeId.BOOLEAN, "CallExp::SafeSourceCanBeNull", this, null, diagnostics, context, null, severity_0, CAUGHT_result, PivotTables.INT_0).booleanValue();
            }
            return local_0;
        }
        catch (Throwable e) {
            return ValueUtil.validationFailedDiagnostic("CallExp::SafeSourceCanBeNull", this, diagnostics, context, e);
        }
    }

    @Override
    public boolean validateSafeSourceCannotBeMap(DiagnosticChain diagnostics, Map<Object, Object> context) {
        @NonNull String constraintName = "CallExp::SafeSourceCannotBeMap";
        try {
            boolean local_0;
            @NonNull Executor executor = PivotUtil.getExecutor(this, context);
            @NonNull IdResolver idResolver = executor.getIdResolver();
            @NonNull IntegerValue severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(executor, (Object)PivotPackage.Literals.CALL_EXP___VALIDATE_SAFE_SOURCE_CANNOT_BE_MAP__DIAGNOSTICCHAIN_MAP);
            boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(executor, (Object)severity_0, (Object)PivotTables.INT_0);
            if (le) {
                local_0 = true;
            } else {
                boolean logDiagnostic;
                Serializable CAUGHT_result;
                try {
                    Boolean result;
                    boolean isSafe = this.isIsSafe();
                    if (!isSafe) {
                        result = ValueUtil.TRUE_VALUE;
                    } else {
                        Serializable CAUGHT_implies;
                        try {
                            Boolean implies;
                            Serializable CAUGHT_ne;
                            InvalidValueException CAUGHT_safe_type_source;
                            try {
                                Type safe_type_source;
                                @Nullable OCLExpression ownedSource = this.getOwnedSource();
                                @NonNull Boolean type = ownedSource == null;
                                if (type == Boolean.TRUE) {
                                    safe_type_source = null;
                                } else {
                                    Type type_0;
                                    assert (ownedSource != null);
                                    safe_type_source = type_0 = ownedSource.getType();
                                }
                                CAUGHT_safe_type_source = safe_type_source;
                            }
                            catch (Exception e) {
                                CAUGHT_safe_type_source = ValueUtil.createInvalidValue(e);
                            }
                            try {
                                if (CAUGHT_safe_type_source instanceof InvalidValueException) {
                                    throw CAUGHT_safe_type_source;
                                }
                                boolean ne = CAUGHT_safe_type_source != null;
                                CAUGHT_ne = Boolean.valueOf(ne);
                            }
                            catch (Exception e) {
                                CAUGHT_ne = ValueUtil.createInvalidValue(e);
                            }
                            if (CAUGHT_ne == ValueUtil.FALSE_VALUE) {
                                implies = ValueUtil.TRUE_VALUE;
                            } else {
                                Serializable CAUGHT_not;
                                try {
                                    Serializable CAUGHT_oclIsKindOf;
                                    try {
                                        @NonNull Class TYP_MapType = idResolver.getClass(PivotTables.CLSSid_MapType, null);
                                        if (CAUGHT_safe_type_source instanceof InvalidValueException) {
                                            throw CAUGHT_safe_type_source;
                                        }
                                        boolean oclIsKindOf = OclAnyOclIsKindOfOperation.INSTANCE.evaluate(executor, (Object)CAUGHT_safe_type_source, (Object)TYP_MapType);
                                        CAUGHT_oclIsKindOf = Boolean.valueOf(oclIsKindOf);
                                    }
                                    catch (Exception e) {
                                        CAUGHT_oclIsKindOf = ValueUtil.createInvalidValue(e);
                                    }
                                    if (CAUGHT_oclIsKindOf instanceof InvalidValueException) {
                                        throw CAUGHT_oclIsKindOf;
                                    }
                                    @Nullable Boolean not = CAUGHT_oclIsKindOf == ValueUtil.FALSE_VALUE ? ValueUtil.TRUE_VALUE : (CAUGHT_oclIsKindOf == ValueUtil.TRUE_VALUE ? ValueUtil.FALSE_VALUE : null);
                                    CAUGHT_not = not;
                                }
                                catch (Exception e) {
                                    CAUGHT_not = ValueUtil.createInvalidValue(e);
                                }
                                if (CAUGHT_not == ValueUtil.TRUE_VALUE) {
                                    implies = ValueUtil.TRUE_VALUE;
                                } else {
                                    if (CAUGHT_ne instanceof InvalidValueException) {
                                        throw CAUGHT_ne;
                                    }
                                    if (CAUGHT_not instanceof InvalidValueException) {
                                        throw CAUGHT_not;
                                    }
                                    implies = CAUGHT_not == null ? null : ValueUtil.FALSE_VALUE;
                                }
                            }
                            CAUGHT_implies = implies;
                        }
                        catch (Exception e) {
                            CAUGHT_implies = ValueUtil.createInvalidValue(e);
                        }
                        if (CAUGHT_implies == ValueUtil.TRUE_VALUE) {
                            result = ValueUtil.TRUE_VALUE;
                        } else {
                            if (CAUGHT_implies instanceof InvalidValueException) {
                                throw CAUGHT_implies;
                            }
                            result = CAUGHT_implies == null ? null : ValueUtil.FALSE_VALUE;
                        }
                    }
                    CAUGHT_result = result;
                }
                catch (Exception e) {
                    CAUGHT_result = ValueUtil.createInvalidValue(e);
                }
                local_0 = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(executor, TypeId.BOOLEAN, "CallExp::SafeSourceCannotBeMap", this, null, diagnostics, context, null, severity_0, CAUGHT_result, PivotTables.INT_0).booleanValue();
            }
            return local_0;
        }
        catch (Throwable e) {
            return ValueUtil.validationFailedDiagnostic("CallExp::SafeSourceCannotBeMap", this, diagnostics, context, e);
        }
    }

    @Override
    public boolean validateTypeIsNotInvalid(DiagnosticChain diagnostics, Map<Object, Object> context) {
        @NonNull String constraintName = "CallExp::TypeIsNotInvalid";
        try {
            boolean local_0;
            @NonNull Executor executor = PivotUtil.getExecutor(this, context);
            @NonNull IdResolver idResolver = executor.getIdResolver();
            @NonNull IntegerValue severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(executor, (Object)PivotPackage.Literals.CALL_EXP___VALIDATE_TYPE_IS_NOT_INVALID__DIAGNOSTICCHAIN_MAP);
            boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(executor, (Object)severity_0, (Object)PivotTables.INT_0);
            if (le) {
                local_0 = true;
            } else {
                boolean logDiagnostic;
                @NonNull Class TYP_OclInvalid = idResolver.getClass(TypeId.OCL_INVALID, null);
                @Nullable Type type = this.getType();
                boolean result = type != null ? type.getTypeId() != TYP_OclInvalid.getTypeId() : true;
                local_0 = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(executor, TypeId.BOOLEAN, "CallExp::TypeIsNotInvalid", this, null, diagnostics, context, null, severity_0, result, PivotTables.INT_0).booleanValue();
            }
            return local_0;
        }
        catch (Throwable e) {
            return ValueUtil.validationFailedDiagnostic("CallExp::TypeIsNotInvalid", this, diagnostics, context, e);
        }
    }

    @Override
    public void setIsImplicit(boolean newIsImplicit) {
        boolean oldIsImplicit;
        boolean bl = oldIsImplicit = (this.eFlags & 0x200) != 0;
        this.eFlags = newIsImplicit ? (this.eFlags |= 0x200) : (this.eFlags &= 0xFFFFFDFF);
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, oldIsImplicit, newIsImplicit));
        }
    }

    @Override
    public boolean isIsSafe() {
        return (this.eFlags & 0x400) != 0;
    }

    @Override
    public void setIsSafe(boolean newIsSafe) {
        boolean oldIsSafe;
        boolean bl = oldIsSafe = (this.eFlags & 0x400) != 0;
        this.eFlags = newIsSafe ? (this.eFlags |= 0x400) : (this.eFlags &= 0xFFFFFBFF);
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, oldIsSafe, newIsSafe));
        }
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getAnnotatingComments()).basicRemove((Object)otherEnd, msgs);
            }
            case 1: {
                return ((InternalEList)this.getOwnedAnnotations()).basicRemove((Object)otherEnd, msgs);
            }
            case 2: {
                return ((InternalEList)this.getOwnedComments()).basicRemove((Object)otherEnd, msgs);
            }
            case 3: {
                return ((InternalEList)this.getOwnedExtensions()).basicRemove((Object)otherEnd, msgs);
            }
            case 11: {
                return this.basicSetOwnedSource(null, msgs);
            }
        }
        return this.eDynamicInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getAnnotatingComments();
            }
            case 1: {
                return this.getOwnedAnnotations();
            }
            case 2: {
                return this.getOwnedComments();
            }
            case 3: {
                return this.getOwnedExtensions();
            }
            case 4: {
                return this.getName();
            }
            case 5: {
                return this.isIsMany();
            }
            case 6: {
                return this.isIsRequired();
            }
            case 7: {
                if (resolve) {
                    return this.getType();
                }
                return this.basicGetType();
            }
            case 8: {
                return this.getTypeValue();
            }
            case 9: {
                return this.isIsImplicit();
            }
            case 10: {
                return this.isIsSafe();
            }
            case 11: {
                return this.getOwnedSource();
            }
        }
        return this.eDynamicGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getAnnotatingComments().clear();
                this.getAnnotatingComments().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.getOwnedAnnotations().clear();
                this.getOwnedAnnotations().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getOwnedComments().clear();
                this.getOwnedComments().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getOwnedExtensions().clear();
                this.getOwnedExtensions().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.setName((String)newValue);
                return;
            }
            case 6: {
                this.setIsRequired((Boolean)newValue);
                return;
            }
            case 7: {
                this.setType((Type)newValue);
                return;
            }
            case 8: {
                this.setTypeValue((Type)newValue);
                return;
            }
            case 9: {
                this.setIsImplicit((Boolean)newValue);
                return;
            }
            case 10: {
                this.setIsSafe((Boolean)newValue);
                return;
            }
            case 11: {
                this.setOwnedSource((OCLExpression)newValue);
                return;
            }
        }
        this.eDynamicSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getAnnotatingComments().clear();
                return;
            }
            case 1: {
                this.getOwnedAnnotations().clear();
                return;
            }
            case 2: {
                this.getOwnedComments().clear();
                return;
            }
            case 3: {
                this.getOwnedExtensions().clear();
                return;
            }
            case 4: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 6: {
                this.setIsRequired(true);
                return;
            }
            case 7: {
                this.setType(null);
                return;
            }
            case 8: {
                this.setTypeValue(null);
                return;
            }
            case 9: {
                this.setIsImplicit(false);
                return;
            }
            case 10: {
                this.setIsSafe(false);
                return;
            }
            case 11: {
                this.setOwnedSource(null);
                return;
            }
        }
        this.eDynamicUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.annotatingComments != null && !this.annotatingComments.isEmpty();
            }
            case 1: {
                return this.ownedAnnotations != null && !this.ownedAnnotations.isEmpty();
            }
            case 2: {
                return this.ownedComments != null && !this.ownedComments.isEmpty();
            }
            case 3: {
                return this.ownedExtensions != null && !this.ownedExtensions.isEmpty();
            }
            case 4: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 5: {
                return this.isIsMany();
            }
            case 6: {
                return (this.eFlags & 0x100) == 0;
            }
            case 7: {
                return this.type != null;
            }
            case 8: {
                return this.typeValue != null;
            }
            case 9: {
                return (this.eFlags & 0x200) != 0;
            }
            case 10: {
                return (this.eFlags & 0x400) != 0;
            }
            case 11: {
                return this.ownedSource != null;
            }
        }
        return this.eDynamicIsSet(featureID);
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                return this.allOwnedElements();
            }
            case 1: {
                return this.getValue((Type)arguments.get(0), (String)arguments.get(1));
            }
            case 2: {
                return this.CompatibleBody((ValueSpecification)arguments.get(0));
            }
            case 3: {
                return this.isNonNull();
            }
            case 4: {
                return this.isNull();
            }
            case 5: {
                return this.validateTypeIsNotNull((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 6: {
                return this.validateSafeSourceCanBeNull((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 7: {
                return this.validateSafeSourceCannotBeMap((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 8: {
                return this.validateTypeIsNotInvalid((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
        }
        return this.eDynamicInvoke(operationID, arguments);
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public <R> R accept(@NonNull Visitor<R> visitor) {
        return visitor.visitCallExp(this);
    }
}

