/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.launcher.debug.model;

import fr.inria.aoste.timesquare.launcher.debug.model.CCSLProcess;
import fr.inria.aoste.timesquare.launcher.debug.model.ISimulationInterface;
import fr.inria.aoste.timesquare.launcher.debug.model.ThreadInterface;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;

public final class CCSLNormalThread
implements Runnable,
ThreadInterface {
    private int exitValue = 1;
    private ISimulationInterface sim;
    private CCSLProcess process;

    public CCSLNormalThread(ISimulationInterface sim, CCSLProcess process) {
        assert (sim != null);
        this.sim = sim;
        this.process = process;
    }

    @Override
    public ISimulationInterface getSim() {
        return this.sim;
    }

    @Override
    public int getExitValue() {
        return this.exitValue;
    }

    @Override
    public boolean isTerminated() {
        return this.sim.isTerminated();
    }

    @Override
    public void run() {
        try {
            this.exitValue = 0;
            this.sim.init();
            while (!this.sim.isTerminated()) {
                this.sim.step(true);
                Thread.yield();
            }
            this.sim.finish();
        }
        catch (Throwable ce) {
            System.err.println("CCSL Thread abnormal ending " + ce);
            ce.printStackTrace(System.err);
            this.exitValue = -1;
        }
        try {
            this.process.disconnect();
        }
        catch (DebugException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void terminate() throws DebugException {
        this.sim.finish();
        IWorkspaceRoot iw = ResourcesPlugin.getWorkspace().getRoot();
        try {
            iw.refreshLocal(2, null);
            if (iw.getProject() != null) {
                iw.getProject().refreshLocal(2, null);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.process.disconnect();
    }
}

