/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.launcher.debug.model.output;

import fr.inria.aoste.timesquare.launcher.debug.model.output.ICCSLModelTab;
import fr.inria.aoste.timesquare.launcher.extensionpoint.IOutputOption;
import fr.inria.aoste.timesquare.utils.pluginhelpers.PluginHelpers;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public abstract class OutputSetupOption {
    private static final String GROUP2 = "@group";
    private static final String ASK = "@ask";
    private static final String COLLAPSE_BUTTON = "@collapseButton";
    private static final String COMPOSITE = "@composite";
    public static final Class<OutputSetupOption> CLASS = OutputSetupOption.class;
    private Class<? extends IOutputOption> classoption = null;
    private String key;
    private ICCSLModelTab modelSimulationTab;
    private Composite _c;
    private Button b;
    String name = "";
    String ask = "";
    private static final int CONTROL_OFFSET = 3;
    Group group = null;
    Button collapseButton = null;
    Label textinfo = null;

    protected OutputSetupOption(String key, String name, Class<? extends IOutputOption> classoption) {
        this.key = key;
        this.name = name;
        this.classoption = classoption;
        this.ask = "activate " + name;
    }

    public static <T extends Widget> T registerID(T w, String id) {
        if (id != null && id.length() != 0) {
            w.setData(PluginHelpers.IDENTIFIER_WIDGET, (Object)id);
        }
        return w;
    }

    public <T extends Widget> T register(T w, String id) {
        if (id != null && id.length() != 0) {
            OutputSetupOption.registerID(w, String.valueOf(this.getKey()) + id);
        }
        return w;
    }

    public final String getKey() {
        return this.key;
    }

    private void initMeta(Composite c, Button b) {
        this._c = c;
        this.b = b;
        if (b != null) {
            b.addSelectionListener((SelectionListener)new SelectionMetaActive(this));
        }
    }

    public final String getName() {
        return this.name;
    }

    public final String getAsk() {
        return this.ask;
    }

    public Group initMeta(ICCSLModelTab modelSimulationTab, Composite _parent) {
        this.modelSimulationTab = modelSimulationTab;
        this.group = new Group(_parent, 16);
        this.register(this.group, GROUP2);
        FormLayout layout = new FormLayout();
        this.group.setLayout((Layout)layout);
        this.group.setText(this.name);
        Composite info = new Composite((Composite)this.group, 16);
        Button askb = modelSimulationTab.createCheckButton(info, this.ask);
        askb.pack();
        this.register(askb, ASK);
        this.textinfo = new Label(info, 16);
        info.setLayout((Layout)new GridLayout(1, false));
        this.collapseButton = new Button((Composite)this.group, 1028);
        this.register(this.collapseButton, COLLAPSE_BUTTON);
        Group c2 = new Group((Composite)this.group, 0);
        c2.setLayout((Layout)new GridLayout(1, false));
        this.register(c2, COMPOSITE);
        FormData data4 = new FormData();
        data4.left = new FormAttachment(0, 3);
        data4.bottom = new FormAttachment((Control)c2, -3);
        data4.width = 30;
        data4.height = 20;
        this.collapseButton.setLayoutData((Object)data4);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 3);
        data.left = new FormAttachment((Control)this.collapseButton, 3);
        data.right = new FormAttachment(100, -3);
        info.setLayoutData((Object)data);
        FormData data5 = new FormData();
        data5.top = new FormAttachment((Control)info, 3);
        data5.height = 1;
        data5.left = new FormAttachment(0, 3);
        data5.right = new FormAttachment(100, -3);
        data5.bottom = new FormAttachment(100, -3);
        askb.setSelection(true);
        this.initMeta((Composite)c2, askb);
        c2.setLayoutData((Object)data5);
        this.createControl((Composite)c2);
        c2.setLayoutData((Object)data5);
        CollapseButtonListener cbl = new CollapseButtonListener(this.collapseButton, (Composite)c2, (Composite)this.group, data5);
        this.collapseButton.addSelectionListener((SelectionListener)cbl);
        c2.setVisible(false);
        return this.group;
    }

    public final boolean isValid(IOutputOption configuration) {
        if (this.classoption != null && configuration != null && this.classoption.isAssignableFrom(configuration.getClass())) {
            return this._isValid(configuration);
        }
        return false;
    }

    public final void setDefaults(IOutputOption configuration) {
        if (this.classoption != null && configuration != null && this.classoption.isAssignableFrom(configuration.getClass())) {
            this._setDefaults(configuration);
        }
    }

    public final void initializeFrom(IOutputOption configuration) {
        if (this.classoption != null && configuration != null && this.classoption.isAssignableFrom(configuration.getClass())) {
            boolean bol = configuration.isActivable();
            if (!bol) {
                this.activeCheck(false);
                this.b.setEnabled(false);
            } else {
                this.b.setEnabled(true);
                this.activeCheck(configuration.isActive());
            }
            this._initializeFrom(configuration);
        }
    }

    public final void performApply(IOutputOption configuration) {
        if (this.classoption != null && configuration != null && this.classoption.isAssignableFrom(configuration.getClass())) {
            boolean bol = configuration.isActivable();
            if (!bol) {
                this.activeCheck(false);
                this.b.setEnabled(false);
            } else {
                this.b.setEnabled(true);
                this.activeCheck(configuration.isActive());
            }
            this._performApply(configuration);
        }
    }

    protected final boolean _isValid(IOutputOption configuration) {
        if (configuration.isActivable()) {
            String errorMessage;
            if (configuration.isActive() && (errorMessage = configuration.validate()) != null) {
                this.modelSimulationTab.setErrorMessage(errorMessage);
                this.textinfo.setText(errorMessage);
                this.textinfo.setForeground(new Color(null, 255, 0, 0));
                return false;
            }
            this.textinfo.setText("");
        } else {
            this.textinfo.setForeground(new Color(null, 255, 125, 0));
            this.textinfo.setText("Inactivable : " + configuration.getActivableMessage());
        }
        return true;
    }

    protected void _setDefaults(IOutputOption configuration) {
    }

    protected void _initializeFrom(IOutputOption configuration) {
        this.setSelected(configuration.isActive());
    }

    protected void _performApply(IOutputOption configuration) {
        configuration.setActive(this.isSelected());
    }

    protected void createControl(Composite parent) {
    }

    public final boolean isSelected() {
        return this.b.getSelection();
    }

    public final void setSelected(boolean sel) {
        this.activeCheck(sel);
        this.b.setSelection(sel);
    }

    private int activeCheck(boolean bol) {
        this.recurviceActive((Control)this._c, bol);
        return 0;
    }

    private int recurviceActive(Control ctl, boolean bol) {
        ctl.setEnabled(bol);
        if (ctl instanceof Composite) {
            Control[] controlArray = ((Composite)ctl).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control ctl2 = controlArray[n2];
                this.recurviceActive(ctl2, bol);
                ++n2;
            }
        }
        return 0;
    }

    public int activeCheck() {
        this.activeCheck(this.b.getSelection());
        return 0;
    }

    public void notifyChange() {
        this.modelSimulationTab.updateLaunchConfigurationDialog(this);
    }

    public void dispose() {
    }

    public static class CollapseButtonListener
    implements SelectionListener {
        private Composite _subcomposite;
        private Composite _container;
        private FormData _formdata;
        private Button button;

        public CollapseButtonListener(Button b, Composite timeNotesBox, Composite container, FormData formdata) {
            this._subcomposite = timeNotesBox;
            this._container = container;
            this._formdata = formdata;
            this.button = b;
        }

        public void handleEvent() {
            if (this._subcomposite.getVisible()) {
                this._subcomposite.setSize(this._subcomposite.computeSize(1, 1));
                this._formdata.height = 1;
                this._subcomposite.setLayoutData((Object)this._formdata);
                this._subcomposite.setVisible(false);
                this._subcomposite.pack(true);
                this.button.setAlignment(1024);
            } else {
                this._subcomposite.setSize(this._subcomposite.computeSize(-1, -1));
                this._formdata.height = -1;
                this._subcomposite.setLayoutData((Object)this._formdata);
                this._subcomposite.setVisible(true);
                this._subcomposite.pack(true);
                this.button.setAlignment(128);
            }
            this._container.pack(true);
            this._container.layout();
            Composite tmp = this._container.getParent();
            tmp.pack(true);
            tmp.layout();
            ((ScrolledComposite)tmp.getParent()).setShowFocusedControl(true);
            ((ScrolledComposite)tmp.getParent()).layout();
        }

        public void widgetSelected(SelectionEvent e) {
            this.handleEvent();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.handleEvent();
        }
    }

    private static class SelectionMetaActive
    extends SelectionAdapter {
        OutputSetupOption oso;

        public SelectionMetaActive(OutputSetupOption cin) {
            this.oso = cin;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            this.oso.modelSimulationTab.updateLaunchConfigurationDialog(this.oso);
            this.oso.activeCheck();
        }
    }
}

