/**
 * ---------------------------------------------------------------------------------------------
 * Copyright (c) 2020 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * --------------------------------------------------------------------------------------------
 */
package org.eclipse.gemoc.protocols.eaop.api.data;

import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

/**
 * Information about the Execution Engine.
 */
@SuppressWarnings("all")
public class ExecutionEngineDto {
  /**
   * The engine kind name.
   */
  private String engineKindName;

  /**
   * The engine name.
   */
  private String engineName;

  /**
   * The engine kind name.
   */
  @Pure
  public String getEngineKindName() {
    return this.engineKindName;
  }

  /**
   * The engine kind name.
   */
  public void setEngineKindName(final String engineKindName) {
    this.engineKindName = engineKindName;
  }

  /**
   * The engine name.
   */
  @Pure
  public String getEngineName() {
    return this.engineName;
  }

  /**
   * The engine name.
   */
  public void setEngineName(final String engineName) {
    this.engineName = engineName;
  }

  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("engineKindName", this.engineKindName);
    b.add("engineName", this.engineName);
    return b.toString();
  }

  @Override
  @Pure
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    ExecutionEngineDto other = (ExecutionEngineDto) obj;
    if (this.engineKindName == null) {
      if (other.engineKindName != null)
        return false;
    } else if (!this.engineKindName.equals(other.engineKindName))
      return false;
    if (this.engineName == null) {
      if (other.engineName != null)
        return false;
    } else if (!this.engineName.equals(other.engineName))
      return false;
    return true;
  }

  @Override
  @Pure
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((this.engineKindName== null) ? 0 : this.engineKindName.hashCode());
    return prime * result + ((this.engineName== null) ? 0 : this.engineName.hashCode());
  }
}
