/**
 * ---------------------------------------------------------------------------------------------
 * Copyright (c) 2020 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * --------------------------------------------------------------------------------------------
 */
package org.eclipse.gemoc.protocols.eaop.api.data;

import java.util.Arrays;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

/**
 * Information about a State. NOTE: version working as diff between previous steps (StartedStep) / next steps (EndedSteps)
 */
@SuppressWarnings("all")
public class StateDto {
  private StateValueDto[] changedValues;

  /**
   * List of ID (or URI) of the steps that have this state as StartingState
   */
  private String[] startedStepsID;

  /**
   * List of ID (or URI) of the steps that have this state as EndingState
   */
  private String[] endedStepsID;

  @Pure
  public StateValueDto[] getChangedValues() {
    return this.changedValues;
  }

  public void setChangedValues(final StateValueDto[] changedValues) {
    this.changedValues = changedValues;
  }

  /**
   * List of ID (or URI) of the steps that have this state as StartingState
   */
  @Pure
  public String[] getStartedStepsID() {
    return this.startedStepsID;
  }

  /**
   * List of ID (or URI) of the steps that have this state as StartingState
   */
  public void setStartedStepsID(final String[] startedStepsID) {
    this.startedStepsID = startedStepsID;
  }

  /**
   * List of ID (or URI) of the steps that have this state as EndingState
   */
  @Pure
  public String[] getEndedStepsID() {
    return this.endedStepsID;
  }

  /**
   * List of ID (or URI) of the steps that have this state as EndingState
   */
  public void setEndedStepsID(final String[] endedStepsID) {
    this.endedStepsID = endedStepsID;
  }

  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("changedValues", this.changedValues);
    b.add("startedStepsID", this.startedStepsID);
    b.add("endedStepsID", this.endedStepsID);
    return b.toString();
  }

  @Override
  @Pure
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    StateDto other = (StateDto) obj;
    if (this.changedValues == null) {
      if (other.changedValues != null)
        return false;
    } else if (!Arrays.deepEquals(this.changedValues, other.changedValues))
      return false;
    if (this.startedStepsID == null) {
      if (other.startedStepsID != null)
        return false;
    } else if (!Arrays.deepEquals(this.startedStepsID, other.startedStepsID))
      return false;
    if (this.endedStepsID == null) {
      if (other.endedStepsID != null)
        return false;
    } else if (!Arrays.deepEquals(this.endedStepsID, other.endedStepsID))
      return false;
    return true;
  }

  @Override
  @Pure
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((this.changedValues== null) ? 0 : Arrays.deepHashCode(this.changedValues));
    result = prime * result + ((this.startedStepsID== null) ? 0 : Arrays.deepHashCode(this.startedStepsID));
    return prime * result + ((this.endedStepsID== null) ? 0 : Arrays.deepHashCode(this.endedStepsID));
  }
}
