/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.componentization.mappings;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.SessionManagerListener;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramDescriptionMappingsManager;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramDescriptionMappingsRegistry;
import org.eclipse.sirius.diagram.business.internal.componentization.mappings.DiagramDescriptionMappingsManagerImpl;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public final class DiagramDescriptionMappingsRegistryImpl
implements DiagramDescriptionMappingsRegistry {
    private final Map<Key, DiagramDescriptionMappingsManager> diagramDescriptionMappingsManagers = new HashMap<Key, DiagramDescriptionMappingsManager>();

    private DiagramDescriptionMappingsRegistryImpl() {
        SessionManager.INSTANCE.addSessionsListener((SessionManagerListener)new SessionManagerListener.Stub(){

            public void notifyRemoveSession(Session removedSession) {
                DiagramDescriptionMappingsRegistryImpl.this.cleanDiagramDescriptionMappingsManagers(removedSession);
            }

            public void viewpointDeselected(Viewpoint deselectedSirius) {
                DiagramDescriptionMappingsRegistryImpl.this.computeMappings();
            }

            public void viewpointSelected(Viewpoint selectedSirius) {
                DiagramDescriptionMappingsRegistryImpl.this.computeMappings();
            }

            public void notify(Session closingSession, int notification) {
                if (notification == 8) {
                    DiagramDescriptionMappingsRegistryImpl.this.cleanDiagramDescriptionMappingsManagers(closingSession);
                }
            }
        });
    }

    public static DiagramDescriptionMappingsRegistry init() {
        return new DiagramDescriptionMappingsRegistryImpl();
    }

    @Override
    public DiagramDescriptionMappingsManager getDiagramDescriptionMappingsManager(Session session, DiagramDescription description) {
        Key key = new Key(session, description);
        if (this.diagramDescriptionMappingsManagers.containsKey(key)) {
            return this.diagramDescriptionMappingsManagers.get(key);
        }
        DiagramDescriptionMappingsManagerImpl newManager = new DiagramDescriptionMappingsManagerImpl(description);
        this.diagramDescriptionMappingsManagers.put(key, newManager);
        if (session != null) {
            newManager.computeMappings(session.getSelectedViewpoints(false));
        } else {
            newManager.computeMappings(null);
        }
        return newManager;
    }

    @Override
    public void computeMappings() {
        this.cleanDiagramDescriptionNoMoreInResource();
        for (Map.Entry<Key, DiagramDescriptionMappingsManager> manager : this.diagramDescriptionMappingsManagers.entrySet()) {
            if (manager.getKey().session != null) {
                manager.getValue().computeMappings(manager.getKey().session.getSelectedViewpoints(false));
                continue;
            }
            manager.getValue().computeMappings(null);
        }
    }

    private void cleanDiagramDescriptionNoMoreInResource() {
        HashSet<Key> keysToRemove = new HashSet<Key>();
        for (Key key : this.diagramDescriptionMappingsManagers.keySet()) {
            if (key.description.eResource() != null) continue;
            keysToRemove.add(key);
        }
        for (Key keyToRemove : keysToRemove) {
            DiagramDescriptionMappingsManager manager = this.diagramDescriptionMappingsManagers.get(keyToRemove);
            this.diagramDescriptionMappingsManagers.remove(keyToRemove);
            manager.dispose();
        }
    }

    private void cleanDiagramDescriptionMappingsManagers(Session session) {
        HashSet<Key> keysToRemove = new HashSet<Key>();
        for (Key key : this.diagramDescriptionMappingsManagers.keySet()) {
            if (key.session != session) continue;
            keysToRemove.add(key);
        }
        for (Key keyToRemove : keysToRemove) {
            DiagramDescriptionMappingsManager manager = this.diagramDescriptionMappingsManagers.get(keyToRemove);
            this.diagramDescriptionMappingsManagers.remove(keyToRemove);
            manager.dispose();
        }
    }

    private class Key {
        private final Session session;
        private final DiagramDescription description;

        Key(Session session, DiagramDescription description) {
            this.session = session;
            this.description = description;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + DiagramDescriptionMappingsRegistryImpl.this.hashCode();
            result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
            result = 31 * result + (this.session == null ? 0 : this.session.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            return this.description == other.description && this.session == other.session;
        }
    }
}

