/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.commons.eclipse.messagingsystem.ui.internal.console;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.ui.internal.console.message.ConsoleMessage;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.ui.internal.console.message.InfoMessage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.console.IOConsoleOutputStream;

public abstract class ConsoleIO {
    protected OutputStream outputStream = null;
    protected BufferedReader reader;

    public abstract OutputStream getOutputStream();

    public abstract BufferedReader getReader();

    public void print(Object o) {
        if (o != null) {
            this.print(new InfoMessage(o.toString()));
        }
    }

    public void println(Object o) {
        if (o != null) {
            this.println(new InfoMessage(o.toString()));
        }
    }

    public abstract void print(ConsoleMessage var1);

    public abstract void changeColor(Color var1);

    public abstract void changeStyle(Color var1, int var2);

    public abstract void changeFontStyle(int var1);

    public abstract void println(ConsoleMessage var1);

    public String read() {
        String line = "";
        BufferedReader reader = this.getReader();
        try {
            line = reader.readLine();
            if (line == null) {
                line = "";
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        return line;
    }

    public String promptAndRead(String prompt) {
        this.print(prompt);
        return this.read();
    }

    public void clear() {
    }

    public void dispose() {
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    public void finalize() throws Throwable {
        super.finalize();
        if (this.outputStream != null && !((IOConsoleOutputStream)this.getOutputStream()).isClosed()) {
            this.outputStream.close();
        }
    }
}

