/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.xdsmlframework.api.extensions.metaprog;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gemoc.dsl.Entry;
import org.eclipse.gemoc.xdsmlframework.api.extensions.metaprog.ILanguageComponentValidator;
import org.eclipse.gemoc.xdsmlframework.api.extensions.metaprog.Message;
import org.eclipse.gemoc.xdsmlframework.api.extensions.metaprog.Severity;

public class EcoreRule
implements ILanguageComponentValidator {
    @Override
    public Message validate(Entry entry) {
        if ("ecore".matches(entry.getKey())) {
            URI uri = URI.createURI((String)entry.getValue());
            if (!uri.isPlatformResource() && !uri.isPlatformPlugin()) {
                return new Message("File for \"ecore\" entry not in the workspace", Severity.ERROR);
            }
            ResourceSetImpl rs = new ResourceSetImpl();
            try {
                Resource res = rs.getResource(uri, true);
                TreeIterator tree = res.getAllContents();
                Boolean hasModel = false;
                EList classes = new ArrayList();
                while (tree.hasNext()) {
                    EObject node = (EObject)tree.next();
                    if (!(node instanceof EPackage)) continue;
                    hasModel = hasModel == false;
                    EPackage node2 = (EPackage)node;
                    classes = node2.getEClassifiers();
                }
                if (!hasModel.booleanValue()) {
                    return new Message("The ecore file does not contain an ecore model", Severity.WARNING);
                }
                if (classes.isEmpty()) {
                    return new Message("No classes in the ecore file", Severity.WARNING);
                }
            }
            catch (RuntimeException e) {
                return new Message("The file for the \"ecore\" entry does not exist", Severity.ERROR);
            }
        }
        return new Message("", Severity.DEFAULT);
    }
}

