/**
 * Copyright (c) 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package fr.inria.diverse.melange.processors;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import fr.inria.diverse.melange.metamodel.melange.Import;
import fr.inria.diverse.melange.metamodel.melange.ImportDsl;
import fr.inria.diverse.melange.metamodel.melange.MelangeFactory;
import fr.inria.diverse.melange.metamodel.melange.Operator;
import fr.inria.diverse.melange.metamodel.melange.Weave;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gemoc.dsl.Dsl;
import org.eclipse.gemoc.dsl.Entry;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeReferenceBuilder;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * Initialise the wrapping Language with informations from the Dsl file
 */
@SuppressWarnings("all")
public class ImportDslProcessor extends DispatchMelangeProcessor {
  @Inject
  private JvmTypeReferenceBuilder.Factory builderFactory;

  protected void _preProcess(final ImportDsl language, final boolean isPreLinkingPhase) {
    final Dsl dsl = language.getDsl();
    EList<Entry> _entries = null;
    if (dsl!=null) {
      _entries=dsl.getEntries();
    }
    Iterable<Entry> _filter = null;
    if (_entries!=null) {
      final Function1<Entry, Boolean> _function = (Entry entry) -> {
        String _key = entry.getKey();
        return Boolean.valueOf(Objects.equal(_key, "ecore"));
      };
      _filter=IterableExtensions.<Entry>filter(_entries, _function);
    }
    Entry _head = null;
    if (_filter!=null) {
      _head=IterableExtensions.<Entry>head(_filter);
    }
    String _value = null;
    if (_head!=null) {
      _value=_head.getValue();
    }
    String[] _split = null;
    if (_value!=null) {
      _split=_value.split(",");
    }
    List<String> _map = null;
    if (((List<String>)Conversions.doWrapArray(_split))!=null) {
      final Function1<String, String> _function_1 = (String uri) -> {
        return uri.trim();
      };
      _map=ListExtensions.<String, String>map(((List<String>)Conversions.doWrapArray(_split)), _function_1);
    }
    final List<String> ecoreUris = _map;
    EList<Entry> _entries_1 = null;
    if (dsl!=null) {
      _entries_1=dsl.getEntries();
    }
    Iterable<Entry> _filter_1 = null;
    if (_entries_1!=null) {
      final Function1<Entry, Boolean> _function_2 = (Entry entry) -> {
        String _key = entry.getKey();
        return Boolean.valueOf(Objects.equal(_key, "k3"));
      };
      _filter_1=IterableExtensions.<Entry>filter(_entries_1, _function_2);
    }
    Entry _head_1 = null;
    if (_filter_1!=null) {
      _head_1=IterableExtensions.<Entry>head(_filter_1);
    }
    String _value_1 = null;
    if (_head_1!=null) {
      _value_1=_head_1.getValue();
    }
    String[] _split_1 = null;
    if (_value_1!=null) {
      _split_1=_value_1.split(",");
    }
    List<String> _map_1 = null;
    if (((List<String>)Conversions.doWrapArray(_split_1))!=null) {
      final Function1<String, String> _function_3 = (String uri) -> {
        return uri.trim();
      };
      _map_1=ListExtensions.<String, String>map(((List<String>)Conversions.doWrapArray(_split_1)), _function_3);
    }
    final List<String> aspects = _map_1;
    language.setName(dsl.getName());
    if (ecoreUris!=null) {
      final Consumer<String> _function_4 = (String uri) -> {
        EList<Operator> _operators = language.getOperators();
        Import _createImport = MelangeFactory.eINSTANCE.createImport();
        final Procedure1<Import> _function_5 = (Import it) -> {
          it.setEcoreUri(uri);
        };
        Import _doubleArrow = ObjectExtensions.<Import>operator_doubleArrow(_createImport, _function_5);
        _operators.add(_doubleArrow);
      };
      ecoreUris.forEach(_function_4);
    }
    final JvmTypeReferenceBuilder typeRefBuilder = this.builderFactory.create(language.eResource().getResourceSet());
    if (aspects!=null) {
      final Consumer<String> _function_5 = (String aspectClassName) -> {
        EList<Operator> _operators = language.getOperators();
        Weave _createWeave = MelangeFactory.eINSTANCE.createWeave();
        final Procedure1<Weave> _function_6 = (Weave it) -> {
          it.setAspectTypeRef(typeRefBuilder.typeRef(aspectClassName));
        };
        Weave _doubleArrow = ObjectExtensions.<Weave>operator_doubleArrow(_createWeave, _function_6);
        _operators.add(_doubleArrow);
      };
      aspects.forEach(_function_5);
    }
  }

  public void preProcess(final EObject language, final boolean isPreLinkingPhase) {
    if (language instanceof ImportDsl) {
      _preProcess((ImportDsl)language, isPreLinkingPhase);
      return;
    } else if (language != null) {
      _preProcess(language, isPreLinkingPhase);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(language, isPreLinkingPhase).toString());
    }
  }
}
