/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.dsl.debug.ide;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.gemoc.dsl.debug.DebugTarget;
import org.eclipse.gemoc.dsl.debug.StackFrame;
import org.eclipse.gemoc.dsl.debug.Thread;
import org.eclipse.gemoc.dsl.debug.Variable;
import org.eclipse.gemoc.dsl.debug.ide.IModelUpdater;
import org.eclipse.gemoc.dsl.debug.ide.adapter.DSLDebugTargetAdapter;
import org.eclipse.gemoc.dsl.debug.ide.adapter.DSLStackFrameAdapter;
import org.eclipse.gemoc.dsl.debug.ide.adapter.DSLThreadAdapter;
import org.eclipse.gemoc.dsl.debug.ide.adapter.DSLVariableAdapter;
import org.eclipse.gemoc.dsl.debug.ide.adapter.value.DSLArrayValue;
import org.eclipse.gemoc.dsl.debug.ide.adapter.value.DSLBooleanArrayValue;
import org.eclipse.gemoc.dsl.debug.ide.adapter.value.DSLByteArrayValue;
import org.eclipse.gemoc.dsl.debug.ide.adapter.value.DSLCharArrayValue;
import org.eclipse.gemoc.dsl.debug.ide.adapter.value.DSLDoubleArrayValue;
import org.eclipse.gemoc.dsl.debug.ide.adapter.value.DSLEObjectValueAdapter;
import org.eclipse.gemoc.dsl.debug.ide.adapter.value.DSLFloatArrayValue;
import org.eclipse.gemoc.dsl.debug.ide.adapter.value.DSLIntArrayValue;
import org.eclipse.gemoc.dsl.debug.ide.adapter.value.DSLLongArrayValue;
import org.eclipse.gemoc.dsl.debug.ide.adapter.value.DSLNullValue;
import org.eclipse.gemoc.dsl.debug.ide.adapter.value.DSLObjectValue;
import org.eclipse.gemoc.dsl.debug.ide.adapter.value.DSLShortArrayValue;
import org.eclipse.gemoc.dsl.debug.ide.adapter.variable.DSLObjectVariable;
import org.eclipse.gemoc.dsl.debug.ide.event.IDSLDebugEventProcessor;
import org.eclipse.gemoc.dsl.debug.provider.DebugItemProviderAdapterFactory;
import org.eclipse.gemoc.dsl.debug.util.DebugAdapterFactory;

public class DSLEclipseDebugIntegration
extends DebugAdapterFactory {
    private static final Set<Object> SUPPORTED_TYPES = DSLEclipseDebugIntegration.initSupportedTypes();
    private final ILaunch launch;
    private final ComposedAdapterFactory genericLabelFactory;
    private final IDSLDebugEventProcessor debugger;
    private final DSLDebugTargetAdapter debugTarget;
    private final IModelUpdater modelUpdater;
    private final String identifier;

    public DSLEclipseDebugIntegration(String identifier, ILaunch launch, DebugTarget debugTarget, IModelUpdater modelUpdater, IDSLDebugEventProcessor debugger) {
        this.identifier = identifier;
        this.launch = launch;
        this.debugger = debugger;
        this.debugTarget = this.getDebugTarget(debugTarget);
        this.modelUpdater = modelUpdater;
        this.genericLabelFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.genericLabelFactory.addAdapterFactory((AdapterFactory)new DebugItemProviderAdapterFactory());
        this.genericLabelFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.genericLabelFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
    }

    private static Set<Object> initSupportedTypes() {
        HashSet<Object> res = new HashSet<Object>();
        res.add(IThread.class);
        res.add(IDebugTarget.class);
        res.add(IStackFrame.class);
        res.add(IVariable.class);
        res.add(IBreakpoint.class);
        return res;
    }

    public boolean isFactoryForType(Object object) {
        return SUPPORTED_TYPES.contains(object) || super.isFactoryForType(object);
    }

    public Adapter createDebugTargetAdapter() {
        return new DSLDebugTargetAdapter(this);
    }

    public Adapter createThreadAdapter() {
        return new DSLThreadAdapter(this);
    }

    public Adapter createStackFrameAdapter() {
        return new DSLStackFrameAdapter(this);
    }

    public Adapter createVariableAdapter() {
        return new DSLVariableAdapter(this);
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public IDSLDebugEventProcessor getDebugger() {
        return this.debugger;
    }

    public AdapterFactory getLabelFactory() {
        return this.genericLabelFactory;
    }

    public DSLDebugTargetAdapter getDebugTarget() {
        return this.debugTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DSLDebugTargetAdapter getDebugTarget(DebugTarget target) {
        DebugTarget debugTarget = target;
        synchronized (debugTarget) {
            DSLDebugTargetAdapter res = (DSLDebugTargetAdapter)this.adapt((Notifier)target, IDebugTarget.class);
            if (res == null) {
                throw new IllegalStateException("can't addapt DebugTarget to IDebugTarget.");
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DSLThreadAdapter getThread(Thread thread) {
        Thread thread2 = thread;
        synchronized (thread2) {
            DSLThreadAdapter res = (DSLThreadAdapter)this.adapt((Notifier)thread, IThread.class);
            if (res == null) {
                throw new IllegalStateException("can't addapt Thread to IThread.");
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DSLStackFrameAdapter getStackFrame(StackFrame frame) {
        StackFrame stackFrame = frame;
        synchronized (stackFrame) {
            DSLStackFrameAdapter res = (DSLStackFrameAdapter)this.adapt((Notifier)frame, IStackFrame.class);
            if (res == null) {
                throw new IllegalStateException("can't addapt StackFrame to IStackFrame.");
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DSLVariableAdapter getVariable(Variable variable) {
        Variable variable2 = variable;
        synchronized (variable2) {
            DSLVariableAdapter res = (DSLVariableAdapter)this.adapt((Notifier)variable, IVariable.class);
            if (res == null) {
                throw new IllegalStateException("can't addapt Variable to IVariable.");
            }
            return res;
        }
    }

    public IValue getValue(String referenceTypeName, Object value) {
        Object res = value instanceof EObject ? this.createEObjectValue(referenceTypeName, (EObject)value) : (value instanceof Collection ? new DSLArrayValue(this, referenceTypeName, ((Collection)value).toArray()) : (value instanceof Object[] ? new DSLArrayValue(this, referenceTypeName, (Object[])value) : (value instanceof byte[] ? this.createByteArrayValue(referenceTypeName, (byte[])value) : (value instanceof short[] ? this.createShortArrayValue(referenceTypeName, (short[])value) : (value instanceof int[] ? this.createIntegerArrayValue(referenceTypeName, (int[])value) : (value instanceof long[] ? this.createLongArrayValue(referenceTypeName, (long[])value) : (value instanceof float[] ? this.createFloatArrayValue(referenceTypeName, (float[])value) : (value instanceof double[] ? this.createDoubleArrayValue(referenceTypeName, (double[])value) : (value instanceof char[] ? this.createCharacterArrayValue(referenceTypeName, (char[])value) : (value instanceof boolean[] ? this.createBooleanArrayValue(referenceTypeName, (boolean[])value) : (value == null ? new DSLNullValue(this, referenceTypeName) : new DSLObjectValue(this, referenceTypeName, value))))))))))));
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IValue createEObjectValue(String referenceTypeName, EObject value) {
        DSLEObjectValueAdapter valueAdapter = null;
        EObject eObject = value;
        synchronized (eObject) {
            for (Adapter adapter : value.eAdapters()) {
                if (!adapter.isAdapterForType(IValue.class)) continue;
                valueAdapter = (DSLEObjectValueAdapter)adapter;
                break;
            }
            if (valueAdapter == null) {
                valueAdapter = new DSLEObjectValueAdapter(this, referenceTypeName, value);
                value.eAdapters().add((Object)valueAdapter);
            }
        }
        DSLEObjectValueAdapter res = valueAdapter;
        return res;
    }

    private IValue createByteArrayValue(String referenceTypeName, byte[] value) {
        Byte[] array = new Byte[value.length];
        int i = 0;
        while (i < value.length) {
            array[i] = value[i];
            ++i;
        }
        DSLByteArrayValue res = new DSLByteArrayValue(this, referenceTypeName, array);
        return res;
    }

    private IValue createShortArrayValue(String referenceTypeName, short[] value) {
        Short[] array = new Short[value.length];
        int i = 0;
        while (i < value.length) {
            array[i] = value[i];
            ++i;
        }
        DSLShortArrayValue res = new DSLShortArrayValue(this, referenceTypeName, array);
        return res;
    }

    private IValue createIntegerArrayValue(String referenceTypeName, int[] value) {
        Integer[] array = new Integer[value.length];
        int i = 0;
        while (i < value.length) {
            array[i] = value[i];
            ++i;
        }
        DSLIntArrayValue res = new DSLIntArrayValue(this, referenceTypeName, array);
        return res;
    }

    private IValue createLongArrayValue(String referenceTypeName, long[] value) {
        Long[] array = new Long[value.length];
        int i = 0;
        while (i < value.length) {
            array[i] = value[i];
            ++i;
        }
        DSLLongArrayValue res = new DSLLongArrayValue(this, referenceTypeName, array);
        return res;
    }

    private IValue createFloatArrayValue(String referenceTypeName, float[] value) {
        Float[] array = new Float[value.length];
        int i = 0;
        while (i < value.length) {
            array[i] = Float.valueOf(value[i]);
            ++i;
        }
        DSLFloatArrayValue res = new DSLFloatArrayValue(this, referenceTypeName, array);
        return res;
    }

    private IValue createDoubleArrayValue(String referenceTypeName, double[] value) {
        Double[] array = new Double[value.length];
        int i = 0;
        while (i < value.length) {
            array[i] = value[i];
            ++i;
        }
        DSLDoubleArrayValue res = new DSLDoubleArrayValue(this, referenceTypeName, array);
        return res;
    }

    private IValue createCharacterArrayValue(String referenceTypeName, char[] value) {
        Character[] array = new Character[value.length];
        int i = 0;
        while (i < value.length) {
            array[i] = Character.valueOf(value[i]);
            ++i;
        }
        DSLCharArrayValue res = new DSLCharArrayValue(this, referenceTypeName, array);
        return res;
    }

    private IValue createBooleanArrayValue(String referenceTypeName, boolean[] value) {
        Boolean[] array = new Boolean[value.length];
        int i = 0;
        while (i < value.length) {
            array[i] = value[i];
            ++i;
        }
        DSLBooleanArrayValue res = new DSLBooleanArrayValue(this, referenceTypeName, array);
        return res;
    }

    public IVariable getVariable(String referenceTypeName, String variableName, Object value) {
        return new DSLObjectVariable(this, referenceTypeName, variableName, value);
    }

    public IModelUpdater getModelUpdater() {
        return this.modelUpdater;
    }

    public String getModelIdentifier() {
        return this.identifier;
    }
}

