/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.expressions.operations;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.expressions.CollectionItem;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.operations.CollectionLiteralPartOperations;
import org.eclipse.ocl.util.OCLUtil;
import org.eclipse.ocl.util.TypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionItemOperations
extends CollectionLiteralPartOperations {
    protected CollectionItemOperations() {
    }

    public static <C> boolean checkItemType(CollectionItem<C> collectionItem, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        Environment env = OCLUtil.getValidationEnvironment(collectionItem, context);
        if (env != null) {
            OCLExpression<C> item = collectionItem.getItem();
            Object type = collectionItem.getType();
            if (item != null && item.getType() != null && type != null) {
                result = TypeUtil.exactTypeMatch(env, type, item.getType());
            }
        }
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.ocl.expressions", 2, EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[]{"checkItemType", EObjectValidator.getObjectLabel(collectionItem, context)}), new Object[]{collectionItem}));
        }
        return result;
    }
}

