/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.diverse.k3.al.annotationprocessor;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import fr.inria.diverse.k3.al.annotationprocessor.Composition;
import fr.inria.diverse.k3.al.annotationprocessor.Opposite;
import java.util.Collection;
import org.eclipse.xtend.lib.macro.AbstractFieldProcessor;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.AnnotationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.declaration.Visibility;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class OppositeProcessor
extends AbstractFieldProcessor {
    protected MutableTypeDeclaration containingType;
    protected MutableFieldDeclaration field;
    protected MutableTypeDeclaration oppositeType;
    protected MutableFieldDeclaration oppositeField;
    @Extension
    protected TransformationContext context;
    protected static final String GENERATED_PREFIX = "__K3_";

    public void doTransform(MutableFieldDeclaration field, TransformationContext ctx) {
        this.context = ctx;
        Functions.Function1 _function = it -> {
            AnnotationTypeDeclaration _annotationTypeDeclaration = it.getAnnotationTypeDeclaration();
            Type _type = this.context.newTypeReference(Opposite.class, new TypeReference[0]).getType();
            return Objects.equal((Object)_annotationTypeDeclaration, (Object)_type);
        };
        Object oppositeRefName = ((AnnotationReference)IterableExtensions.findFirst((Iterable)field.getAnnotations(), (Functions.Function1)_function)).getValue("value");
        boolean _isCollection = this.isCollection(field.getType());
        if (_isCollection) {
            boolean _notEquals;
            int _size = field.getType().getActualTypeArguments().size();
            boolean bl = _notEquals = _size != 1;
            if (_notEquals) {
                this.context.addError((Element)field, "Only collections with 1 type parameter are supported");
                return;
            }
            this.oppositeType = this.context.findClass(((TypeReference)IterableExtensions.head((Iterable)field.getType().getActualTypeArguments())).getName());
        } else {
            this.oppositeType = this.context.findClass(field.getType().getName());
        }
        this.field = field;
        this.containingType = field.getDeclaringType();
        Functions.Function1 _function_1 = f -> f.getSimpleName().equals(oppositeRefName);
        this.oppositeField = (MutableFieldDeclaration)IterableExtensions.findFirst((Iterable)this.oppositeType.getDeclaredFields(), (Functions.Function1)_function_1);
        boolean _check = this.check();
        if (_check) {
            this.field.setVisibility(Visibility.PRIVATE);
            this.generateInitializer();
            this.generateGetterMethod();
            this.generateSetterProxyMethod();
            this.generateResetMethod();
            this.generateSetMethod();
        }
    }

    protected void generateInitializer() {
        boolean _isCollection = this.isCollection(this.field.getType());
        if (_isCollection) {
            final String t = ((TypeReference)IterableExtensions.head((Iterable)this.field.getType().getActualTypeArguments())).getSimpleName();
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"new java.util.ArrayList<");
                    _builder.append((Object)t);
                    _builder.append((Object)">()");
                }
            };
            this.field.setInitializer(_client);
        } else {
            StringConcatenationClient _client_1 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"null");
                }
            };
            this.field.setInitializer(_client_1);
        }
    }

    protected void generateGetterMethod() {
        final String f = this.field.getSimpleName();
        boolean _isCollection = this.isCollection(this.field.getType());
        if (_isCollection) {
            Procedures.Procedure1 _function = it -> {
                it.setVisibility(Visibility.PUBLIC);
                it.setReturnType(this.context.newTypeReference(ImmutableList.class, new TypeReference[]{(TypeReference)IterableExtensions.head((Iterable)this.field.getType().getActualTypeArguments())}));
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return com.google.common.collect.ImmutableList.copyOf(");
                        _builder.append((Object)f);
                        _builder.append((Object)") ;");
                    }
                };
                it.setBody(_client);
            };
            this.containingType.addMethod(this.getGetterName(this.field), _function);
        } else {
            Procedures.Procedure1 _function_1 = it -> {
                it.setVisibility(Visibility.PUBLIC);
                it.setReturnType(this.field.getType());
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return ");
                        _builder.append((Object)f);
                        _builder.append((Object)" ;");
                    }
                };
                it.setBody(_client);
            };
            this.containingType.addMethod(this.getGetterName(this.field), _function_1);
        }
    }

    protected void generateSetterProxyMethod() {
        final String f = this.field.getSimpleName();
        final String o = this.oppositeField.getSimpleName();
        final TypeReference t = this.oppositeField.getType();
        boolean _isCollection = this.isCollection(this.field.getType());
        if (_isCollection) {
            String _firstUpper = StringExtensions.toFirstUpper((String)this.field.getSimpleName());
            String _plus = "add" + _firstUpper;
            Procedures.Procedure1 _function = it -> {
                it.setVisibility(Visibility.PUBLIC);
                it.addParameter("obj", (TypeReference)IterableExtensions.head((Iterable)this.field.getType().getActualTypeArguments()));
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"if (!");
                        _builder.append((Object)f);
                        _builder.append((Object)".contains(obj)) {");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"if (obj != null)");
                        _builder.newLine();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"obj.");
                        _builder.append((Object)OppositeProcessor.GENERATED_PREFIX, "\t\t");
                        _builder.append((Object)o, "\t\t");
                        _builder.append((Object)"_set(this) ;");
                        _builder.newLineIfNotEmpty();
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)f, "\t");
                        _builder.append((Object)".add(obj) ;");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"}");
                        _builder.newLine();
                    }
                };
                it.setBody(_client);
            };
            this.containingType.addMethod(_plus, _function);
        } else {
            Procedures.Procedure1 _function_1 = it -> {
                it.setVisibility(Visibility.PUBLIC);
                it.addParameter("obj", this.field.getType());
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"if (obj != ");
                        _builder.append((Object)f);
                        _builder.append((Object)") {");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"if (");
                        _builder.append((Object)f, "\t");
                        _builder.append((Object)" != null)");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)f, "\t\t");
                        _builder.append((Object)".");
                        _builder.append((Object)OppositeProcessor.GENERATED_PREFIX, "\t\t");
                        _builder.append((Object)o, "\t\t");
                        _builder.append((Object)"_reset(");
                        boolean _isCollection = OppositeProcessor.this.isCollection(t);
                        if (_isCollection) {
                            _builder.append((Object)"this");
                        }
                        _builder.append((Object)") ;");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"if (obj != null)");
                        _builder.newLine();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"obj.");
                        _builder.append((Object)OppositeProcessor.GENERATED_PREFIX, "\t\t");
                        _builder.append((Object)o, "\t\t");
                        _builder.append((Object)"_set(this) ;");
                        _builder.newLineIfNotEmpty();
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)f, "\t");
                        _builder.append((Object)" = obj ;");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"}");
                        _builder.newLine();
                    }
                };
                it.setBody(_client);
            };
            this.containingType.addMethod(this.getSetterName(this.field), _function_1);
        }
    }

    protected void generateResetMethod() {
        final String f = this.field.getSimpleName();
        final String o = this.oppositeField.getSimpleName();
        final TypeReference t = this.oppositeField.getType();
        boolean _isCollection = this.isCollection(this.field.getType());
        if (_isCollection) {
            String _simpleName = this.field.getSimpleName();
            String _plus = GENERATED_PREFIX + _simpleName;
            String _plus_1 = String.valueOf(_plus) + "_reset";
            Procedures.Procedure1 _function = it -> {
                it.setVisibility(Visibility.PUBLIC);
                it.addParameter("obj", (TypeReference)IterableExtensions.head((Iterable)this.field.getType().getActualTypeArguments()));
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"if (");
                        _builder.append((Object)f);
                        _builder.append((Object)".contains(obj))");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        _builder.append((Object)f, "\t");
                        _builder.append((Object)".remove(obj) ;");
                        _builder.newLineIfNotEmpty();
                    }
                };
                it.setBody(_client);
            };
            this.containingType.addMethod(_plus_1, _function);
            String _firstUpper = StringExtensions.toFirstUpper((String)this.field.getSimpleName());
            String _plus_2 = "remove" + _firstUpper;
            Procedures.Procedure1 _function_1 = it -> {
                it.setVisibility(Visibility.PUBLIC);
                it.addParameter("obj", (TypeReference)IterableExtensions.head((Iterable)this.field.getType().getActualTypeArguments()));
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"if (obj != null)");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"obj.");
                        _builder.append((Object)OppositeProcessor.GENERATED_PREFIX, "\t");
                        _builder.append((Object)o, "\t");
                        _builder.append((Object)"_reset(");
                        boolean _isCollection = OppositeProcessor.this.isCollection(t);
                        if (_isCollection) {
                            _builder.append((Object)"this");
                        }
                        _builder.append((Object)") ;");
                        _builder.newLineIfNotEmpty();
                        _builder.newLine();
                        _builder.append((Object)f);
                        _builder.append((Object)".remove(obj) ;");
                        _builder.newLineIfNotEmpty();
                    }
                };
                it.setBody(_client);
            };
            this.containingType.addMethod(_plus_2, _function_1);
        } else {
            Procedures.Procedure1 _function_2 = it -> {
                it.setVisibility(Visibility.PUBLIC);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)f);
                        _builder.append((Object)" = null ;");
                    }
                };
                it.setBody(_client);
            };
            this.containingType.addMethod(GENERATED_PREFIX + f + "_reset", _function_2);
        }
    }

    protected void generateSetMethod() {
        final String f = this.field.getSimpleName();
        final String o = this.oppositeField.getSimpleName();
        final TypeReference t = this.oppositeField.getType();
        boolean _isCollection = this.isCollection(this.field.getType());
        if (_isCollection) {
            Procedures.Procedure1 _function = it -> {
                it.setVisibility(Visibility.PUBLIC);
                it.addParameter("obj", (TypeReference)IterableExtensions.head((Iterable)this.field.getType().getActualTypeArguments()));
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)f);
                        _builder.append((Object)".add(obj) ;");
                        _builder.newLineIfNotEmpty();
                    }
                };
                it.setBody(_client);
            };
            this.containingType.addMethod(GENERATED_PREFIX + f + "_set", _function);
        } else {
            Procedures.Procedure1 _function_1 = it -> {
                it.setVisibility(Visibility.PUBLIC);
                it.addParameter("obj", this.field.getType());
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"if (");
                        _builder.append((Object)f);
                        _builder.append((Object)" != null)");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        _builder.append((Object)f, "\t");
                        _builder.append((Object)".");
                        _builder.append((Object)OppositeProcessor.GENERATED_PREFIX, "\t");
                        _builder.append((Object)o, "\t");
                        _builder.append((Object)"_reset(");
                        boolean _isCollection = OppositeProcessor.this.isCollection(t);
                        if (_isCollection) {
                            _builder.append((Object)"this");
                        }
                        _builder.append((Object)") ;");
                        _builder.newLineIfNotEmpty();
                        _builder.newLine();
                        _builder.append((Object)f);
                        _builder.append((Object)" = obj ;");
                        _builder.newLineIfNotEmpty();
                    }
                };
                it.setBody(_client);
            };
            this.containingType.addMethod(GENERATED_PREFIX + f + "_set", _function_1);
        }
    }

    protected boolean check() {
        boolean _not;
        if (this.field.getType().isPrimitive() || this.field.getType().isWrapper()) {
            String _simpleName = this.field.getType().getSimpleName();
            String _plus = "Can't declare a primitive type " + _simpleName;
            String _plus_1 = String.valueOf(_plus) + " as opposite";
            this.context.addError((Element)this.field, _plus_1);
            return false;
        }
        if (this.oppositeField == null) {
            this.context.addError((Element)this.field, "Referenced opposite attribute doesn't exist");
            return false;
        }
        if (!this.isCollection(this.oppositeField.getType()) && !Objects.equal((Object)this.oppositeField.getType(), (Object)this.context.newTypeReference((Type)this.containingType, new TypeReference[0])) || this.isCollection(this.oppositeField.getType()) && !Objects.equal((Object)IterableExtensions.head((Iterable)this.oppositeField.getType().getActualTypeArguments()), (Object)this.context.newTypeReference((Type)this.containingType, new TypeReference[0]))) {
            String _simpleName_1 = this.oppositeField.getType().getSimpleName();
            String _plus_2 = "The opposite attribute type (" + _simpleName_1;
            String _plus_3 = String.valueOf(_plus_2) + ") doesn't match";
            this.context.addError((Element)this.field, _plus_3);
            return false;
        }
        if (IterableExtensions.exists((Iterable)this.field.getAnnotations(), it -> {
            AnnotationTypeDeclaration _annotationTypeDeclaration = it.getAnnotationTypeDeclaration();
            Type _type = this.context.newTypeReference(Composition.class, new TypeReference[0]).getType();
            return Objects.equal((Object)_annotationTypeDeclaration, (Object)_type);
        }) && IterableExtensions.exists((Iterable)this.oppositeField.getAnnotations(), it -> {
            AnnotationTypeDeclaration _annotationTypeDeclaration = it.getAnnotationTypeDeclaration();
            Type _type = this.context.newTypeReference(Composition.class, new TypeReference[0]).getType();
            return Objects.equal((Object)_annotationTypeDeclaration, (Object)_type);
        })) {
            this.context.addError((Element)this.field, "Can't declare as opposites two composition references");
            return false;
        }
        Functions.Function1 _function = it -> Objects.equal((Object)it.getAnnotationTypeDeclaration(), (Object)this.context.newTypeReference(Opposite.class, new TypeReference[0]).getType()) && it.getValue("value").equals(this.field.getSimpleName());
        boolean _exists = IterableExtensions.exists((Iterable)this.oppositeField.getAnnotations(), (Functions.Function1)_function);
        boolean bl = _not = !_exists;
        if (_not) {
            this.context.addError((Element)this.field, "The opposite attribute must be marked as opposite of this attribute");
            return false;
        }
        return true;
    }

    protected boolean isCollection(TypeReference type) {
        return this.context.newTypeReference(Collection.class, new TypeReference[]{this.context.newWildcardTypeReference()}).isAssignableFrom(type);
    }

    protected String getGetterName(MutableFieldDeclaration f) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("get");
        String _firstUpper = StringExtensions.toFirstUpper((String)f.getSimpleName());
        _builder.append(_firstUpper);
        return _builder.toString();
    }

    protected String getSetterName(MutableFieldDeclaration f) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("set");
        String _firstUpper = StringExtensions.toFirstUpper((String)f.getSimpleName());
        _builder.append(_firstUpper);
        return _builder.toString();
    }
}

