/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.ws.server;

import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.api.MessagingSystem;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.api.MessagingSystemManager;
import org.eclipse.gemoc.ws.server.endpoint.EndPointExtensionPointHelper;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.websocket.javax.server.config.JavaxWebSocketServletContainerInitializer;
import org.osgi.framework.BundleContext;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.gemoc.ws.server";
    public static final String CONSOLE_NAME = "GEMOC websocket server";
    private static Activator plugin;
    private BundleContext context;
    protected Server server;
    protected ServerContainer wsContainer;
    protected int assignedPort;
    protected MessagingSystem messaggingSystem = null;

    public static BundleContext getBundleContext() {
        return Activator.getDefault().context;
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static synchronized void logError(String message, Throwable ex) {
        if (message == null) {
            message = "";
        }
        Status errorStatus = new Status(4, PLUGIN_ID, 0, message, ex);
        Activator.getDefault().getLog().log((IStatus)errorStatus);
    }

    public static synchronized void logStatus(IStatus errorStatus) {
        Activator.getDefault().getLog().log(errorStatus);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.context = context;
        Job job = new Job("Start GEMOC WebSocket Server"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Activator.getDefault().startWSServer();
                }
                catch (Exception e) {
                    Activator.logError(e.getMessage(), e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.schedule();
    }

    public void stop(BundleContext context) throws Exception {
        this.stopWSServer();
        this.context = null;
        plugin = null;
        super.stop(context);
    }

    public synchronized void startWSServer() throws Exception {
        this.server = new Server(0);
        ServletContextHandler handler = new ServletContextHandler((HandlerContainer)this.server, "/");
        this.server.setHandler((Handler)handler);
        JavaxWebSocketServletContainerInitializer.configure((ServletContextHandler)handler, (servletContext, container) -> {
            container.setDefaultMaxTextMessageBufferSize(131072);
            for (Class<?> endPointClass : EndPointExtensionPointHelper.getAllEndPointClasses()) {
                try {
                    ServerEndpoint endPointAnnotation = endPointClass.getDeclaredAnnotation(ServerEndpoint.class);
                    if (endPointAnnotation == null) continue;
                    String path = endPointAnnotation.value();
                    Activator.info("Adding Endpoint class: " + endPointClass.getCanonicalName() + " on " + path);
                    container.addEndpoint(endPointClass);
                }
                catch (Exception e) {
                    Activator.error("Failed to add Enpoint class: " + endPointClass.getCanonicalName(), e);
                }
            }
        });
        this.server.start();
        this.assignedPort = this.server.getURI().getPort();
        Activator.info("Assigned port: " + this.server.getURI().getPort());
        this.server.dump((Appendable)System.err);
    }

    public synchronized void stopWSServer() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public Server getServer() {
        return this.server;
    }

    public int getAssignedPort() {
        return this.assignedPort;
    }

    public MessagingSystem getMessaggingSystem() {
        if (this.messaggingSystem == null) {
            MessagingSystemManager msm = new MessagingSystemManager();
            this.messaggingSystem = msm.createBestPlatformMessagingSystem(PLUGIN_ID, CONSOLE_NAME);
        }
        return this.messaggingSystem;
    }

    public static void info(String msg) {
        Activator.getDefault().getMessaggingSystem().info(msg, PLUGIN_ID);
    }

    public static void warn(String msg, Throwable e) {
        Activator.getDefault().getMessaggingSystem().warn(msg, PLUGIN_ID, e);
    }

    public static void error(String msg, Throwable e) {
        Activator.getDefault().getMessaggingSystem().error(msg, PLUGIN_ID, e);
    }
}

