/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ide.contentassist;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.descriptions.ITypeDescriptor;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ide.editor.contentassist.IIdeContentProposalAcceptor;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalProvider;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBasicForLoopExpression;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.ide.contentassist.IIdeTypesProposalProvider;
import org.eclipse.xtext.xbase.ide.contentassist.TypeFilters;
import org.eclipse.xtext.xbase.scoping.SyntaxFilteredScopes;
import org.eclipse.xtext.xbase.scoping.batch.IIdentifiableElementDescription;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;
import org.eclipse.xtext.xbase.services.XbaseGrammarAccess;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IExpressionScope;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xtype.XtypePackage;

public class XbaseIdeContentProposalProvider
extends IdeContentProposalProvider {
    @Inject
    private XbaseGrammarAccess xbaseGrammarAccess;
    @Inject
    private ValidFeatureDescription featureDescriptionPredicate;
    @Inject
    private IBatchTypeResolver typeResolver;
    @Inject
    private IIdeTypesProposalProvider typesProposalProvider;
    @Inject
    private SyntaxFilteredScopes syntaxFilteredScopes;

    public boolean filterKeyword(Keyword keyword, ContentAssistContext context) {
        String value = keyword.getValue();
        if (value.length() > 1 && Character.isLetter(value.charAt(0))) {
            EObject previousModel;
            if (("as".equals(value) || "instanceof".equals(value)) && (previousModel = context.getPreviousModel()) instanceof XExpression) {
                if (context.getPrefix().length() == 0 && NodeModelUtils.getNode((EObject)previousModel).getEndOffset() > context.getOffset()) {
                    return false;
                }
                LightweightTypeReference type = this.typeResolver.resolveTypes(previousModel).getActualType((XExpression)previousModel);
                if (type == null || type.isPrimitiveVoid()) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    protected void _createProposals(RuleCall ruleCall, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        if (this.xbaseGrammarAccess.getXExpressionRule().equals(ruleCall.getRule())) {
            if (ruleCall.eContainer() instanceof Group && "XParenthesizedExpression".equals(GrammarUtil.containingRule((EObject)ruleCall).getName())) {
                this.createLocalVariableAndImplicitProposals(context.getCurrentModel(), IExpressionScope.Anchor.WITHIN, context, acceptor);
            }
        } else {
            super._createProposals(ruleCall, context, acceptor);
        }
    }

    protected void _createProposals(Assignment assignment, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        EObject model = context.getCurrentModel();
        if (this.xbaseGrammarAccess.getXFeatureCallAccess().getFeatureAssignment_2().equals(assignment)) {
            this.completeXFeatureCall(model, context, acceptor);
        } else if (this.xbaseGrammarAccess.getXMemberFeatureCallAccess().getFeatureAssignment_1_0_0_0_2().equals(assignment) || this.xbaseGrammarAccess.getXMemberFeatureCallAccess().getFeatureAssignment_1_1_2().equals(assignment)) {
            this.completeXMemberFeatureCall(model, assignment, context, acceptor);
        } else if (this.xbaseGrammarAccess.getXBlockExpressionAccess().getExpressionsAssignment_2_0().equals(assignment) || this.xbaseGrammarAccess.getXExpressionInClosureAccess().getExpressionsAssignment_1_0().equals(assignment)) {
            this.completeWithinBlock(model, context, acceptor);
        } else if (this.xbaseGrammarAccess.getXAssignmentAccess().getFeatureAssignment_0_1().equals(assignment) || this.xbaseGrammarAccess.getXAssignmentAccess().getFeatureAssignment_1_1_0_0_1().equals(assignment)) {
            this.completeXAssignment(model, assignment, context, acceptor);
        } else if (this.xbaseGrammarAccess.getJvmParameterizedTypeReferenceAccess().getTypeAssignment_0().equals(assignment) || this.xbaseGrammarAccess.getJvmParameterizedTypeReferenceAccess().getTypeAssignment_1_4_1().equals(assignment)) {
            this.completeJavaTypes(TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE, context, acceptor);
        } else if (this.xbaseGrammarAccess.getXRelationalExpressionAccess().getTypeAssignment_1_0_1().equals(assignment)) {
            this.completeJavaTypes(TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE, context, acceptor);
        } else if (this.xbaseGrammarAccess.getXImportDeclarationAccess().getImportedTypeAssignment_1_0_2().equals(assignment) || this.xbaseGrammarAccess.getXImportDeclarationAccess().getImportedTypeAssignment_1_1().equals(assignment)) {
            this.completeJavaTypes(XtypePackage.Literals.XIMPORT_DECLARATION__IMPORTED_TYPE, context, acceptor);
        } else if (this.xbaseGrammarAccess.getXTypeLiteralAccess().getTypeAssignment_3().equals(assignment)) {
            this.completeJavaTypes(XbasePackage.Literals.XTYPE_LITERAL__TYPE, context, acceptor);
        } else if (this.xbaseGrammarAccess.getXConstructorCallAccess().getConstructorAssignment_2().equals(assignment)) {
            this.completeJavaTypes(TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE, context, TypeFilters.NON_ABSTRACT, acceptor);
        } else if (this.xbaseGrammarAccess.getXForLoopExpressionAccess().getEachExpressionAssignment_3().equals(assignment) || this.xbaseGrammarAccess.getXSwitchExpressionAccess().getDefaultAssignment_5_2().equals(assignment) || this.xbaseGrammarAccess.getXCasePartAccess().getCaseAssignment_2_1().equals(assignment) || this.xbaseGrammarAccess.getXCatchClauseAccess().getExpressionAssignment_4().equals(assignment) || this.xbaseGrammarAccess.getXBasicForLoopExpressionAccess().getUpdateExpressionsAssignment_7_0().equals(assignment) || this.xbaseGrammarAccess.getXBasicForLoopExpressionAccess().getUpdateExpressionsAssignment_7_1_1().equals(assignment) || this.xbaseGrammarAccess.getXBasicForLoopExpressionAccess().getExpressionAssignment_5().equals(assignment) || this.xbaseGrammarAccess.getXBasicForLoopExpressionAccess().getEachExpressionAssignment_9().equals(assignment) || this.xbaseGrammarAccess.getXClosureAccess().getExpressionAssignment_2().equals(assignment) || this.xbaseGrammarAccess.getXShortClosureAccess().getExpressionAssignment_1().equals(assignment)) {
            this.createLocalVariableAndImplicitProposals(model, IExpressionScope.Anchor.WITHIN, context, acceptor);
        } else if (this.xbaseGrammarAccess.getXForLoopExpressionAccess().getForExpressionAssignment_1().equals(assignment) || this.xbaseGrammarAccess.getXVariableDeclarationAccess().getRightAssignment_3_1().equals(assignment)) {
            this.createLocalVariableAndImplicitProposals(model, IExpressionScope.Anchor.BEFORE, context, acceptor);
        } else if (this.xbaseGrammarAccess.getXCasePartAccess().getThenAssignment_3_0_1().equals(assignment)) {
            this.createLocalVariableAndImplicitProposals(model, IExpressionScope.Anchor.AFTER, context, acceptor);
        } else if (this.xbaseGrammarAccess.getXOrExpressionAccess().getFeatureAssignment_1_0_0_1().equals(assignment) || this.xbaseGrammarAccess.getXAndExpressionAccess().getFeatureAssignment_1_0_0_1().equals(assignment) || this.xbaseGrammarAccess.getXEqualityExpressionAccess().getFeatureAssignment_1_0_0_1().equals(assignment) || this.xbaseGrammarAccess.getXRelationalExpressionAccess().getFeatureAssignment_1_1_0_0_1().equals(assignment) || this.xbaseGrammarAccess.getXOtherOperatorExpressionAccess().getFeatureAssignment_1_0_0_1().equals(assignment) || this.xbaseGrammarAccess.getXAdditiveExpressionAccess().getFeatureAssignment_1_0_0_1().equals(assignment) || this.xbaseGrammarAccess.getXMultiplicativeExpressionAccess().getFeatureAssignment_1_0_0_1().equals(assignment) || this.xbaseGrammarAccess.getXPostfixOperationAccess().getFeatureAssignment_1_0_1().equals(assignment)) {
            this.completeBinaryOperation(model, assignment, context, acceptor);
        } else if (this.xbaseGrammarAccess.getXBasicForLoopExpressionAccess().getInitExpressionsAssignment_3_0().equals(assignment) || this.xbaseGrammarAccess.getXBasicForLoopExpressionAccess().getInitExpressionsAssignment_3_1_1().equals(assignment)) {
            this.completeXBasicForLoopInit(model, context, acceptor);
        } else if (!this.xbaseGrammarAccess.getXUnaryOperationAccess().getFeatureAssignment_0_1().equals(assignment)) {
            super._createProposals(assignment, context, acceptor);
        }
    }

    protected void completeJavaTypes(EReference reference, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        this.completeJavaTypes(reference, context, (Predicate<? super ITypeDescriptor>)Predicates.alwaysTrue(), acceptor);
    }

    protected void completeJavaTypes(EReference reference, ContentAssistContext context, Predicate<? super ITypeDescriptor> filter, IIdeContentProposalAcceptor acceptor) {
        this.typesProposalProvider.createTypeProposals(reference, context, filter, acceptor);
    }

    protected void completeXFeatureCall(EObject model, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        ICompositeNode node;
        if (model != null && this.typeResolver.resolveTypes(model).hasExpressionScope(model, IExpressionScope.Anchor.WITHIN)) {
            return;
        }
        if (model instanceof XMemberFeatureCall && this.isInMemberFeatureCall(model, (node = NodeModelUtils.getNode((EObject)model)).getEndOffset(), context)) {
            return;
        }
        this.createLocalVariableAndImplicitProposals(model, IExpressionScope.Anchor.AFTER, context, acceptor);
    }

    protected void completeWithinBlock(EObject model, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)model);
        if (node.getOffset() >= context.getOffset()) {
            this.createLocalVariableAndImplicitProposals(model, IExpressionScope.Anchor.BEFORE, context, acceptor);
            return;
        }
        if (model instanceof XBlockExpression) {
            EList children = ((XBlockExpression)model).getExpressions();
            for (int i = children.size() - 1; i >= 0; --i) {
                XExpression child = (XExpression)children.get(i);
                ICompositeNode childNode = NodeModelUtils.getNode((EObject)child);
                if (childNode.getEndOffset() > context.getOffset()) continue;
                this.createLocalVariableAndImplicitProposals((EObject)child, IExpressionScope.Anchor.AFTER, context, acceptor);
                return;
            }
        }
        if (node.getEndOffset() <= context.getOffset()) {
            if (model instanceof XFeatureCall && model.eContainer() instanceof XClosure || node.getEndOffset() == context.getOffset() && context.getPrefix().length() == 0) {
                return;
            }
            if (this.isInMemberFeatureCall(model, node.getEndOffset(), context)) {
                return;
            }
            this.createLocalVariableAndImplicitProposals(model, IExpressionScope.Anchor.AFTER, context, acceptor);
            return;
        }
        if (this.isInMemberFeatureCall(model, node.getEndOffset(), context) || model instanceof XClosure) {
            return;
        }
        this.createLocalVariableAndImplicitProposals(model, IExpressionScope.Anchor.BEFORE, context, acceptor);
    }

    protected boolean isInMemberFeatureCall(EObject model, int endOffset, ContentAssistContext context) {
        INode featureNode;
        List featureNodes;
        return model instanceof XMemberFeatureCall && endOffset >= context.getOffset() && !(featureNodes = NodeModelUtils.findNodesForFeature((EObject)model, (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE)).isEmpty() && (featureNode = (INode)Iterables.getFirst((Iterable)featureNodes, null)).getTotalOffset() < context.getOffset() && featureNode.getTotalEndOffset() >= context.getOffset();
    }

    protected void completeXAssignment(EObject model, Assignment assignment, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        String ruleName = this.getConcreteSyntaxRuleName((AbstractElement)assignment);
        if (this.isOperatorRule(ruleName)) {
            this.completeBinaryOperation(model, assignment, context, acceptor);
        }
    }

    protected boolean isOperatorRule(String ruleName) {
        return ruleName != null && ruleName.startsWith("Op");
    }

    protected void completeBinaryOperation(EObject model, Assignment assignment, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        if (model instanceof XBinaryOperation) {
            if (context.getPrefix().length() == 0) {
                INode currentNode = context.getCurrentNode();
                int offset = currentNode.getOffset();
                int endOffset = currentNode.getEndOffset();
                if (offset < context.getOffset() && endOffset >= context.getOffset() && currentNode.getGrammarElement() instanceof CrossReference) {
                    return;
                }
            }
            if (NodeModelUtils.findActualNodeFor((EObject)model).getEndOffset() <= context.getOffset()) {
                this.createReceiverProposals((XExpression)model, (CrossReference)assignment.getTerminal(), context, acceptor);
            } else {
                this.createReceiverProposals(((XBinaryOperation)model).getLeftOperand(), (CrossReference)assignment.getTerminal(), context, acceptor);
            }
        } else {
            EObject previousModel = context.getPreviousModel();
            if (previousModel instanceof XExpression) {
                if (context.getPrefix().length() == 0 && NodeModelUtils.getNode((EObject)previousModel).getEndOffset() > context.getOffset()) {
                    return;
                }
                this.createReceiverProposals((XExpression)previousModel, (CrossReference)assignment.getTerminal(), context, acceptor);
            }
        }
    }

    protected void completeXBasicForLoopInit(EObject model, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)model);
        if (node.getOffset() >= context.getOffset()) {
            this.createLocalVariableAndImplicitProposals(model, IExpressionScope.Anchor.BEFORE, context, acceptor);
            return;
        }
        if (model instanceof XBasicForLoopExpression) {
            EList children = ((XBasicForLoopExpression)model).getInitExpressions();
            for (int i = children.size() - 1; i >= 0; --i) {
                XExpression child = (XExpression)children.get(i);
                ICompositeNode childNode = NodeModelUtils.getNode((EObject)child);
                if (childNode.getEndOffset() > context.getOffset()) continue;
                this.createLocalVariableAndImplicitProposals((EObject)child, IExpressionScope.Anchor.AFTER, context, acceptor);
                return;
            }
        }
        this.createLocalVariableAndImplicitProposals(model, IExpressionScope.Anchor.BEFORE, context, acceptor);
    }

    protected void completeXMemberFeatureCall(EObject model, Assignment assignment, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        if (model instanceof XMemberFeatureCall) {
            this.createReceiverProposals(((XMemberFeatureCall)model).getMemberCallTarget(), (CrossReference)assignment.getTerminal(), context, acceptor);
        } else if (model instanceof XAssignment) {
            this.createReceiverProposals(((XAssignment)model).getAssignable(), (CrossReference)assignment.getTerminal(), context, acceptor);
        }
    }

    protected void createLocalVariableAndImplicitProposals(EObject model, IExpressionScope.Anchor anchor, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        String prefix = context.getPrefix();
        if (prefix.length() > 0 && !Character.isJavaIdentifierStart(prefix.charAt(0))) {
            return;
        }
        IResolvedTypes resolvedTypes = null;
        resolvedTypes = model != null ? this.typeResolver.resolveTypes(model) : this.typeResolver.resolveTypes((Resource)context.getResource());
        IExpressionScope expressionScope = resolvedTypes.getExpressionScope(model, anchor);
        IScope scope = expressionScope.getFeatureScope();
        this.getCrossrefProposalProvider().lookupCrossReference(scope, this.xbaseGrammarAccess.getXFeatureCallAccess().getFeatureJvmIdentifiableElementCrossReference_2_0(), context, acceptor, (Predicate)this.featureDescriptionPredicate);
    }

    protected void createReceiverProposals(XExpression receiver, CrossReference crossReference, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        IResolvedTypes resolvedTypes = this.typeResolver.resolveTypes((EObject)receiver);
        LightweightTypeReference receiverType = resolvedTypes.getActualType(receiver);
        if (receiverType == null || receiverType.isPrimitiveVoid()) {
            return;
        }
        IExpressionScope expressionScope = resolvedTypes.getExpressionScope((EObject)receiver, IExpressionScope.Anchor.RECEIVER);
        IScope scope = null;
        EObject currentModel = context.getCurrentModel();
        scope = currentModel != receiver ? (currentModel instanceof XMemberFeatureCall && ((XMemberFeatureCall)currentModel).getMemberCallTarget() == receiver ? this.syntaxFilteredScopes.create(expressionScope.getFeatureScope((XAbstractFeatureCall)currentModel), (AbstractElement)crossReference) : this.syntaxFilteredScopes.create(expressionScope.getFeatureScope(), (AbstractElement)crossReference)) : this.syntaxFilteredScopes.create(expressionScope.getFeatureScope(), (AbstractElement)crossReference);
        this.getCrossrefProposalProvider().lookupCrossReference(scope, crossReference, context, acceptor, (Predicate)this.featureDescriptionPredicate);
    }

    protected String _getConcreteSyntaxRuleName(Assignment assignment) {
        return this.getConcreteSyntaxRuleName(assignment.getTerminal());
    }

    protected String _getConcreteSyntaxRuleName(CrossReference crossReference) {
        if (crossReference.getTerminal() instanceof RuleCall) {
            return this.getConcreteSyntaxRuleName(crossReference.getTerminal());
        }
        return null;
    }

    protected String _getConcreteSyntaxRuleName(RuleCall ruleCall) {
        return ruleCall.getRule().getName();
    }

    public void createProposals(AbstractElement element, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        if (element instanceof Assignment) {
            this._createProposals((Assignment)element, context, acceptor);
            return;
        }
        if (element instanceof CrossReference) {
            this._createProposals((CrossReference)element, context, acceptor);
            return;
        }
        if (element instanceof Keyword) {
            this._createProposals((Keyword)element, context, acceptor);
            return;
        }
        if (element instanceof RuleCall) {
            this._createProposals((RuleCall)element, context, acceptor);
            return;
        }
        if (element != null) {
            this._createProposals(element, context, acceptor);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(element, context, acceptor).toString());
    }

    protected String getConcreteSyntaxRuleName(AbstractElement element) {
        if (element instanceof Assignment) {
            return this._getConcreteSyntaxRuleName((Assignment)element);
        }
        if (element instanceof CrossReference) {
            return this._getConcreteSyntaxRuleName((CrossReference)element);
        }
        if (element instanceof RuleCall) {
            return this._getConcreteSyntaxRuleName((RuleCall)element);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(element).toString());
    }

    public static class ValidFeatureDescription
    implements Predicate<IEObjectDescription> {
        @Inject
        private OperatorMapping operatorMapping;

        public boolean apply(IEObjectDescription input) {
            if (input instanceof IIdentifiableElementDescription) {
                IIdentifiableElementDescription identifiableElementDescription = (IIdentifiableElementDescription)input;
                if (!identifiableElementDescription.isVisible() || !identifiableElementDescription.isValidStaticState()) {
                    return false;
                }
                if (identifiableElementDescription.getName().getFirstSegment().startsWith("operator_")) {
                    return this.operatorMapping.getOperator(identifiableElementDescription.getName()) == null;
                }
            }
            return true;
        }
    }
}

