/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.debugger;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gemoc.commons.eclipse.emf.EObjectUtil;
import org.eclipse.gemoc.executionframework.debugger.IMutableFieldExtractor;
import org.eclipse.gemoc.executionframework.debugger.MutableField;
import org.eclipse.gemoc.executionframework.engine.core.CommandExecution;
import org.eclipse.gemoc.xdsmlframework.commons.DynamicAnnotationHelper;
import org.eclipse.xtext.naming.DefaultDeclarativeQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;

public class AnnotationMutableFieldExtractor
implements IMutableFieldExtractor {
    private final DefaultDeclarativeQualifiedNameProvider nameprovider = new DefaultDeclarativeQualifiedNameProvider();

    @Override
    public List<MutableField> extractMutableField(final EObject eObject) {
        String _plus;
        String _name;
        ArrayList<MutableField> result = new ArrayList<MutableField>();
        EAttribute idProp = eObject.eClass().getEIDAttribute();
        String _xifexpression = null;
        if (idProp != null && eObject.eGet((EStructuralFeature)idProp) != null) {
            String _xblockexpression = null;
            Object id = eObject.eGet((EStructuralFeature)idProp);
            DecimalFormat formatter = new DecimalFormat("00");
            String _xifexpression_1 = null;
            _xifexpression_1 = id instanceof Integer ? formatter.format((Integer)id) : id.toString();
            String idString = _xifexpression_1;
            _name = eObject.eClass().getName();
            _plus = String.valueOf(_name) + "_";
            _xifexpression = _xblockexpression = String.valueOf(_plus) + idString;
        } else {
            String _xblockexpression_1 = null;
            QualifiedName qname = this.nameprovider.getFullyQualifiedName(eObject);
            String _xifexpression_1 = null;
            if (qname != null) {
                _xifexpression_1 = qname.toString();
            } else {
                String _xblockexpression_2 = null;
                String uriBasedName = EObjectUtil.getResourceBasedName((EObject)eObject, (boolean)false);
                String _xifexpression_2 = null;
                _xifexpression_2 = uriBasedName != null ? uriBasedName : eObject.toString();
                _xifexpression_1 = _xblockexpression_2 = _xifexpression_2;
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        }
        String objectName = _xifexpression;
        EList _eAllStructuralFeatures = eObject.eClass().getEAllStructuralFeatures();
        for (final EStructuralFeature prop : _eAllStructuralFeatures) {
            boolean _isDynamic = DynamicAnnotationHelper.isDynamic((EStructuralFeature)prop);
            if (!_isDynamic) continue;
            _name = prop.getName();
            _plus = String.valueOf(_name) + " ([";
            String _name_1 = eObject.eClass().getName();
            String _plus_1 = String.valueOf(_plus) + _name_1;
            String _plus_2 = String.valueOf(_plus_1) + "] ";
            String _plus_3 = String.valueOf(_plus_2) + objectName;
            String _plus_4 = String.valueOf(_plus_3) + ")";
            Supplier<Object> _function = () -> eObject.eGet(prop);
            Consumer<Object> _function_1 = o -> {
                TransactionalEditingDomain ed = TransactionUtil.getEditingDomain((Resource)eObject.eResource());
                String _name_2 = prop.getName();
                String _plus_5 = "Setting value " + o + " in " + objectName + "." + _name_2;
                String _plus_6 = String.valueOf(_plus_5) + " from the debugger";
                RecordingCommand command = new RecordingCommand(ed, _plus_6){

                    protected void doExecute() {
                        eObject.eSet(prop, o);
                    }
                };
                CommandExecution.execute((TransactionalEditingDomain)ed, (RecordingCommand)command);
            };
            MutableField mut = new MutableField(_plus_4, eObject, prop, _function, _function_1);
            result.add(mut);
        }
        return result;
    }
}

