/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.codeexecution.persistentoptions;

import fr.inria.aoste.timesquare.backend.codeexecution.behaviors.CodeExecutionBehavior;
import fr.inria.aoste.timesquare.backend.codeexecution.behaviors.CodeExecutionClockBehavior;
import fr.inria.aoste.timesquare.backend.codeexecution.persistentoptions.Variable;
import fr.inria.aoste.timesquare.backend.manager.visible.ClockEntity;
import fr.inria.aoste.timesquare.backend.manager.visible.PersistentOptions;
import fr.inria.aoste.timesquare.trace.util.ReferenceNameBuilder;
import fr.inria.aoste.trace.ModelElementReference;
import java.util.ArrayList;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;

public abstract class CodeExecutionPersistentOptions
implements PersistentOptions {
    private static final long serialVersionUID = 8658086849972634369L;
    protected String _serializedMethod;
    protected String _methodName;
    protected Variable variable;
    protected ArrayList<String> clocksQualifiedNameToForce;

    public CodeExecutionPersistentOptions() {
    }

    public CodeExecutionPersistentOptions(CodeExecutionBehavior codeExecutionBehavior) {
        if (codeExecutionBehavior != null) {
            if (codeExecutionBehavior.getMethod() != null) {
                this._serializedMethod = this.getStringFromJavaElement((IJavaElement)codeExecutionBehavior.getMethod());
                this._methodName = null;
            } else {
                this._methodName = codeExecutionBehavior.getMethodName();
                this._serializedMethod = null;
            }
            this.variable = codeExecutionBehavior.getVariable();
            this.clocksQualifiedNameToForce = new ArrayList();
            if (codeExecutionBehavior instanceof CodeExecutionClockBehavior) {
                String separator = "::";
                for (ClockEntity ce : ((CodeExecutionClockBehavior)codeExecutionBehavior).getClocksToForce()) {
                    ModelElementReference mer = ce.getModelElementReference();
                    String qualifiedName = ReferenceNameBuilder.buildQualifiedName((ModelElementReference)mer, (String)separator);
                    this.clocksQualifiedNameToForce.add(qualifiedName);
                }
            }
        }
    }

    public String getDescription() {
        return null;
    }

    protected IJavaElement getJavaElementFromString(String s) {
        try {
            return JavaCore.create((String)s);
        }
        catch (Throwable t) {
            return null;
        }
    }

    protected String getStringFromJavaElement(IJavaElement javaElement) {
        if (javaElement != null) {
            String ret = javaElement.getHandleIdentifier();
            return ret;
        }
        return null;
    }

    public Variable getVariable() {
        return this.variable;
    }

    public void setVariable(Variable variable) {
        this.variable = variable;
    }
}

