/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.clocktree.generator;

import fr.inria.aoste.timesquare.ccslkernel.clocktree.generator.ClockTreeConstructor;
import fr.inria.aoste.timesquare.ccslkernel.clocktree.generator.CoincidentClocks;
import fr.inria.aoste.timesquare.ccslkernel.clocktree.generator.Edge;
import fr.inria.aoste.timesquare.ccslkernel.clocktree.generator.EdgeKind;
import fr.inria.aoste.timesquare.ccslkernel.clocktree.generator.KernelExpressionClockTreeBuilder;
import fr.inria.aoste.timesquare.ccslkernel.clocktree.generator.KernelRelationClockTreeBuilder;
import fr.inria.aoste.timesquare.ccslkernel.clocktree.generator.VertexKind;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.KernelExpressionDeclaration;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelRelation.KernelRelationDeclaration;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.UserExpressionDefinition;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.InstantiatedElement;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.UnfoldModel;
import grph.oo.ObjectGrph;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class GrphClockTreeConstructor
implements ClockTreeConstructor {
    private UnfoldModel unfoldModel;
    private ObjectGrph<CoincidentClocks, Edge> g = new ObjectGrph();

    public GrphClockTreeConstructor() {
        System.gc();
        try {
            ClassLoader.getSystemClassLoader().setDefaultAssertionStatus(true);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    @Override
    public UnfoldModel getUnfoldModel() {
        return this.unfoldModel;
    }

    public ObjectGrph<CoincidentClocks, Edge> createClockGrphDag(Resource ccslResource) {
        try {
            this.unfoldModel = UnfoldModel.unfoldModel((Resource)ccslResource);
        }
        catch (Throwable throwable) {
            String message = throwable.getMessage();
            if (message == null) {
                message = String.valueOf(throwable.getClass().getName()) + " has throw !!";
            }
            message = "During solver.loadModel(URI) : " + message;
            throw new RuntimeException(message, throwable);
        }
        List concretes = this.unfoldModel.getInstantiationTree().lookupInstances(null);
        for (InstantiatedElement concrete : concretes) {
            if (!concrete.isKernelRelation() || concrete.getDefinition().getName() != "Coincides") continue;
            this.addCorrespondingVertexAndEdge(concrete);
        }
        for (InstantiatedElement concrete : concretes) {
            if (concrete.isKernelRelation() && concrete.getDefinition().getName() == "Coincides") continue;
            this.addCorrespondingVertexAndEdge(concrete);
        }
        for (Edge e : this.g.getEdges()) {
            if (e.ek != EdgeKind.COINCIDES) continue;
            CoincidentClocks source = (CoincidentClocks)this.g.getDirectedSimpleEdgeTail((Object)e);
            CoincidentClocks target = (CoincidentClocks)this.g.getDirectedSimpleEdgeHead((Object)e);
            source.addAll(target);
            target.addAll(source);
        }
        return this.g;
    }

    @Override
    public ObjectGrph<CoincidentClocks, Edge> createClockGrphDag(String ccslSpecificationPath) {
        try {
            this.unfoldModel = UnfoldModel.unfoldModel((URI)URI.createURI((String)ccslSpecificationPath));
        }
        catch (Throwable throwable) {
            String message = throwable.getMessage();
            if (message == null) {
                message = String.valueOf(throwable.getClass().getName()) + " has throw !!";
            }
            message = "During UnfoldModel.unfoldModel(URI) : " + message;
            throw new RuntimeException(message, throwable);
        }
        List concretes = this.unfoldModel.getInstantiationTree().lookupInstances(null);
        for (InstantiatedElement concrete : concretes) {
            this.addCorrespondingVertexAndEdge(concrete);
        }
        return this.g;
    }

    private void addCorrespondingVertexAndEdge(InstantiatedElement concrete) {
        if (concrete.isExpression()) {
            if (concrete.isKernelExpression()) {
                KernelExpressionDeclaration declaration = (KernelExpressionDeclaration)concrete.getDeclaration();
                KernelExpressionClockTreeBuilder builder = new KernelExpressionClockTreeBuilder(concrete, this);
                builder.doSwitch((EObject)declaration);
            } else if (concrete.isConditional() && !concrete.isTailRecursiveCall()) {
                for (InstantiatedElement c_ie : concrete.getSons()) {
                    if (!c_ie.isConditionCase()) continue;
                    this.addConditional(concrete, c_ie);
                }
            } else {
                assert (concrete.getDefinition() != null);
                if (concrete.getDefinition() instanceof UserExpressionDefinition && !concrete.isRecursiveCall()) {
                    InstantiatedElement rootExprElement = concrete.getRootExpression();
                    this.addCoincidence(rootExprElement, concrete, false);
                }
            }
        } else if (concrete.isRelation()) {
            if (concrete.isKernelRelation()) {
                KernelRelationDeclaration declaration = (KernelRelationDeclaration)concrete.getDeclaration();
                KernelRelationClockTreeBuilder builder = new KernelRelationClockTreeBuilder(concrete, this);
                builder.doSwitch((EObject)declaration);
            } else {
                concrete.isConditional();
            }
        }
    }

    private CoincidentClocks addOrCreateListOf(InstantiatedElement elt) {
        CoincidentClocks l_concrete = this.getListOf(elt);
        if (l_concrete == null) {
            l_concrete = new CoincidentClocks();
            l_concrete.add(elt);
        }
        return l_concrete;
    }

    private CoincidentClocks getListOf(InstantiatedElement concrete) {
        for (CoincidentClocks l_concrete : this.g.getVertices()) {
            if (!l_concrete.contains(concrete)) continue;
            return l_concrete;
        }
        return null;
    }

    @Override
    public void addCoincidence(InstantiatedElement c1, InstantiatedElement c2, boolean isCond) {
        int nbVerticesBefore = this.g.getVertices().size();
        int nbEdgesBefore = this.g.getEdges().size();
        assert (c1 != null);
        assert (c2 != null);
        CoincidentClocks l_c1 = this.addOrCreateListOf(c1);
        CoincidentClocks l_c2 = this.addOrCreateListOf(c2);
        if (!this.g.getVertices().contains(l_c1) && !this.g.getVertices().contains(l_c2)) {
            l_c2.addAll(l_c1);
            this.g.addVertex((Object)l_c2);
            return;
        }
        if (!this.g.getVertices().contains(l_c1) && this.g.getVertices().contains(l_c2)) {
            l_c2.addAll(l_c1);
            return;
        }
        if (this.g.getVertices().contains(l_c1) && !this.g.getVertices().contains(l_c2)) {
            l_c1.addAll(l_c2);
            return;
        }
        if (!this.g.hasIncidentEdges((Object)l_c1) && !this.g.hasIncidentEdges((Object)l_c2)) {
            if (l_c1.getKind() != VertexKind.ClockSet) {
                l_c1.addAll(l_c2);
                this.g.removeVertex((Object)l_c2);
            } else {
                l_c2.addAll(l_c1);
                this.g.removeVertex((Object)l_c1);
            }
            int nbEdgesAfter = this.g.getEdges().size();
            assert (nbEdgesBefore == nbEdgesAfter);
            return;
        }
        Edge e = new Edge(EdgeKind.COINCIDES, isCond);
        l_c1.addAll(l_c2);
        l_c2.addAll(l_c1);
        if (!this.g.containsVertex((Object)l_c1)) {
            this.g.addVertex((Object)l_c2);
        }
        if (!this.g.containsVertex((Object)l_c2)) {
            this.g.addVertex((Object)l_c2);
        }
        this.g.addSimpleEdge((Object)l_c1, (Object)e, (Object)l_c2, false);
    }

    @Override
    public void addPrecedence(InstantiatedElement leftc, InstantiatedElement rightc, boolean isCond) {
        Edge e = new Edge(EdgeKind.PRECEDES, isCond);
        CoincidentClocks l_leftc = this.addOrCreateListOf(leftc);
        CoincidentClocks l_rightc = this.addOrCreateListOf(rightc);
        if (!this.g.containsVertex((Object)l_leftc)) {
            this.g.addVertex((Object)l_leftc);
        }
        if (!this.g.containsVertex((Object)l_rightc)) {
            this.g.addVertex((Object)l_rightc);
        }
        this.g.addSimpleEdge((Object)l_leftc, (Object)e, (Object)l_rightc, true);
    }

    @Override
    public void addCausality(InstantiatedElement leftc, InstantiatedElement rightc, boolean isCond) {
        Edge e = new Edge(EdgeKind.CAUSES, isCond);
        CoincidentClocks l_leftc = this.addOrCreateListOf(leftc);
        CoincidentClocks l_rightc = this.addOrCreateListOf(rightc);
        if (!this.g.containsVertex((Object)l_leftc)) {
            this.g.addVertex((Object)l_leftc);
        }
        if (!this.g.containsVertex((Object)l_rightc)) {
            this.g.addVertex((Object)l_rightc);
        }
        this.g.addSimpleEdge((Object)l_leftc, (Object)e, (Object)l_rightc, true);
    }

    @Override
    public void addExcludes(InstantiatedElement leftc, InstantiatedElement rightc, boolean isCond) {
        Edge e = new Edge(EdgeKind.EXCLUDES, isCond);
        CoincidentClocks l_leftc = this.addOrCreateListOf(leftc);
        CoincidentClocks l_rightc = this.addOrCreateListOf(rightc);
        if (!this.g.containsVertex((Object)l_leftc)) {
            this.g.addVertex((Object)l_leftc);
        }
        if (!this.g.containsVertex((Object)l_rightc)) {
            this.g.addVertex((Object)l_rightc);
        }
        this.g.addSimpleEdge((Object)l_leftc, (Object)e, (Object)l_rightc, true);
    }

    @Override
    public void addSubClockFree(InstantiatedElement hyperc, InstantiatedElement subc, boolean isCond) {
        Edge e = new Edge(EdgeKind.SUBCLOCKFREE, isCond);
        Edge e2 = new Edge(EdgeKind.CAUSES, isCond);
        CoincidentClocks l_hyperc = this.addOrCreateListOf(hyperc);
        CoincidentClocks l_subc = this.addOrCreateListOf(subc);
        if (!this.g.containsVertex((Object)l_hyperc)) {
            this.g.addVertex((Object)l_hyperc);
        }
        if (!this.g.containsVertex((Object)l_subc)) {
            this.g.addVertex((Object)l_subc);
        }
        this.g.addSimpleEdge((Object)l_hyperc, (Object)e, (Object)l_subc, true);
        this.g.addSimpleEdge((Object)l_hyperc, (Object)e2, (Object)l_subc, true);
    }

    @Override
    public void addSubClockConstrained(InstantiatedElement hyperc, String k_affine, InstantiatedElement subc, boolean isCond) {
        Edge e = new Edge(EdgeKind.SUBCLOCKCONSTRAINED, isCond);
        e.k_affineFunction = k_affine;
        Edge e2 = new Edge(EdgeKind.CAUSES, isCond);
        CoincidentClocks l_hyperc = this.addOrCreateListOf(hyperc);
        CoincidentClocks l_subc = this.addOrCreateListOf(subc);
        if (!this.g.containsVertex((Object)l_hyperc)) {
            this.g.addVertex((Object)l_hyperc);
        }
        if (!this.g.containsVertex((Object)l_subc)) {
            this.g.addVertex((Object)l_subc);
        }
        this.g.addSimpleEdge((Object)l_hyperc, (Object)e2, (Object)l_subc, true);
        this.g.addSimpleEdge((Object)l_hyperc, (Object)e, (Object)l_subc, true);
    }

    @Override
    public void addKiller(InstantiatedElement killer, InstantiatedElement res, boolean isCond) {
        Edge e = new Edge(EdgeKind.KILL, isCond);
        CoincidentClocks l_killer = this.addOrCreateListOf(killer);
        CoincidentClocks l_res = this.addOrCreateListOf(res);
        if (!this.g.containsVertex((Object)l_killer)) {
            this.g.addVertex((Object)l_killer);
        }
        if (!this.g.containsVertex((Object)l_res)) {
            this.g.addVertex((Object)l_res);
        }
        this.g.addSimpleEdge((Object)l_killer, (Object)e, (Object)l_res, true);
    }

    @Override
    public void addInfRelation(InstantiatedElement c1, InstantiatedElement c2, InstantiatedElement cres, boolean isCond) {
        Edge e1 = new Edge(EdgeKind.SUBCLOCKFREE, isCond);
        Edge e2 = new Edge(EdgeKind.SUBCLOCKFREE, isCond);
        Edge e3 = new Edge(EdgeKind.SUBCLOCKFREE, isCond);
        Edge e1cause = new Edge(EdgeKind.CAUSES, isCond);
        Edge e2cause = new Edge(EdgeKind.CAUSES, isCond);
        CoincidentClocks l_c1 = this.addOrCreateListOf(c1);
        CoincidentClocks l_c2 = this.addOrCreateListOf(c2);
        CoincidentClocks l_cres = this.addOrCreateListOf(cres);
        CoincidentClocks virtualVertex = new CoincidentClocks();
        if (!this.g.containsVertex((Object)virtualVertex)) {
            this.g.addVertex((Object)virtualVertex);
        }
        if (!this.g.containsVertex((Object)l_c1)) {
            this.g.addVertex((Object)l_c1);
        }
        if (!this.g.containsVertex((Object)l_c2)) {
            this.g.addVertex((Object)l_c2);
        }
        if (!this.g.containsVertex((Object)l_cres)) {
            this.g.addVertex((Object)l_cres);
        }
        virtualVertex.setKind(VertexKind.ImplicitSuperClock);
        this.g.addSimpleEdge((Object)virtualVertex, (Object)e1, (Object)l_c1, true);
        this.g.addSimpleEdge((Object)virtualVertex, (Object)e2, (Object)l_c2, true);
        this.g.addSimpleEdge((Object)virtualVertex, (Object)e3, (Object)l_cres, true);
        this.g.addSimpleEdge((Object)l_cres, (Object)e1cause, (Object)l_c1, true);
        this.g.addSimpleEdge((Object)l_cres, (Object)e2cause, (Object)l_c2, true);
    }

    @Override
    public void addSupRelation(InstantiatedElement c1, InstantiatedElement c2, InstantiatedElement cres, boolean isCond) {
        Edge e1 = new Edge(EdgeKind.SUBCLOCKFREE, isCond);
        Edge e2 = new Edge(EdgeKind.SUBCLOCKFREE, isCond);
        Edge e3 = new Edge(EdgeKind.SUBCLOCKFREE, isCond);
        Edge e1cause = new Edge(EdgeKind.CAUSES, isCond);
        Edge e2cause = new Edge(EdgeKind.CAUSES, isCond);
        CoincidentClocks l_c1 = this.addOrCreateListOf(c1);
        CoincidentClocks l_c2 = this.addOrCreateListOf(c2);
        CoincidentClocks l_cres = this.addOrCreateListOf(cres);
        CoincidentClocks virtualVertex = new CoincidentClocks();
        if (!this.g.containsVertex((Object)virtualVertex)) {
            this.g.addVertex((Object)virtualVertex);
        }
        if (!this.g.containsVertex((Object)l_c1)) {
            this.g.addVertex((Object)l_c1);
        }
        if (!this.g.containsVertex((Object)l_c2)) {
            this.g.addVertex((Object)l_c2);
        }
        if (!this.g.containsVertex((Object)l_cres)) {
            this.g.addVertex((Object)l_cres);
        }
        virtualVertex.setKind(VertexKind.ImplicitSuperClock);
        this.g.addSimpleEdge((Object)virtualVertex, (Object)e1, (Object)l_c1, true);
        this.g.addSimpleEdge((Object)virtualVertex, (Object)e2, (Object)l_c2, true);
        this.g.addSimpleEdge((Object)virtualVertex, (Object)e3, (Object)l_cres, true);
        this.g.addSimpleEdge((Object)l_c1, (Object)e1cause, (Object)l_cres, true);
        this.g.addSimpleEdge((Object)l_c2, (Object)e2cause, (Object)l_cres, true);
    }

    @Override
    public void addConcat(InstantiatedElement c1, InstantiatedElement c2, InstantiatedElement cres, boolean isCond) {
        if (c2 == cres) {
            this.addCoincidence(c1, c2, isCond);
        } else {
            Edge e1 = new Edge(EdgeKind.SEQCLOCK, isCond);
            Edge e2 = new Edge(EdgeKind.SEQCLOCK, isCond);
            Edge e1cause = new Edge(EdgeKind.CAUSES, isCond);
            Edge e2cause = new Edge(EdgeKind.CAUSES, isCond);
            CoincidentClocks l_c1 = this.addOrCreateListOf(c1);
            CoincidentClocks l_c2 = this.addOrCreateListOf(c2);
            CoincidentClocks l_cres = this.addOrCreateListOf(cres);
            if (!this.g.containsVertex((Object)l_c1)) {
                this.g.addVertex((Object)l_c1);
            }
            if (!this.g.containsVertex((Object)l_c2)) {
                this.g.addVertex((Object)l_c2);
            }
            if (!this.g.containsVertex((Object)l_cres)) {
                this.g.addVertex((Object)l_cres);
            }
            this.g.addSimpleEdge((Object)l_c1, (Object)e1, (Object)l_cres, true);
            this.g.addSimpleEdge((Object)l_c2, (Object)e2, (Object)l_cres, true);
            this.g.addSimpleEdge((Object)l_cres, (Object)e1cause, (Object)l_c1, true);
            this.g.addSimpleEdge((Object)l_cres, (Object)e2cause, (Object)l_c2, true);
            l_cres.setKind(VertexKind.ChoiceVertex);
        }
    }

    public ObjectGrph<CoincidentClocks, Edge> createClockGrphDag(UnfoldModel um) {
        this.unfoldModel = um;
        List concretes = um.getInstantiationTree().lookupInstances(null);
        for (InstantiatedElement concrete : concretes) {
            this.addCorrespondingVertexAndEdge(concrete);
        }
        return this.g;
    }

    @Override
    public void addConditional(InstantiatedElement leftc, InstantiatedElement rightc) {
        Edge e = new Edge(EdgeKind.CONDITIONAL, true);
        CoincidentClocks l_leftc = this.addOrCreateListOf(leftc);
        CoincidentClocks l_rightc = this.addOrCreateListOf(rightc);
        if (!this.g.containsVertex((Object)l_leftc)) {
            this.g.addVertex((Object)l_leftc);
        }
        if (!this.g.containsVertex((Object)l_rightc)) {
            this.g.addVertex((Object)l_rightc);
        }
        this.g.addSimpleEdge((Object)l_rightc, (Object)e, (Object)l_leftc, true);
    }

    @Override
    public void addSampledOnExpression(InstantiatedElement samplingClock, InstantiatedElement sampledClock, InstantiatedElement res, boolean isCond) {
        Edge e = new Edge(EdgeKind.SUBCLOCKCONSTRAINED, isCond);
        Edge e2 = new Edge(EdgeKind.PRECEDES, isCond);
        CoincidentClocks l_samplingClock = this.addOrCreateListOf(samplingClock);
        CoincidentClocks l_sampledClock = this.addOrCreateListOf(sampledClock);
        CoincidentClocks l_res = this.addOrCreateListOf(res);
        if (!this.g.containsVertex((Object)l_samplingClock)) {
            this.g.addVertex((Object)l_samplingClock);
        }
        if (!this.g.containsVertex((Object)l_sampledClock)) {
            this.g.addVertex((Object)l_sampledClock);
        }
        if (!this.g.containsVertex((Object)l_res)) {
            this.g.addVertex((Object)l_res);
        }
        this.g.addSimpleEdge((Object)l_samplingClock, (Object)e, (Object)l_res, true);
        this.g.addSimpleEdge((Object)l_sampledClock, (Object)e2, (Object)l_res, true);
    }

    @Override
    public void addNonStrictSampledOnExpression(InstantiatedElement samplingClock, InstantiatedElement sampledClock, InstantiatedElement res, boolean isCond) {
        Edge e = new Edge(EdgeKind.SUBCLOCKCONSTRAINED, isCond);
        Edge e2 = new Edge(EdgeKind.CAUSES, isCond);
        CoincidentClocks l_samplingClock = this.addOrCreateListOf(samplingClock);
        CoincidentClocks l_sampledClock = this.addOrCreateListOf(sampledClock);
        CoincidentClocks l_res = this.addOrCreateListOf(res);
        if (!this.g.containsVertex((Object)l_samplingClock)) {
            this.g.addVertex((Object)l_samplingClock);
        }
        if (!this.g.containsVertex((Object)l_sampledClock)) {
            this.g.addVertex((Object)l_sampledClock);
        }
        if (!this.g.containsVertex((Object)l_res)) {
            this.g.addVertex((Object)l_res);
        }
        this.g.addSimpleEdge((Object)l_samplingClock, (Object)e, (Object)l_res, true);
        this.g.addSimpleEdge((Object)l_sampledClock, (Object)e2, (Object)l_res, true);
    }
}

