/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.solver.statistics;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;

public class SolverRuntimeStats {
    private static Map<String, SolverRuntimeStats> statsByMethod = new HashMap<String, SolverRuntimeStats>();
    private static ArrayDeque<SolverRuntimeStats> callStack = new ArrayDeque();
    private String method;
    private long runtime = 0L;
    private long runtimeMin;
    private long runtimeMax = Long.MIN_VALUE;
    private long enterTime;
    private int invocations = 0;

    private SolverRuntimeStats(String method) {
        this.runtimeMin = Long.MAX_VALUE;
        this.method = method;
    }

    private static synchronized SolverRuntimeStats getRuntimeStats(String method) {
        SolverRuntimeStats stats = statsByMethod.get(method);
        if (stats == null) {
            stats = new SolverRuntimeStats(method);
            statsByMethod.put(method, stats);
        }
        return stats;
    }

    private long getRuntime() {
        return this.runtime;
    }

    public static synchronized void clearStats() {
        statsByMethod.clear();
    }

    public long getRuntime(String method) {
        SolverRuntimeStats stats = SolverRuntimeStats.getRuntimeStats(method);
        return stats.getRuntime();
    }

    public static void enterMethod(String method) {
        SolverRuntimeStats stats = SolverRuntimeStats.getRuntimeStats(method);
        callStack.push(stats);
        ++stats.invocations;
        stats.enterTime = System.nanoTime();
    }

    public static void leaveMethod(String method) {
        SolverRuntimeStats top = callStack.peek();
        if (top != null) {
            top.method.compareTo(method);
        }
        long runtime = System.nanoTime() - top.enterTime;
        top.runtime += runtime;
        if (runtime > top.runtimeMax) {
            top.runtimeMax = runtime;
        }
        if (runtime < top.runtimeMin) {
            top.runtimeMin = runtime;
        }
        top = callStack.pop();
    }

    public String toString() {
        return String.valueOf(this.method) + ": " + (double)this.runtime / 1000.0 + " us, " + this.invocations + " calls, " + (this.invocations > 0 ? (double)(this.runtime / (long)this.invocations) / 1000.0 : 0.0) + " us/call " + "(min: " + (double)this.runtimeMin / 1000.0 + ", max: " + (double)this.runtimeMax / 1000.0 + ")";
    }

    public static void print() {
        for (String method : statsByMethod.keySet()) {
            System.out.println(statsByMethod.get(method));
        }
    }
}

