/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.xtext.util;

import com.google.inject.Inject;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.BasicTypePackage;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.BooleanElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.CharElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.DiscreteClockType;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.Element;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.IntegerElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.PrimitiveElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.RealElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.RecordElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.SequenceElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.StringElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.Type;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.BooleanExpression;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.ClassicalExpression;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.IntegerExpression;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.RealExpression;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.SeqExpression;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.AbstractEntity;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.BindableEntity;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.Binding;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ClockExpressionAndRelationPackage;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ConcreteEntity;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.Expression;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ExpressionDefinition;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.Relation;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.RelationDefinition;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.Clock;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.NamedElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.scoping.impl.ImportUriResolver;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class BindingValidation
extends AbstractDeclarativeValidator {
    @Inject
    private ImportUriResolver resolver;

    @Check(value=CheckType.FAST)
    public void checkExpression(Expression r) {
        try {
            String name = "Expression " + r.getName() + " :";
            if (r.getType() == null) {
                this.error("missing Expression", (EStructuralFeature)ClockExpressionAndRelationPackage.eINSTANCE.getExpression_Type());
            }
            for (EObject eo : r.getType().eContents()) {
                if (!(eo instanceof AbstractEntity)) continue;
                boolean b = true;
                int n = -1;
                EList l = r.getBindings();
                int i = 0;
                while (i < l.size()) {
                    if (((Binding)l.get(i)).getAbstract() != null && ((Binding)l.get(i)).getAbstract().equals(eo)) {
                        if (n == -1) {
                            n = i;
                        } else {
                            if (b) {
                                this.error(String.valueOf(name) + " duplicated binding " + ((AbstractEntity)eo).getName(), (EObject)l.get(n), (EStructuralFeature)ClockExpressionAndRelationPackage.eINSTANCE.getBinding_Abstract(), n);
                            }
                            b = false;
                            this.error(String.valueOf(name) + " duplicated binding " + ((AbstractEntity)eo).getName(), (EObject)l.get(i), (EStructuralFeature)ClockExpressionAndRelationPackage.eINSTANCE.getBinding_Abstract(), i);
                        }
                    }
                    ++i;
                }
                if (n != -1) continue;
                this.error(String.valueOf(name) + " missing binding " + ((AbstractEntity)eo).getName(), (EStructuralFeature)ClockExpressionAndRelationPackage.eINSTANCE.getExpression_Type());
            }
        }
        catch (Throwable e) {
            System.err.println(e);
        }
    }

    @Check
    public void checkRelation(Relation r) {
        try {
            String name = "Relation " + r.getName() + " :";
            if (r.getType() == null) {
                this.error("missing Relation", (EStructuralFeature)ClockExpressionAndRelationPackage.eINSTANCE.getRelation_Type());
            }
            for (EObject eo : r.getType().eContents()) {
                if (!(eo instanceof AbstractEntity)) continue;
                boolean b = true;
                int n = -1;
                EList l = r.getBindings();
                int i = 0;
                while (i < l.size()) {
                    if (((Binding)l.get(i)).getAbstract() != null && ((Binding)l.get(i)).getAbstract().equals(eo)) {
                        if (n == -1) {
                            n = i;
                        } else {
                            if (b) {
                                this.error(String.valueOf(name) + " duplicated binding " + ((AbstractEntity)eo).getName(), (EObject)l.get(n), (EStructuralFeature)ClockExpressionAndRelationPackage.eINSTANCE.getBinding_Abstract(), n);
                            }
                            b = false;
                            this.error(String.valueOf(name) + " duplicated binding " + ((AbstractEntity)eo).getName(), (EObject)l.get(i), (EStructuralFeature)ClockExpressionAndRelationPackage.eINSTANCE.getBinding_Abstract(), i);
                        }
                    }
                    ++i;
                }
                if (n != -1) continue;
                this.error(String.valueOf(name) + " missing binding " + ((AbstractEntity)eo).getName(), (EStructuralFeature)ClockExpressionAndRelationPackage.eINSTANCE.getRelation_Type());
            }
        }
        catch (Throwable e) {
            System.err.println(e);
        }
    }

    @Check
    public void checkBinding(Binding b) {
        AbstractEntity abstractEntity = b.getAbstract();
        BindableEntity bindableEntity = b.getBindable();
        NamedElement defcontentbinding = this.getContainerDefinition((EObject)b);
        NamedElement defcontentbindableEntity = this.getContainerDefinition((EObject)bindableEntity);
        if (defcontentbinding != null && defcontentbindableEntity != null && defcontentbinding != defcontentbindableEntity) {
            this.error("binding (D): Definition", (EObject)b, (EStructuralFeature)ClockExpressionAndRelationPackage.eINSTANCE.getBinding_Bindable(), 0);
        }
        if (abstractEntity == null) {
            return;
        }
        if (bindableEntity == null) {
            return;
        }
        this.testbinding(abstractEntity, bindableEntity);
    }

    private void testbinding(AbstractEntity abstractEntity, BindableEntity bindableEntity) {
        IStatus status = BindingValidation.validateBinding(abstractEntity, bindableEntity);
        if (status.getSeverity() == 4) {
            this.errorBindind(status.getMessage());
        }
    }

    public static IStatus validateBinding(AbstractEntity abstractEntity, BindableEntity bindableEntity) {
        Type t2;
        Type t = abstractEntity.getType();
        if (bindableEntity instanceof AbstractEntity && (t2 = ((AbstractEntity)bindableEntity).getType()) != null && !t.getClass().isInstance(t2)) {
            return BindingValidation.createErrorStatus("binding (T3): type " + t.eClass().getName() + " -> " + t2.eClass().getName());
        }
        if (bindableEntity instanceof ConcreteEntity) {
            EClass ctype;
            if (bindableEntity instanceof Element && (ctype = BindingValidation.getType((Element)bindableEntity)) != null && t != null && !ctype.getInstanceClass().isAssignableFrom(t.getClass())) {
                return BindingValidation.createErrorStatus("binding (T0): type " + t.eClass().getName() + "-> " + ctype.getName());
            }
            if (bindableEntity instanceof Expression) {
                t2 = ((Expression)bindableEntity).getType().getReturnType();
                if (t2 != null) {
                    if (!t.getClass().isInstance(t2)) {
                        return BindingValidation.createErrorStatus("binding (T1.a): type " + t.eClass().getName() + " -> " + t2.eClass().getName() + " ");
                    }
                } else if (!(t instanceof DiscreteClockType)) {
                    return BindingValidation.createErrorStatus("binding (T1.b): type  ");
                }
            }
            if (bindableEntity instanceof Relation) {
                return BindingValidation.createErrorStatus("binding (T2): type [Relation ]");
            }
        }
        return Status.OK_STATUS;
    }

    public static EClass getType(Element e) {
        if (e.getType() != null) {
            return e.getType().eClass();
        }
        if (e instanceof Clock) {
            return BasicTypePackage.eINSTANCE.getDiscreteClockType();
        }
        if (e instanceof RecordElement) {
            return BasicTypePackage.eINSTANCE.getRecord();
        }
        if (e instanceof SequenceElement) {
            return BasicTypePackage.eINSTANCE.getSequenceType();
        }
        if (e instanceof PrimitiveElement) {
            if (e instanceof BooleanElement) {
                return BasicTypePackage.eINSTANCE.getBoolean();
            }
            if (e instanceof IntegerElement) {
                return BasicTypePackage.eINSTANCE.getInteger();
            }
            if (e instanceof RealElement) {
                return BasicTypePackage.eINSTANCE.getReal();
            }
            if (e instanceof StringElement) {
                return BasicTypePackage.eINSTANCE.getString();
            }
            if (e instanceof CharElement) {
                return BasicTypePackage.eINSTANCE.getChar();
            }
            if (e instanceof ClassicalExpression) {
                if (e instanceof BooleanExpression) {
                    return BasicTypePackage.eINSTANCE.getBoolean();
                }
                if (e instanceof IntegerExpression) {
                    return BasicTypePackage.eINSTANCE.getInteger();
                }
                if (e instanceof RealExpression) {
                    return BasicTypePackage.eINSTANCE.getReal();
                }
                if (e instanceof SeqExpression) {
                    return BasicTypePackage.eINSTANCE.getSequenceType();
                }
            }
        }
        return null;
    }

    private static IStatus createErrorStatus(String message) {
        return new Status(4, "fr.inria.aoste.timesqaure.ccslkernel.xtext.util", message);
    }

    public void errorBindind(String s) {
        try {
            this.error(s, (EStructuralFeature)ClockExpressionAndRelationPackage.eINSTANCE.getBinding_Bindable());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private NamedElement getContainerDefinition(EObject eo) {
        if (eo == null) {
            return null;
        }
        if (eo instanceof RelationDefinition) {
            return (NamedElement)eo;
        }
        if (eo instanceof ExpressionDefinition) {
            return (NamedElement)eo;
        }
        return this.getContainerDefinition(eo.eContainer());
    }

    public void register(EValidatorRegistrar registrar) {
    }

    public void setResolver(ImportUriResolver resolver) {
        this.resolver = resolver;
    }

    public ImportUriResolver getResolver() {
        return this.resolver;
    }
}

