/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.instantrelation.generator.metier;

import fr.inria.aoste.timesquare.instantrelation.CCSLRelationModel.CCSLConstraintRef;
import fr.inria.aoste.timesquare.instantrelation.CCSLRelationModel.CCSLRelationModelFactory;
import fr.inria.aoste.timesquare.instantrelation.CCSLRelationModel.Coincidence;
import fr.inria.aoste.timesquare.instantrelation.exceptions.ResolveClockConstraintException;
import fr.inria.aoste.timesquare.instantrelation.generator.metier.AbstractCreator;
import fr.inria.aoste.timesquare.instantrelation.generator.metier.Description;
import fr.inria.aoste.trace.EventOccurrence;
import fr.inria.aoste.trace.ModelElementReference;

public class CreatorCoincidence
extends AbstractCreator {
    protected final ModelElementReference left;
    protected final ModelElementReference right;

    public CreatorCoincidence(CCSLConstraintRef cref, ModelElementReference left, ModelElementReference right) {
        super(cref);
        this.left = left;
        this.right = right;
    }

    @Override
    public boolean addChecking() {
        return this.left != this.right && this.left != null && this.right != null;
    }

    public final Coincidence createRelationCoincidence(EventOccurrence a, EventOccurrence b) {
        if (a == b) {
            return null;
        }
        Coincidence relationCoincidence = CCSLRelationModelFactory.eINSTANCE.createCoincidence();
        relationCoincidence.getCoincidentOccurrences().add((Object)a);
        relationCoincidence.getCoincidentOccurrences().add((Object)b);
        return relationCoincidence;
    }

    public ModelElementReference getLeft() {
        return this.left;
    }

    public ModelElementReference getRight() {
        return this.right;
    }

    @Override
    public void resolve() throws ResolveClockConstraintException {
        try {
            EventOccurrence l = this.getEventOccurrenceOnStepTrace(this.getLeft());
            EventOccurrence r = this.getEventOccurrenceOnStepTrace(this.getRight());
            boolean bl = this.clockTick(l);
            boolean br = this.clockTick(r);
            if (bl && br && this.filter(l, r)) {
                this.addRelation(this.createRelationCoincidence(l, r));
            }
        }
        catch (Throwable e) {
            throw new ResolveClockConstraintException(e, this);
        }
    }

    public boolean filter(EventOccurrence left, EventOccurrence rigth) {
        return true;
    }

    @Override
    public Description createDescription() {
        return Description.createDescriptionCoincidence(this.left, this.right, this.getCcslConstraintRef());
    }

    @Override
    protected void init() {
    }
}

